/*
 * Decompiled with CFR 0.152.
 */
package de.kherud.llama;

import de.kherud.llama.CliParameters;
import de.kherud.llama.args.CacheType;
import de.kherud.llama.args.GpuSplitMode;
import de.kherud.llama.args.MiroStat;
import de.kherud.llama.args.NumaStrategy;
import de.kherud.llama.args.PoolingType;
import de.kherud.llama.args.RopeScalingType;
import de.kherud.llama.args.Sampler;

public final class ModelParameters
extends CliParameters {
    public ModelParameters setThreads(int nThreads) {
        this.parameters.put("--threads", String.valueOf(nThreads));
        return this;
    }

    public ModelParameters setThreadsBatch(int nThreads) {
        this.parameters.put("--threads-batch", String.valueOf(nThreads));
        return this;
    }

    public ModelParameters setCpuMask(String mask) {
        this.parameters.put("--cpu-mask", mask);
        return this;
    }

    public ModelParameters setCpuRange(String range) {
        this.parameters.put("--cpu-range", range);
        return this;
    }

    public ModelParameters setCpuStrict(int strictCpu) {
        this.parameters.put("--cpu-strict", String.valueOf(strictCpu));
        return this;
    }

    public ModelParameters setPriority(int priority) {
        if (priority < 0 || priority > 3) {
            throw new IllegalArgumentException("Invalid value for priority");
        }
        this.parameters.put("--prio", String.valueOf(priority));
        return this;
    }

    public ModelParameters setPoll(int poll) {
        this.parameters.put("--poll", String.valueOf(poll));
        return this;
    }

    public ModelParameters setCpuMaskBatch(String mask) {
        this.parameters.put("--cpu-mask-batch", mask);
        return this;
    }

    public ModelParameters setCpuRangeBatch(String range) {
        this.parameters.put("--cpu-range-batch", range);
        return this;
    }

    public ModelParameters setCpuStrictBatch(int strictCpuBatch) {
        this.parameters.put("--cpu-strict-batch", String.valueOf(strictCpuBatch));
        return this;
    }

    public ModelParameters setPriorityBatch(int priorityBatch) {
        if (priorityBatch < 0 || priorityBatch > 3) {
            throw new IllegalArgumentException("Invalid value for priority batch");
        }
        this.parameters.put("--prio-batch", String.valueOf(priorityBatch));
        return this;
    }

    public ModelParameters setPollBatch(int pollBatch) {
        this.parameters.put("--poll-batch", String.valueOf(pollBatch));
        return this;
    }

    public ModelParameters setCtxSize(int ctxSize) {
        this.parameters.put("--ctx-size", String.valueOf(ctxSize));
        return this;
    }

    public ModelParameters setPredict(int nPredict) {
        this.parameters.put("--predict", String.valueOf(nPredict));
        return this;
    }

    public ModelParameters setBatchSize(int batchSize) {
        this.parameters.put("--batch-size", String.valueOf(batchSize));
        return this;
    }

    public ModelParameters setUbatchSize(int ubatchSize) {
        this.parameters.put("--ubatch-size", String.valueOf(ubatchSize));
        return this;
    }

    public ModelParameters setKeep(int keep) {
        this.parameters.put("--keep", String.valueOf(keep));
        return this;
    }

    public ModelParameters disableContextShift() {
        this.parameters.put("--no-context-shift", null);
        return this;
    }

    public ModelParameters enableFlashAttn() {
        this.parameters.put("--flash-attn", null);
        return this;
    }

    public ModelParameters disablePerf() {
        this.parameters.put("--no-perf", null);
        return this;
    }

    public ModelParameters enableEscape() {
        this.parameters.put("--escape", null);
        return this;
    }

    public ModelParameters disableEscape() {
        this.parameters.put("--no-escape", null);
        return this;
    }

    public ModelParameters enableSpecial() {
        this.parameters.put("--special", null);
        return this;
    }

    public ModelParameters skipWarmup() {
        this.parameters.put("--no-warmup", null);
        return this;
    }

    public ModelParameters setSpmInfill() {
        this.parameters.put("--spm-infill", null);
        return this;
    }

    public ModelParameters setSamplers(Sampler ... samplers) {
        if (samplers.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < samplers.length; ++i) {
                Sampler sampler = samplers[i];
                builder.append(sampler.name().toLowerCase());
                if (i >= samplers.length - 1) continue;
                builder.append(";");
            }
            this.parameters.put("--samplers", builder.toString());
        }
        return this;
    }

    public ModelParameters setSeed(long seed) {
        this.parameters.put("--seed", String.valueOf(seed));
        return this;
    }

    public ModelParameters ignoreEos() {
        this.parameters.put("--ignore-eos", null);
        return this;
    }

    public ModelParameters setTemp(float temp) {
        this.parameters.put("--temp", String.valueOf(temp));
        return this;
    }

    public ModelParameters setTopK(int topK) {
        this.parameters.put("--top-k", String.valueOf(topK));
        return this;
    }

    public ModelParameters setTopP(float topP) {
        this.parameters.put("--top-p", String.valueOf(topP));
        return this;
    }

    public ModelParameters setMinP(float minP) {
        this.parameters.put("--min-p", String.valueOf(minP));
        return this;
    }

    public ModelParameters setXtcProbability(float xtcProbability) {
        this.parameters.put("--xtc-probability", String.valueOf(xtcProbability));
        return this;
    }

    public ModelParameters setXtcThreshold(float xtcThreshold) {
        this.parameters.put("--xtc-threshold", String.valueOf(xtcThreshold));
        return this;
    }

    public ModelParameters setTypical(float typP) {
        this.parameters.put("--typical", String.valueOf(typP));
        return this;
    }

    public ModelParameters setRepeatLastN(int repeatLastN) {
        if (repeatLastN < -1) {
            throw new RuntimeException("Invalid repeat-last-n value");
        }
        this.parameters.put("--repeat-last-n", String.valueOf(repeatLastN));
        return this;
    }

    public ModelParameters setRepeatPenalty(float repeatPenalty) {
        this.parameters.put("--repeat-penalty", String.valueOf(repeatPenalty));
        return this;
    }

    public ModelParameters setPresencePenalty(float presencePenalty) {
        this.parameters.put("--presence-penalty", String.valueOf(presencePenalty));
        return this;
    }

    public ModelParameters setFrequencyPenalty(float frequencyPenalty) {
        this.parameters.put("--frequency-penalty", String.valueOf(frequencyPenalty));
        return this;
    }

    public ModelParameters setDryMultiplier(float dryMultiplier) {
        this.parameters.put("--dry-multiplier", String.valueOf(dryMultiplier));
        return this;
    }

    public ModelParameters setDryBase(float dryBase) {
        this.parameters.put("--dry-base", String.valueOf(dryBase));
        return this;
    }

    public ModelParameters setDryAllowedLength(int dryAllowedLength) {
        this.parameters.put("--dry-allowed-length", String.valueOf(dryAllowedLength));
        return this;
    }

    public ModelParameters setDryPenaltyLastN(int dryPenaltyLastN) {
        if (dryPenaltyLastN < -1) {
            throw new RuntimeException("Invalid dry-penalty-last-n value");
        }
        this.parameters.put("--dry-penalty-last-n", String.valueOf(dryPenaltyLastN));
        return this;
    }

    public ModelParameters setDrySequenceBreaker(String drySequenceBreaker) {
        this.parameters.put("--dry-sequence-breaker", drySequenceBreaker);
        return this;
    }

    public ModelParameters setDynatempRange(float dynatempRange) {
        this.parameters.put("--dynatemp-range", String.valueOf(dynatempRange));
        return this;
    }

    public ModelParameters setDynatempExponent(float dynatempExponent) {
        this.parameters.put("--dynatemp-exp", String.valueOf(dynatempExponent));
        return this;
    }

    public ModelParameters setMirostat(MiroStat mirostat) {
        this.parameters.put("--mirostat", String.valueOf(mirostat.ordinal()));
        return this;
    }

    public ModelParameters setMirostatLR(float mirostatLR) {
        this.parameters.put("--mirostat-lr", String.valueOf(mirostatLR));
        return this;
    }

    public ModelParameters setMirostatEnt(float mirostatEnt) {
        this.parameters.put("--mirostat-ent", String.valueOf(mirostatEnt));
        return this;
    }

    public ModelParameters setLogitBias(String tokenIdAndBias) {
        this.parameters.put("--logit-bias", tokenIdAndBias);
        return this;
    }

    public ModelParameters setGrammar(String grammar) {
        this.parameters.put("--grammar", grammar);
        return this;
    }

    public ModelParameters setGrammarFile(String fileName) {
        this.parameters.put("--grammar-file", fileName);
        return this;
    }

    public ModelParameters setJsonSchema(String schema) {
        this.parameters.put("--json-schema", schema);
        return this;
    }

    public ModelParameters setPoolingType(PoolingType type) {
        this.parameters.put("--pooling", String.valueOf(type.getId()));
        return this;
    }

    public ModelParameters setRopeScaling(RopeScalingType type) {
        this.parameters.put("--rope-scaling", String.valueOf(type.getId()));
        return this;
    }

    public ModelParameters setRopeScale(float ropeScale) {
        this.parameters.put("--rope-scale", String.valueOf(ropeScale));
        return this;
    }

    public ModelParameters setRopeFreqBase(float ropeFreqBase) {
        this.parameters.put("--rope-freq-base", String.valueOf(ropeFreqBase));
        return this;
    }

    public ModelParameters setRopeFreqScale(float ropeFreqScale) {
        this.parameters.put("--rope-freq-scale", String.valueOf(ropeFreqScale));
        return this;
    }

    public ModelParameters setYarnOrigCtx(int yarnOrigCtx) {
        this.parameters.put("--yarn-orig-ctx", String.valueOf(yarnOrigCtx));
        return this;
    }

    public ModelParameters setYarnExtFactor(float yarnExtFactor) {
        this.parameters.put("--yarn-ext-factor", String.valueOf(yarnExtFactor));
        return this;
    }

    public ModelParameters setYarnAttnFactor(float yarnAttnFactor) {
        this.parameters.put("--yarn-attn-factor", String.valueOf(yarnAttnFactor));
        return this;
    }

    public ModelParameters setYarnBetaSlow(float yarnBetaSlow) {
        this.parameters.put("--yarn-beta-slow", String.valueOf(yarnBetaSlow));
        return this;
    }

    public ModelParameters setYarnBetaFast(float yarnBetaFast) {
        this.parameters.put("--yarn-beta-fast", String.valueOf(yarnBetaFast));
        return this;
    }

    public ModelParameters setGrpAttnN(int grpAttnN) {
        this.parameters.put("--grp-attn-n", String.valueOf(grpAttnN));
        return this;
    }

    public ModelParameters setGrpAttnW(int grpAttnW) {
        this.parameters.put("--grp-attn-w", String.valueOf(grpAttnW));
        return this;
    }

    public ModelParameters enableDumpKvCache() {
        this.parameters.put("--dump-kv-cache", null);
        return this;
    }

    public ModelParameters disableKvOffload() {
        this.parameters.put("--no-kv-offload", null);
        return this;
    }

    public ModelParameters setCacheTypeK(CacheType type) {
        this.parameters.put("--cache-type-k", type.name().toLowerCase());
        return this;
    }

    public ModelParameters setCacheTypeV(CacheType type) {
        this.parameters.put("--cache-type-v", type.name().toLowerCase());
        return this;
    }

    public ModelParameters setDefragThold(float defragThold) {
        this.parameters.put("--defrag-thold", String.valueOf(defragThold));
        return this;
    }

    public ModelParameters setParallel(int nParallel) {
        this.parameters.put("--parallel", String.valueOf(nParallel));
        return this;
    }

    public ModelParameters enableContBatching() {
        this.parameters.put("--cont-batching", null);
        return this;
    }

    public ModelParameters disableContBatching() {
        this.parameters.put("--no-cont-batching", null);
        return this;
    }

    public ModelParameters enableMlock() {
        this.parameters.put("--mlock", null);
        return this;
    }

    public ModelParameters disableMmap() {
        this.parameters.put("--no-mmap", null);
        return this;
    }

    public ModelParameters setNuma(NumaStrategy numaStrategy) {
        this.parameters.put("--numa", numaStrategy.name().toLowerCase());
        return this;
    }

    public ModelParameters setDevices(String devices) {
        this.parameters.put("--device", devices);
        return this;
    }

    public ModelParameters setGpuLayers(int gpuLayers) {
        this.parameters.put("--gpu-layers", String.valueOf(gpuLayers));
        return this;
    }

    public ModelParameters setSplitMode(GpuSplitMode splitMode) {
        this.parameters.put("--split-mode", splitMode.name().toLowerCase());
        return this;
    }

    public ModelParameters setTensorSplit(String tensorSplit) {
        this.parameters.put("--tensor-split", tensorSplit);
        return this;
    }

    public ModelParameters setMainGpu(int mainGpu) {
        this.parameters.put("--main-gpu", String.valueOf(mainGpu));
        return this;
    }

    public ModelParameters enableCheckTensors() {
        this.parameters.put("--check-tensors", null);
        return this;
    }

    public ModelParameters setOverrideKv(String keyValue) {
        this.parameters.put("--override-kv", keyValue);
        return this;
    }

    public ModelParameters addLoraAdapter(String fname) {
        this.parameters.put("--lora", fname);
        return this;
    }

    public ModelParameters addLoraScaledAdapter(String fname, float scale) {
        this.parameters.put("--lora-scaled", fname + "," + scale);
        return this;
    }

    public ModelParameters addControlVector(String fname) {
        this.parameters.put("--control-vector", fname);
        return this;
    }

    public ModelParameters addControlVectorScaled(String fname, float scale) {
        this.parameters.put("--control-vector-scaled", fname + "," + scale);
        return this;
    }

    public ModelParameters setControlVectorLayerRange(int start, int end) {
        this.parameters.put("--control-vector-layer-range", start + "," + end);
        return this;
    }

    public ModelParameters setModel(String model) {
        this.parameters.put("--model", model);
        return this;
    }

    public ModelParameters setModelUrl(String modelUrl) {
        this.parameters.put("--model-url", modelUrl);
        return this;
    }

    public ModelParameters setHfRepo(String hfRepo) {
        this.parameters.put("--hf-repo", hfRepo);
        return this;
    }

    public ModelParameters setHfFile(String hfFile) {
        this.parameters.put("--hf-file", hfFile);
        return this;
    }

    public ModelParameters setHfRepoV(String hfRepoV) {
        this.parameters.put("--hf-repo-v", hfRepoV);
        return this;
    }

    public ModelParameters setHfFileV(String hfFileV) {
        this.parameters.put("--hf-file-v", hfFileV);
        return this;
    }

    public ModelParameters setHfToken(String hfToken) {
        this.parameters.put("--hf-token", hfToken);
        return this;
    }

    public ModelParameters enableEmbedding() {
        this.parameters.put("--embedding", null);
        return this;
    }

    public ModelParameters enableReranking() {
        this.parameters.put("--reranking", null);
        return this;
    }

    public ModelParameters setCacheReuse(int cacheReuse) {
        this.parameters.put("--cache-reuse", String.valueOf(cacheReuse));
        return this;
    }

    public ModelParameters setSlotSavePath(String slotSavePath) {
        this.parameters.put("--slot-save-path", slotSavePath);
        return this;
    }

    public ModelParameters setChatTemplate(String chatTemplate) {
        this.parameters.put("--chat-template", chatTemplate);
        return this;
    }

    public ModelParameters setSlotPromptSimilarity(float similarity) {
        this.parameters.put("--slot-prompt-similarity", String.valueOf(similarity));
        return this;
    }

    public ModelParameters setLoraInitWithoutApply() {
        this.parameters.put("--lora-init-without-apply", null);
        return this;
    }

    public ModelParameters disableLog() {
        this.parameters.put("--log-disable", null);
        return this;
    }

    public ModelParameters setLogFile(String logFile) {
        this.parameters.put("--log-file", logFile);
        return this;
    }

    public ModelParameters setVerbose() {
        this.parameters.put("--verbose", null);
        return this;
    }

    public ModelParameters setLogVerbosity(int verbosity) {
        this.parameters.put("--log-verbosity", String.valueOf(verbosity));
        return this;
    }

    public ModelParameters enableLogPrefix() {
        this.parameters.put("--log-prefix", null);
        return this;
    }

    public ModelParameters enableLogTimestamps() {
        this.parameters.put("--log-timestamps", null);
        return this;
    }

    public ModelParameters setDraftMax(int draftMax) {
        this.parameters.put("--draft-max", String.valueOf(draftMax));
        return this;
    }

    public ModelParameters setDraftMin(int draftMin) {
        this.parameters.put("--draft-min", String.valueOf(draftMin));
        return this;
    }

    public ModelParameters setDraftPMin(float draftPMin) {
        this.parameters.put("--draft-p-min", String.valueOf(draftPMin));
        return this;
    }

    public ModelParameters setCtxSizeDraft(int ctxSizeDraft) {
        this.parameters.put("--ctx-size-draft", String.valueOf(ctxSizeDraft));
        return this;
    }

    public ModelParameters setDeviceDraft(String deviceDraft) {
        this.parameters.put("--device-draft", deviceDraft);
        return this;
    }

    public ModelParameters setGpuLayersDraft(int gpuLayersDraft) {
        this.parameters.put("--gpu-layers-draft", String.valueOf(gpuLayersDraft));
        return this;
    }

    public ModelParameters setModelDraft(String modelDraft) {
        this.parameters.put("--model-draft", modelDraft);
        return this;
    }

    public ModelParameters enableJinja() {
        this.parameters.put("--jinja", null);
        return this;
    }
}

