/*
 * Decompiled with CFR 0.152.
 */
package de.kherud.llama;

import de.kherud.llama.InferenceParameters;
import de.kherud.llama.LlamaModel;
import de.kherud.llama.LlamaOutput;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LlamaIterator
implements Iterator<LlamaOutput> {
    private final LlamaModel model;
    private final int taskId;
    private boolean hasNext = true;

    LlamaIterator(LlamaModel model, InferenceParameters parameters) {
        this.model = model;
        parameters.setStream(true);
        this.taskId = model.requestCompletion(parameters.toString());
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public LlamaOutput next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        LlamaOutput output = this.model.receiveCompletion(this.taskId);
        this.hasNext = !output.stop;
        return output;
    }

    public void cancel() {
        this.model.cancelCompletion(this.taskId);
        this.hasNext = false;
    }
}

