/*
 * Decompiled with CFR 0.152.
 */
package de.kherud.llama;

import de.kherud.llama.InferenceParameters;
import de.kherud.llama.LlamaException;
import de.kherud.llama.LlamaLoader;
import de.kherud.llama.ModelParameters;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class LlamaModel
implements AutoCloseable {
    private long ctx;

    public LlamaModel(ModelParameters parameters) {
        this.loadModel(parameters.toString());
    }

    public String complete(InferenceParameters parameters) {
        parameters.setStream(false);
        int taskId = this.requestCompletion(parameters.toString());
        Output output = this.receiveCompletion(taskId);
        return output.text;
    }

    public Iterable<Output> generate(InferenceParameters parameters) {
        return () -> new LlamaIterator(parameters);
    }

    public native float[] embed(String var1);

    public native int[] encode(String var1);

    public String decode(int[] tokens) {
        byte[] bytes = this.decodeBytes(tokens);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
        this.delete();
    }

    private native void loadModel(String var1) throws LlamaException;

    private native int requestCompletion(String var1) throws LlamaException;

    private native Output receiveCompletion(int var1) throws LlamaException;

    private native byte[] decodeBytes(int[] var1);

    private native void delete();

    static {
        LlamaLoader.initialize();
    }

    public static final class Output {
        @NotNull
        public final String text;
        @NotNull
        public final Map<String, Float> probabilities;
        private final boolean stop;

        private Output(byte[] generated, @NotNull Map<String, Float> probabilities, boolean stop) {
            this.text = new String(generated, StandardCharsets.UTF_8);
            this.probabilities = probabilities;
            this.stop = stop;
        }

        public String toString() {
            return this.text;
        }
    }

    private final class LlamaIterator
    implements Iterator<Output> {
        private final int taskId;
        private boolean hasNext = true;

        private LlamaIterator(InferenceParameters parameters) {
            parameters.setStream(true);
            this.taskId = LlamaModel.this.requestCompletion(parameters.toString());
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Output next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Output output = LlamaModel.this.receiveCompletion(this.taskId);
            this.hasNext = !output.stop;
            return output;
        }
    }
}

