/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import ai.vespa.cloud.SystemInfo;
import com.yahoo.cloud.config.DataplaneProxyConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jdisc.http.server.jetty.DataplaneProxyCredentials;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class DataplaneProxyService
extends AbstractComponent {
    private static final Logger logger = Logger.getLogger(DataplaneProxyService.class.getName());
    private static final String PREFIX = "/opt/vespa";
    private static final String CLOUD_AZURE = "azure";
    private final boolean useAzureProxy;
    private final Path configTemplate;
    private final Path serverCertificateFile;
    private final Path serverKeyFile;
    private final Path nginxConf;
    private final ProxyCommands proxyCommands;
    private final ScheduledThreadPoolExecutor executorService;
    private final Path root;
    private volatile NginxState state;
    private volatile NginxState wantedState;
    private DataplaneProxyConfig cfg;
    private Path proxyCredentialsCert;
    private Path proxyCredentialsKey;

    @Inject
    public DataplaneProxyService(SystemInfo systemInfo) {
        this(Paths.get(PREFIX, new String[0]), new NginxProxyCommands(), 1, CLOUD_AZURE.equalsIgnoreCase(systemInfo.cloud().name()));
    }

    public DataplaneProxyService() {
        this(Paths.get(PREFIX, new String[0]), new NginxProxyCommands(), 1, false);
    }

    DataplaneProxyService(Path root, ProxyCommands proxyCommands, int reloadPeriodMinutes) {
        this(root, proxyCommands, reloadPeriodMinutes, false);
    }

    private DataplaneProxyService(Path root, ProxyCommands proxyCommands, int reloadPeriodMinutes, boolean useAzureProxy) {
        this.root = root;
        this.proxyCommands = proxyCommands;
        this.useAzureProxy = useAzureProxy;
        this.changeState(NginxState.INITIALIZING);
        this.wantedState = NginxState.RUNNING;
        this.configTemplate = root.resolve("conf/nginx/nginx.conf.template");
        this.serverCertificateFile = root.resolve("conf/nginx/server_cert.pem");
        this.serverKeyFile = root.resolve("conf/nginx/server_key.pem");
        this.nginxConf = root.resolve("conf/nginx/nginx.conf");
        this.executorService = new ScheduledThreadPoolExecutor(1);
        this.executorService.scheduleAtFixedRate(this::converge, reloadPeriodMinutes, reloadPeriodMinutes, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(DataplaneProxyConfig config, DataplaneProxyCredentials credentialsProvider) {
        DataplaneProxyService dataplaneProxyService = this;
        synchronized (dataplaneProxyService) {
            this.cfg = config;
            this.proxyCredentialsCert = credentialsProvider.certificateFile();
            this.proxyCredentialsKey = credentialsProvider.keyFile();
        }
    }

    private void changeState(NginxState newState) {
        this.state = newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void converge() {
        NginxState convergeTo;
        Path proxyCredentialsKey;
        Path proxyCredentialsCert;
        DataplaneProxyConfig config;
        DataplaneProxyService dataplaneProxyService = this;
        synchronized (dataplaneProxyService) {
            config = this.cfg;
            proxyCredentialsCert = this.proxyCredentialsCert;
            proxyCredentialsKey = this.proxyCredentialsKey;
            this.cfg = null;
            this.proxyCredentialsCert = null;
            this.proxyCredentialsKey = null;
        }
        if (config != null) {
            try {
                String serverCert = config.serverCertificate();
                String serverKey = config.serverKey();
                boolean configChanged = false;
                configChanged |= this.writeFile(this.serverCertificateFile, serverCert);
                configChanged |= this.writeFile(this.serverKeyFile, serverKey);
                if (configChanged |= this.writeFile(this.nginxConf, DataplaneProxyService.nginxConfig(this.configTemplate, proxyCredentialsCert, proxyCredentialsKey, this.serverCertificateFile, this.serverKeyFile, config.mtlsPort(), config.tokenPort(), config.tokenEndpoints(), this.root, this.useAzureProxy))) {
                    logger.log(Level.INFO, "Configuring data plane proxy service. Token endpoints: [%s]".formatted(String.join((CharSequence)", ", config.tokenEndpoints())));
                }
                if (configChanged && this.state == NginxState.RUNNING) {
                    this.changeState(NginxState.RELOAD_REQUIRED);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reconfiguring data plane proxy", e);
            }
        }
        if ((convergeTo = this.wantedState) == NginxState.RUNNING) {
            boolean nginxRunning = this.proxyCommands.isRunning();
            if (!nginxRunning) {
                try {
                    this.proxyCommands.start(this.nginxConf);
                    this.changeState(convergeTo);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Failed to start nginx, will retry");
                    logger.log(Level.FINE, "Exception from nginx start", e);
                }
            } else if (this.state == NginxState.RELOAD_REQUIRED) {
                try {
                    this.proxyCommands.reload(this.nginxConf);
                    this.changeState(convergeTo);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Failed to reconfigure nginx, will retry.");
                    logger.log(Level.FINE, "Exception from nginx reload", e);
                }
            } else if (this.state != convergeTo) {
                this.changeState(convergeTo);
            }
        } else if (convergeTo == NginxState.STOPPED) {
            if (this.proxyCommands.isRunning()) {
                try {
                    this.proxyCommands.stop(this.nginxConf);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Failed to stop nginx, will retry");
                    logger.log(Level.FINE, "Exception from nginx stop", e);
                }
            }
            if (!this.proxyCommands.isRunning()) {
                this.changeState(convergeTo);
                this.executorService.shutdownNow();
            }
        } else {
            logger.warning("Unknown state " + String.valueOf((Object)convergeTo));
        }
    }

    public void deconstruct() {
        super.deconstruct();
        this.wantedState = NginxState.STOPPED;
        try {
            this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Error shutting down proxy reload thread", e);
        }
    }

    private boolean writeFile(Path file, String contents) throws IOException {
        Path tempPath = file.getParent().resolve(file.getFileName().toString() + ".new");
        Files.createDirectories(tempPath.getParent(), new FileAttribute[0]);
        Files.writeString(tempPath, (CharSequence)contents, new OpenOption[0]);
        if (!Files.exists(file, new LinkOption[0]) || Files.mismatch(tempPath, file) > 0L) {
            Files.move(tempPath, file, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        Files.delete(tempPath);
        return false;
    }

    static String nginxConfig(Path configTemplate, Path clientCert, Path clientKey, Path serverCert, Path serverKey, int vespaMtlsPort, int vespaTokenPort, List<String> tokenEndpoints, Path root, boolean useAzureProxy) {
        try {
            String nginxTemplate = Files.readString(configTemplate);
            String proxySuffix = useAzureProxy ? "" : "proxy_protocol";
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "proxy_protocol_suffix", proxySuffix);
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "client_cert", clientCert.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "client_key", clientKey.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "server_cert", serverCert.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "server_key", serverKey.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "vespa_mtls_port", Integer.toString(vespaMtlsPort));
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "vespa_token_port", Integer.toString(vespaTokenPort));
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "prefix", root.toString());
            String tokenmapping = tokenEndpoints.stream().map(arg_0 -> DataplaneProxyService.lambda$nginxConfig$0("        %s vespatoken;", arg_0)).collect(Collectors.joining("\n"));
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "vespa_token_endpoints", tokenmapping);
            return nginxTemplate;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not create data plane proxy configuration", e);
        }
    }

    private static String replace(String template, String key, String value) {
        return template.replace("${" + key + "}", value);
    }

    NginxState state() {
        return this.state;
    }

    NginxState wantedState() {
        return this.wantedState;
    }

    private static /* synthetic */ String lambda$nginxConfig$0(String rec$, Object xva$0) {
        return "        %s vespatoken;".formatted(xva$0);
    }

    public static class NginxProxyCommands
    implements ProxyCommands {
        @Override
        public void start(Path configFile) {
            try {
                Process startCommand = new ProcessBuilder(new String[0]).command("nginx", "-c", configFile.toString()).start();
                int exitCode = startCommand.waitFor();
                if (exitCode != 0) {
                    throw new RuntimeException("Non-zero exitcode from nginx: %d".formatted(exitCode));
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Could not start nginx", e);
            }
        }

        @Override
        public void stop(Path configFile) {
            try {
                Process stopCommand = new ProcessBuilder(new String[0]).command("nginx", "-s", "stop", "-c", configFile.toString()).start();
                int exitCode = stopCommand.waitFor();
                if (exitCode != 0) {
                    throw new RuntimeException("Non-zero exitcode from nginx: %d".formatted(exitCode));
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Could not start nginx", e);
            }
        }

        @Override
        public void reload(Path configFile) {
            try {
                Process reloadCommand = new ProcessBuilder(new String[0]).command("nginx", "-s", "reload", "-c", configFile.toString()).start();
                int exitCode = reloadCommand.waitFor();
                if (exitCode != 0) {
                    throw new RuntimeException("Non-zero exitcode from nginx: %d".formatted(exitCode));
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Could not start nginx", e);
            }
        }

        @Override
        public boolean isRunning() {
            return ProcessHandle.allProcesses().map(ProcessHandle::info).anyMatch(info -> info.command().orElse("").endsWith("nginx"));
        }
    }

    public static interface ProxyCommands {
        public void start(Path var1);

        public void stop(Path var1);

        public void reload(Path var1);

        public boolean isRunning();
    }

    static enum NginxState {
        INITIALIZING,
        RUNNING,
        RELOAD_REQUIRED,
        STOPPED;

    }
}

