/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import ai.vespa.metrics.set.MicrometerMetrics;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.jdisc.Metric;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class MicrometerMetricReporter
extends AbstractComponent {
    private static final Duration PUBLISH_FREQUENCY = Duration.ofSeconds(1L);
    private static final Set<String> ALLOWED_METERS = Arrays.stream(MicrometerMetrics.values()).map(MicrometerMetrics::baseName).collect(Collectors.toSet());
    private static final Logger log = Logger.getLogger(MicrometerMetricReporter.class.getName());
    private final VespaMicrometerRegistry registry;
    private final Set<AutoCloseable> closeables;

    @Inject
    public MicrometerMetricReporter(Metric metric) {
        this.registry = new VespaMicrometerRegistry(metric);
        HashSet<AutoCloseable> closeables = new HashSet<AutoCloseable>();
        MicrometerMetricReporter.registerMeter(this.registry, closeables, ClassLoaderMetrics::new);
        MicrometerMetricReporter.registerMeter(this.registry, closeables, JvmGcMetrics::new);
        MicrometerMetricReporter.registerMeter(this.registry, closeables, JvmHeapPressureMetrics::new);
        MicrometerMetricReporter.registerMeter(this.registry, closeables, JvmMemoryMetrics::new);
        MicrometerMetricReporter.registerMeter(this.registry, closeables, JvmThreadMetrics::new);
        this.closeables = Set.copyOf(closeables);
    }

    void forcePublish() {
        this.registry.publish();
    }

    public void deconstruct() {
        this.registry.close();
        for (AutoCloseable c : this.closeables) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warning(() -> "Failed to close instance of %s: %s".formatted(c.getClass().getName(), e));
            }
        }
    }

    private static void registerMeter(VespaMicrometerRegistry registry, Set<AutoCloseable> closeables, Supplier<? extends MeterBinder> provider) {
        MeterBinder binder = provider.get();
        if (binder instanceof AutoCloseable) {
            AutoCloseable c = (AutoCloseable)binder;
            closeables.add(c);
        }
        binder.bindTo((MeterRegistry)registry);
    }

    private static class VespaMicrometerRegistry
    extends StepMeterRegistry
    implements AutoCloseable {
        private final Metric jdiscMetric;

        VespaMicrometerRegistry(Metric jdiscMetric) {
            super((StepRegistryConfig)new RegistryConfig(), Clock.SYSTEM);
            this.jdiscMetric = jdiscMetric;
            this.start((ThreadFactory)new NamedThreadFactory("micrometer-metrics-publisher"));
        }

        protected void publish() {
            block5: for (Meter meter : this.getMeters()) {
                String name = meter.getId().getName();
                if (!ALLOWED_METERS.contains(name)) {
                    log.fine(() -> "Ignoring meter with id '%s'".formatted(meter.getId()));
                    continue;
                }
                HashMap dimensions = new HashMap();
                meter.getId().getTags().forEach(tag -> dimensions.put(tag.getKey(), tag.getValue()));
                Metric.Context context = this.jdiscMetric.createContext(dimensions);
                switch (meter.getId().getType()) {
                    case COUNTER: {
                        if (meter instanceof FunctionCounter) {
                            FunctionCounter fc = (FunctionCounter)meter;
                            this.jdiscMetric.set(name, (Number)fc.count(), context);
                            continue block5;
                        }
                        if (meter instanceof Counter) {
                            Counter c = (Counter)meter;
                            this.jdiscMetric.set(name, (Number)c.count(), context);
                            continue block5;
                        }
                        throw new IllegalArgumentException("Unsupported counter type: " + meter.getClass().getName());
                    }
                    case GAUGE: {
                        Gauge gauge = (Gauge)meter;
                        this.jdiscMetric.set(name, (Number)gauge.value(), context);
                        continue block5;
                    }
                    case TIMER: {
                        Timer timer = (Timer)meter;
                        this.jdiscMetric.set(name, (Number)timer.max(TimeUnit.SECONDS), context);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unsupported meter type: " + meter.getId().getType());
            }
        }

        protected TimeUnit getBaseTimeUnit() {
            return TimeUnit.SECONDS;
        }

        private static class RegistryConfig
        implements StepRegistryConfig {
            private RegistryConfig() {
            }

            public Duration step() {
                return PUBLISH_FREQUENCY;
            }

            public String prefix() {
                return "";
            }

            public String get(String key) {
                return null;
            }
        }
    }
}

