/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class SecretsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "71c0f16cc8c64cc9a2f727683006b201";
    public static final String CONFIG_DEF_NAME = "secrets";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.secret.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.secret.config", "intervalSeconds int default=60", "secret{}.vault string", "secret{}.name string"};
    private final IntegerNode intervalSeconds;
    private final Map<String, Secret> secret;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SecretsConfig(Builder builder) {
        this(builder, true);
    }

    private SecretsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for secrets must be initialized: " + builder.__uninitialized);
        }
        this.intervalSeconds = builder.intervalSeconds == null ? new IntegerNode(60) : new IntegerNode(builder.intervalSeconds.intValue());
        this.secret = Secret.createMap(builder.secret);
    }

    public int intervalSeconds() {
        return this.intervalSeconds.value();
    }

    public Map<String, Secret> secret() {
        return Collections.unmodifiableMap(this.secret);
    }

    public Secret secret(String key) {
        return this.secret.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SecretsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer intervalSeconds = null;
        public Map<String, Secret.Builder> secret = new LinkedHashMap<String, Secret.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SecretsConfig config) {
            this.intervalSeconds(config.intervalSeconds());
            for (Map.Entry<String, Secret> __entry : config.secret().entrySet()) {
                this.secret(__entry.getKey(), new Secret.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.intervalSeconds != null) {
                this.intervalSeconds(__superior.intervalSeconds);
            }
            this.secret(__superior.secret);
            return this;
        }

        public Builder intervalSeconds(int __value) {
            this.intervalSeconds = __value;
            return this;
        }

        private Builder intervalSeconds(String __value) {
            return this.intervalSeconds(Integer.valueOf(__value));
        }

        public Builder secret(String __key, Secret.Builder __value) {
            this.secret.put(__key, __value);
            return this;
        }

        public Builder secret(Map<String, Secret.Builder> __values) {
            this.secret.putAll(__values);
            return this;
        }

        public Builder secret(String __key, Consumer<Secret.Builder> __func) {
            Secret.Builder __inner = new Secret.Builder();
            __func.accept(__inner);
            this.secret.put(__key, __inner);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SecretsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SecretsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SecretsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SecretsConfig build() {
            return new SecretsConfig(this);
        }
    }

    public static final class Secret
    extends InnerNode {
        private final StringNode vault;
        private final StringNode name;

        public Secret(Builder builder) {
            this(builder, true);
        }

        private Secret(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for secrets.secret{} must be initialized: " + builder.__uninitialized);
            }
            this.vault = builder.vault == null ? new StringNode() : new StringNode(builder.vault);
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
        }

        public String vault() {
            return this.vault.value();
        }

        public String name() {
            return this.name.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Secret newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("secret");
            return changes;
        }

        private static Map<String, Secret> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Secret> ret = new LinkedHashMap<String, Secret>();
            for (String key : builders.keySet()) {
                ret.put(key, new Secret(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("vault", "name"));
            private String vault = null;
            private String name = null;

            public Builder() {
            }

            public Builder(Secret config) {
                this.vault(config.vault());
                this.name(config.name());
            }

            private Builder override(Builder __superior) {
                if (__superior.vault != null) {
                    this.vault(__superior.vault);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                return this;
            }

            public Builder vault(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.vault = __value;
                this.__uninitialized.remove("vault");
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Secret build() {
                return new Secret(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

