/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.config.aws;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class AsmTenantSecretConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "8196cfb47f17c073fa90986ed21ea631";
    public static final String CONFIG_DEF_NAME = "asm-tenant-secret";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.secret.config.aws";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.secret.config.aws", "system string", "tenant string", "vaults[].id string", "vaults[].name string", "vaults[].externalId string"};
    private final StringNode system;
    private final StringNode tenant;
    private final InnerNodeVector<Vaults> vaults;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public AsmTenantSecretConfig(Builder builder) {
        this(builder, true);
    }

    private AsmTenantSecretConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for asm-tenant-secret must be initialized: " + builder.__uninitialized);
        }
        this.system = builder.system == null ? new StringNode() : new StringNode(builder.system);
        this.tenant = builder.tenant == null ? new StringNode() : new StringNode(builder.tenant);
        this.vaults = Vaults.createVector(builder.vaults);
    }

    public String system() {
        return this.system.value();
    }

    public String tenant() {
        return this.tenant.value();
    }

    public List<Vaults> vaults() {
        return this.vaults;
    }

    public Vaults vaults(int i) {
        return (Vaults)((Object)this.vaults.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(AsmTenantSecretConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("system", "tenant"));
        private String system = null;
        private String tenant = null;
        public List<Vaults.Builder> vaults = new ArrayList<Vaults.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(AsmTenantSecretConfig config) {
            this.system(config.system());
            this.tenant(config.tenant());
            for (Vaults v : config.vaults()) {
                this.vaults(new Vaults.Builder(v));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.system != null) {
                this.system(__superior.system);
            }
            if (__superior.tenant != null) {
                this.tenant(__superior.tenant);
            }
            if (!__superior.vaults.isEmpty()) {
                this.vaults.addAll(__superior.vaults);
            }
            return this;
        }

        public Builder system(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.system = __value;
            this.__uninitialized.remove("system");
            return this;
        }

        public Builder tenant(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tenant = __value;
            this.__uninitialized.remove("tenant");
            return this;
        }

        public Builder vaults(Vaults.Builder __builder) {
            this.vaults.add(__builder);
            return this;
        }

        public Builder vaults(Consumer<Vaults.Builder> __func) {
            Vaults.Builder __inner = new Vaults.Builder();
            __func.accept(__inner);
            this.vaults.add(__inner);
            return this;
        }

        public Builder vaults(List<Vaults.Builder> __builders) {
            this.vaults = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return AsmTenantSecretConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return AsmTenantSecretConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return AsmTenantSecretConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public AsmTenantSecretConfig build() {
            return new AsmTenantSecretConfig(this);
        }
    }

    public static final class Vaults
    extends InnerNode {
        private final StringNode id;
        private final StringNode name;
        private final StringNode externalId;

        public Vaults(Builder builder) {
            this(builder, true);
        }

        private Vaults(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for asm-tenant-secret.vaults[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.externalId = builder.externalId == null ? new StringNode() : new StringNode(builder.externalId);
        }

        public String id() {
            return this.id.value();
        }

        public String name() {
            return this.name.value();
        }

        public String externalId() {
            return this.externalId.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Vaults newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("vaults");
            return changes;
        }

        private static InnerNodeVector<Vaults> createVector(List<Builder> builders) {
            ArrayList<Vaults> elems = new ArrayList<Vaults>();
            for (Builder b : builders) {
                elems.add(new Vaults(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("id", "name", "externalId"));
            private String id = null;
            private String name = null;
            private String externalId = null;

            public Builder() {
            }

            public Builder(Vaults config) {
                this.id(config.id());
                this.name(config.name());
                this.externalId(config.externalId());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.externalId != null) {
                    this.externalId(__superior.externalId);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder externalId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.externalId = __value;
                this.__uninitialized.remove("externalId");
                return this;
            }

            public Vaults build() {
                return new Vaults(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

