/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.observability;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.component.Component;
import com.yahoo.component.ComponentId;
import com.yahoo.component.Vtag;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.Container;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.handler.observability.ApplicationUserdataConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.FastContentWriter;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.filter.RequestFilterBase;
import com.yahoo.jdisc.http.filter.ResponseFilterBase;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.handler.ProcessingHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ApplicationStatusHandler
extends AbstractRequestHandler {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private final JsonNode applicationJson;
    private final JsonNode clientsJson;
    private final JsonNode serversJson;
    private final JsonNode requestFiltersJson;
    private final JsonNode responseFiltersJson;
    private final JdiscBindingsConfig bindingsConfig;
    private final Collection<Extension> extensions;

    @Inject
    public ApplicationStatusHandler(ApplicationMetadataConfig metaConfig, ApplicationUserdataConfig userConfig, JdiscBindingsConfig bindingsConfig, ComponentRegistry<ClientProvider> clientProviderRegistry, ComponentRegistry<ServerProvider> serverProviderRegistry, ComponentRegistry<RequestFilterBase> requestFilterRegistry, ComponentRegistry<ResponseFilterBase> responseFilterRegistry, ComponentRegistry<Extension> extensions) {
        this.applicationJson = ApplicationStatusHandler.renderApplicationConfigs(metaConfig, userConfig);
        this.clientsJson = ApplicationStatusHandler.renderRequestHandlers(bindingsConfig, clientProviderRegistry.allComponentsById());
        this.serversJson = ApplicationStatusHandler.renderObjectComponents(serverProviderRegistry.allComponentsById());
        this.requestFiltersJson = ApplicationStatusHandler.renderObjectComponents(requestFilterRegistry.allComponentsById());
        this.responseFiltersJson = ApplicationStatusHandler.renderObjectComponents(responseFilterRegistry.allComponentsById());
        this.bindingsConfig = bindingsConfig;
        this.extensions = extensions.allComponents();
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        try (FastContentWriter writer = new FastContentWriter(new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", List.of("application/json"));
                return response;
            }
        }.connect(handler));){
            writer.write(jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)this.render()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Invalid JSON: " + e.getMessage(), e);
        }
        return new IgnoredContent();
    }

    public ObjectMapper jsonMapper() {
        return jsonMapper;
    }

    public Collection<RequestHandler> requestHandlers() {
        return ApplicationStatusHandler.container().getRequestHandlerRegistry().allComponents();
    }

    private Map<ComponentId, RequestHandler> requestHandlersById() {
        return ApplicationStatusHandler.container().getRequestHandlerRegistry().allComponentsById();
    }

    private List<? extends Component> components() {
        return ApplicationStatusHandler.container().getComponentRegistry().allComponents();
    }

    private static Container container() {
        return Container.get();
    }

    static JsonNode renderApplicationConfigs(ApplicationMetadataConfig metaConfig, ApplicationUserdataConfig userConfig) {
        ObjectNode vespa = jsonMapper.createObjectNode();
        vespa.put("version", Vtag.currentVersion.toString());
        ObjectNode meta = jsonMapper.createObjectNode();
        meta.put("name", metaConfig.name());
        meta.put("user", metaConfig.user());
        meta.put("path", metaConfig.path());
        meta.put("generation", metaConfig.generation());
        meta.put("timestamp", metaConfig.timestamp());
        meta.put("date", new Date(metaConfig.timestamp()).toString());
        meta.put("checksum", metaConfig.checksum());
        ObjectNode user = jsonMapper.createObjectNode();
        user.put("version", userConfig.version());
        ObjectNode application = jsonMapper.createObjectNode();
        application.set("vespa", (JsonNode)vespa);
        application.set("meta", (JsonNode)meta);
        application.set("user", (JsonNode)user);
        return application;
    }

    static JsonNode renderObjectComponents(Map<ComponentId, ?> componentsById) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (Map.Entry<ComponentId, ?> componentEntry : componentsById.entrySet()) {
            ObjectNode jc = ApplicationStatusHandler.renderComponent(componentEntry.getValue(), componentEntry.getKey());
            ret.add((JsonNode)jc);
        }
        return ret;
    }

    static JsonNode renderRequestHandlers(JdiscBindingsConfig bindingsConfig, Map<ComponentId, ? extends RequestHandler> handlersById) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (Map.Entry<ComponentId, ? extends RequestHandler> handlerEntry : handlersById.entrySet()) {
            String id = handlerEntry.getKey().stringValue();
            RequestHandler handler = handlerEntry.getValue();
            ObjectNode handlerJson = ApplicationStatusHandler.renderComponent(handler, handlerEntry.getKey());
            ApplicationStatusHandler.addBindings(bindingsConfig, id, handlerJson);
            ret.add((JsonNode)handlerJson);
        }
        return ret;
    }

    private static void addBindings(JdiscBindingsConfig bindingsConfig, String id, ObjectNode handlerJson) {
        ArrayList<String> serverBindings = new ArrayList();
        ArrayList<String> clientBindings = new ArrayList();
        JdiscBindingsConfig.Handlers handlerConfig = bindingsConfig.handlers(id);
        if (handlerConfig != null) {
            serverBindings = handlerConfig.serverBindings();
            clientBindings = handlerConfig.clientBindings();
        }
        handlerJson.set("serverBindings", ApplicationStatusHandler.renderBindings(serverBindings));
        handlerJson.set("clientBindings", ApplicationStatusHandler.renderBindings(clientBindings));
    }

    private static JsonNode renderBindings(List<String> bindings) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (String binding : bindings) {
            ret.add(binding);
        }
        return ret;
    }

    private static JsonNode renderAbstractComponents(List<? extends Component> components) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (Component component : components) {
            ObjectNode jc = ApplicationStatusHandler.renderComponent(component, component.getId());
            ret.add((JsonNode)jc);
        }
        return ret;
    }

    public static ObjectNode renderComponent(Object component, ComponentId id) {
        ObjectNode jc = jsonMapper.createObjectNode();
        jc.put("id", id.stringValue());
        ApplicationStatusHandler.addBundleInfo(jc, component);
        return jc;
    }

    private static void addBundleInfo(ObjectNode jsonObject, Object component) {
        BundleInfo bundleInfo = ApplicationStatusHandler.bundleInfo(component);
        jsonObject.put("class", bundleInfo.className);
        jsonObject.put("bundle", bundleInfo.bundleName);
    }

    private static BundleInfo bundleInfo(Object component) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(component.getClass());
            String bundleName = bundle != null ? bundle.getSymbolicName() + ":" + bundle.getVersion() : "From classpath";
            return new BundleInfo(component.getClass().getName(), bundleName);
        }
        catch (Exception | NoClassDefFoundError e) {
            return new BundleInfo("Unavailable, reconfiguration in progress.", "");
        }
    }

    JsonNode render() {
        ObjectNode root = jsonMapper.createObjectNode();
        root.set("application", this.applicationJson);
        root.set("abstractComponents", ApplicationStatusHandler.renderAbstractComponents(this.components()));
        root.set("handlers", ApplicationStatusHandler.renderRequestHandlers(this.bindingsConfig, this.requestHandlersById()));
        root.set("clients", this.clientsJson);
        root.set("servers", this.serversJson);
        root.set("httpRequestFilters", this.requestFiltersJson);
        root.set("httpResponseFilters", this.responseFiltersJson);
        root.set("processingChains", this.renderProcessingChains());
        for (Extension extension : this.extensions) {
            extension.produceExtraFields(this).forEach((field, json) -> {
                if (root.has(field)) {
                    throw new IllegalArgumentException("Field '" + field + "' already defined");
                }
                root.set(field, json);
            });
        }
        return root;
    }

    private JsonNode renderProcessingChains() {
        ObjectNode ret = jsonMapper.createObjectNode();
        for (RequestHandler h : this.requestHandlers()) {
            if (!(h instanceof ProcessingHandler)) continue;
            ChainRegistry registry = ((ProcessingHandler)h).getChainRegistry();
            return ApplicationStatusHandler.renderChains(registry);
        }
        return ret;
    }

    public static JsonNode renderChains(ComponentRegistry<? extends Chain<?>> chains) {
        ObjectNode ret = jsonMapper.createObjectNode();
        for (Chain chain : chains.allComponents()) {
            ret.set(chain.getId().stringValue(), ApplicationStatusHandler.renderAbstractComponents(chain.components()));
        }
        return ret;
    }

    private class IgnoredContent
    implements ContentChannel {
        private IgnoredContent() {
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    }

    static final class BundleInfo {
        public final String className;
        public final String bundleName;

        BundleInfo(String className, String bundleName) {
            this.className = className;
            this.bundleName = bundleName;
        }
    }

    public static interface Extension {
        public Map<String, ? extends JsonNode> produceExtraFields(ApplicationStatusHandler var1);
    }
}

