/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.metric.GarbageCollectionMetrics;
import com.yahoo.container.jdisc.metric.JrtMetrics;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.statistics.ContainerWatchdogMetrics;
import com.yahoo.metrics.ContainerMetrics;
import com.yahoo.nativec.NativeHeap;
import com.yahoo.security.tls.TlsMetrics;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class MetricUpdater
extends AbstractComponent {
    private static final String NATIVE_FREE_MEMORY_BYTES = ContainerMetrics.MEM_NATIVE_FREE.baseName();
    private static final String NATIVE_USED_MEMORY_BYTES = ContainerMetrics.MEM_NATIVE_USED.baseName();
    private static final String NATIVE_TOTAL_MEMORY_BYTES = ContainerMetrics.MEM_NATIVE_TOTAL.baseName();
    private static final String HEAP_FREE_MEMORY_BYTES = ContainerMetrics.MEM_HEAP_FREE.baseName();
    private static final String HEAP_USED_MEMORY_BYTES = ContainerMetrics.MEM_HEAP_USED.baseName();
    private static final String HEAP_TOTAL_MEMORY_BYTES = ContainerMetrics.MEM_HEAP_TOTAL.baseName();
    private static final String DIRECT_FREE_MEMORY_BYTES = ContainerMetrics.MEM_DIRECT_FREE.baseName();
    private static final String DIRECT_USED_MEMORY_BYTES = ContainerMetrics.MEM_DIRECT_USED.baseName();
    private static final String DIRECT_TOTAL_MEMORY_BYTES = ContainerMetrics.MEM_DIRECT_TOTAL.baseName();
    private static final String DIRECT_COUNT = ContainerMetrics.MEM_DIRECT_COUNT.baseName();
    private static final String MEMORY_MAPPINGS_COUNT = ContainerMetrics.JDISC_MEMORY_MAPPINGS.baseName();
    private static final String OPEN_FILE_DESCRIPTORS = ContainerMetrics.JDISC_OPEN_FILE_DESCRIPTORS.baseName();
    private static final String TOTAL_THREADS = "jdisc.threads.total";
    private final Scheduler scheduler;

    @Inject
    public MetricUpdater(Metric metric, ContainerWatchdogMetrics containerWatchdogMetrics) {
        this(new TimerScheduler(), metric, containerWatchdogMetrics);
    }

    MetricUpdater(Scheduler scheduler, Metric metric, ContainerWatchdogMetrics containerWatchdogMetrics) {
        this.scheduler = scheduler;
        scheduler.schedule(new UpdaterTask(metric, containerWatchdogMetrics), Duration.ofSeconds(10L));
    }

    public void deconstruct() {
        this.scheduler.cancel();
    }

    private static long count_mappings() {
        long count = 0L;
        try {
            byte[] data;
            Path p = Paths.get("/proc/self/maps", new String[0]);
            if (!p.toFile().exists()) {
                return 0L;
            }
            for (byte b : data = Files.readAllBytes(p)) {
                if (b != 10) continue;
                ++count;
            }
        }
        catch (Exception e) {
            System.err.println("Could not read /proc/self/maps: " + e);
        }
        return count;
    }

    private static long count_open_files() {
        long count = 0L;
        try {
            Path p = Paths.get("/proc/self/fd", new String[0]);
            if (!p.toFile().exists()) {
                return 0L;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
                for (Path entry : stream) {
                    ++count;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Could not read /proc/self/fd: " + e);
        }
        return count;
    }

    private static class TimerScheduler
    implements Scheduler {
        private final Timer timer = new Timer();

        private TimerScheduler() {
        }

        @Override
        public void schedule(final Runnable runnable, Duration frequency) {
            long frequencyMillis = frequency.toMillis();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    runnable.run();
                }
            }, frequencyMillis, frequencyMillis);
        }

        @Override
        public void cancel() {
            this.timer.cancel();
        }
    }

    static interface Scheduler {
        public void schedule(Runnable var1, Duration var2);

        public void cancel();
    }

    private static class UpdaterTask
    implements Runnable {
        private final Runtime runtime = Runtime.getRuntime();
        private final Metric metric;
        private final ContainerWatchdogMetrics containerWatchdogMetrics;
        private final GarbageCollectionMetrics garbageCollectionMetrics;
        private final JrtMetrics jrtMetrics;
        private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        private TlsMetrics.Snapshot tlsMetricsSnapshot = TlsMetrics.Snapshot.EMPTY;

        public UpdaterTask(Metric metric, ContainerWatchdogMetrics containerWatchdogMetrics) {
            this.metric = metric;
            this.containerWatchdogMetrics = containerWatchdogMetrics;
            this.garbageCollectionMetrics = new GarbageCollectionMetrics(Clock.systemUTC());
            this.jrtMetrics = new JrtMetrics(metric);
        }

        private void directMemoryUsed() {
            long count = 0L;
            long used = 0L;
            long total = 0L;
            for (BufferPoolMXBean pool : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
                count += pool.getCount();
                used += pool.getMemoryUsed();
                total += pool.getTotalCapacity();
            }
            this.metric.set(DIRECT_FREE_MEMORY_BYTES, (Number)(total - used), null);
            this.metric.set(DIRECT_USED_MEMORY_BYTES, (Number)used, null);
            this.metric.set(DIRECT_TOTAL_MEMORY_BYTES, (Number)total, null);
            this.metric.set(DIRECT_COUNT, (Number)count, null);
        }

        private void nativeHeapUsed() {
            NativeHeap nativeHeap = NativeHeap.sample();
            this.metric.set(NATIVE_FREE_MEMORY_BYTES, (Number)nativeHeap.availableSize(), null);
            this.metric.set(NATIVE_USED_MEMORY_BYTES, (Number)nativeHeap.usedSize(), null);
            this.metric.set(NATIVE_TOTAL_MEMORY_BYTES, (Number)nativeHeap.totalSize(), null);
        }

        private void jvmDetails() {
            Metric.Context ctx = this.metric.createContext(Map.of("version", System.getProperty("java.runtime.version"), "home", System.getProperty("java.home"), "vendor", System.getProperty("java.vm.vendor"), "arch", System.getProperty("os.arch")));
            this.metric.set("jdisc.jvm", (Number)Runtime.version().feature(), ctx);
        }

        private void tlsMetrics() {
            TlsMetrics.Snapshot newSnapshot = TlsMetrics.instance().snapshot();
            TlsMetrics.Diff diff = newSnapshot.changesSince(this.tlsMetricsSnapshot);
            this.metric.add(ContainerMetrics.JDISC_TLS_CAPABILITY_CHECKS_SUCCEEDED.baseName(), (Number)diff.capabilityChecksSucceeded(), null);
            this.metric.add(ContainerMetrics.JDISC_TLS_CAPABILITY_CHECKS_FAILED.baseName(), (Number)diff.capabilityChecksFailed(), null);
            this.tlsMetricsSnapshot = newSnapshot;
        }

        @Override
        public void run() {
            long freeMemory = this.runtime.freeMemory();
            long totalMemory = this.runtime.totalMemory();
            long usedMemory = totalMemory - freeMemory;
            this.metric.set(HEAP_FREE_MEMORY_BYTES, (Number)freeMemory, null);
            this.metric.set(HEAP_USED_MEMORY_BYTES, (Number)usedMemory, null);
            this.metric.set(HEAP_TOTAL_MEMORY_BYTES, (Number)totalMemory, null);
            this.metric.set(MEMORY_MAPPINGS_COUNT, (Number)MetricUpdater.count_mappings(), null);
            this.metric.set(OPEN_FILE_DESCRIPTORS, (Number)MetricUpdater.count_open_files(), null);
            this.metric.set(MetricUpdater.TOTAL_THREADS, (Number)this.threadMXBean.getThreadCount(), null);
            this.directMemoryUsed();
            this.nativeHeapUsed();
            this.containerWatchdogMetrics.emitMetrics(this.metric);
            this.garbageCollectionMetrics.emitMetrics(this.metric);
            this.jrtMetrics.emitMetrics();
            this.jvmDetails();
            this.tlsMetrics();
        }
    }
}

