/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.http.filter.FilterChainRepository;
import com.yahoo.container.jdisc.FilterUtil;
import com.yahoo.jdisc.application.BindingRepository;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilter;
import com.yahoo.jdisc.http.server.FilterBindings;
import java.util.ArrayList;
import java.util.List;

public class FilterBindingsProvider
implements Provider<FilterBindings> {
    final BindingRepository<RequestFilter> requestFilters = new BindingRepository();
    final BindingRepository<ResponseFilter> responseFilters = new BindingRepository();

    public FilterBindingsProvider(ComponentId componentId, ServerConfig config, FilterChainRepository filterChainRepository, ComponentRegistry<SecurityRequestFilter> legacyRequestFilters) {
        ComponentId serverId = componentId.getNamespace();
        try {
            FilterUtil.setupFilters(componentId, legacyRequestFilters, this.toFilterSpecs(config.filter()), filterChainRepository, this.requestFilters, this.responseFilters);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid config for http server " + serverId, e);
        }
    }

    private List<FilterUtil.FilterSpec> toFilterSpecs(List<ServerConfig.Filter> inFilters) {
        ArrayList<FilterUtil.FilterSpec> outFilters = new ArrayList<FilterUtil.FilterSpec>();
        for (ServerConfig.Filter inFilter : inFilters) {
            outFilters.add(new FilterUtil.FilterSpec(inFilter.id(), inFilter.binding()));
        }
        return outFilters;
    }

    public FilterBindings get() {
        return new FilterBindings(this.requestFilters, this.responseFilters);
    }

    public void deconstruct() {
    }
}

