/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import com.google.inject.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.jdisc.MetricConsumerFactory;
import com.yahoo.container.jdisc.metric.ForwardingMetricConsumer;
import com.yahoo.jdisc.application.MetricConsumer;

public class MetricConsumerProvider {
    private final MetricConsumerFactory[] factories;

    @Inject
    public MetricConsumerProvider(ComponentRegistry<MetricConsumerFactory> factoryRegistry) {
        MetricConsumerFactory[] factories = new MetricConsumerFactory[factoryRegistry.getComponentCount()];
        factoryRegistry.allComponents().toArray(factories);
        this.factories = factories;
    }

    public MetricConsumer newInstance() {
        if (this.factories.length == 1) {
            return this.factories[0].newInstance();
        }
        MetricConsumer[] consumers = new MetricConsumer[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            consumers[i] = this.factories[i].newInstance();
        }
        return new ForwardingMetricConsumer(consumers);
    }
}

