/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import com.yahoo.jdisc.Metric;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class GarbageCollectionMetrics {
    private static final String GC_COUNT = "jdisc.gc.count";
    private static final String GC_TIME = "jdisc.gc.ms";
    private static final String DIMENSION_KEY = "gcName";
    public static final Duration REPORTING_INTERVAL = Duration.ofSeconds(62L);
    private final Map<String, LinkedList<GcStats>> gcStatistics;
    private final Clock clock;

    public GarbageCollectionMetrics(Clock clock) {
        this.clock = clock;
        this.gcStatistics = new HashMap<String, LinkedList<GcStats>>();
        this.collectGcStatistics(clock.instant());
    }

    private void collectGcStatistics(Instant now) {
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            String gcName = gcBean.getName().replace(" ", "");
            GcStats stats = new GcStats(now, gcBean.getCollectionCount(), Duration.ofMillis(gcBean.getCollectionTime()));
            LinkedList window = this.gcStatistics.computeIfAbsent(gcName, anyName -> new LinkedList());
            window.addLast(stats);
        }
    }

    private void cleanStatistics(Instant now) {
        Instant oldestToKeep = now.minus(REPORTING_INTERVAL);
        Iterator<Map.Entry<String, LinkedList<GcStats>>> it = this.gcStatistics.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, LinkedList<GcStats>> entry = it.next();
            LinkedList<GcStats> history = entry.getValue();
            while (!history.isEmpty() && oldestToKeep.isAfter(history.getFirst().when)) {
                history.removeFirst();
            }
            if (!history.isEmpty()) continue;
            it.remove();
        }
    }

    public void emitMetrics(Metric metric) {
        Instant now = this.clock.instant();
        this.collectGcStatistics(now);
        this.cleanStatistics(now);
        for (Map.Entry<String, LinkedList<GcStats>> item : this.gcStatistics.entrySet()) {
            GcStats reference = item.getValue().getFirst();
            GcStats latest = item.getValue().getLast();
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put(DIMENSION_KEY, item.getKey());
            Metric.Context gcContext = metric.createContext(contextData);
            metric.set(GC_COUNT, (Number)(latest.count - reference.count), gcContext);
            metric.set(GC_TIME, (Number)latest.totalRuntime.minus(reference.totalRuntime).toMillis(), gcContext);
        }
    }

    Map<String, LinkedList<GcStats>> getGcStatistics() {
        return this.gcStatistics;
    }

    static class GcStats {
        private final Instant when;
        private final long count;
        private final Duration totalRuntime;

        private GcStats(Instant when, long count, Duration totalRuntime) {
            this.when = when;
            this.count = count;
            this.totalRuntime = totalRuntime;
        }
    }
}

