/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container;

import com.yahoo.container.core.http.HttpFilterConfig;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.jdisc.http.filter.FilterConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class FilterConfigProvider
implements Provider<FilterConfig> {
    private final FilterConfig filterConfig;

    public FilterConfigProvider(HttpFilterConfig vespaConfig) {
        this(new MapFilterConfig(FilterConfigProvider.toMap(vespaConfig), vespaConfig.filterName(), vespaConfig.filterClass()));
    }

    private FilterConfigProvider(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    private static Map<String, String> toMap(HttpFilterConfig vespaConfig) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (HttpFilterConfig.Param param : vespaConfig.param()) {
            parameters.put(param.name(), param.value());
        }
        return parameters;
    }

    public static FilterConfigProvider from(String filterName, String filterClass, Map<String, String> initParameters) {
        return new FilterConfigProvider(new MapFilterConfig(initParameters, filterName, filterClass));
    }

    public FilterConfig get() {
        return this.filterConfig;
    }

    public void deconstruct() {
    }

    private static class MapFilterConfig
    implements FilterConfig {
        private final Map<String, String> initParameters;
        private final String filterName;
        private final String filterClass;

        MapFilterConfig(Map<String, String> initParameters, String filterName, String filterClass) {
            this.initParameters = initParameters;
            this.filterName = filterName;
            this.filterClass = filterClass;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public String getFilterClass() {
            return this.filterClass;
        }

        public String getInitParameter(String name) {
            return this.initParameters.get(name);
        }

        public boolean getBooleanInitParameter(String name, boolean defaultValue) {
            return this.initParameters.containsKey(name) ? Boolean.parseBoolean(this.initParameters.get(name)) : defaultValue;
        }

        public Collection<String> getInitParameterNames() {
            return this.initParameters.keySet();
        }
    }
}

