/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.container.Container;
import com.yahoo.container.QrConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.container.core.config.HandlersConfigurerDi;
import com.yahoo.container.di.CloudSubscriberFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.container.http.filter.FilterChainRepository;
import com.yahoo.container.jdisc.DisableOsgiFramework;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.container.jdisc.RestrictedBundleContext;
import com.yahoo.container.jdisc.component.Deconstructor;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.container.jdisc.metric.DisableGuiceMetric;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.application.Application;
import com.yahoo.jdisc.application.BindingRepository;
import com.yahoo.jdisc.application.ContainerActivator;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.application.GuiceRepository;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.slobrok.api.Register;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.log.LogSetup;
import com.yahoo.messagebus.network.rpc.SlobrokConfigSubscriber;
import com.yahoo.net.HostName;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.yolean.Exceptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfiguredApplication
implements Application {
    private static final Logger log = Logger.getLogger(ConfiguredApplication.class.getName());
    private static final Set<ClientProvider> startedClients = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<ServerProvider> startedServers = Collections.newSetFromMap(new IdentityHashMap());
    private final SubscriberFactory subscriberFactory;
    private final ContainerActivator activator;
    private final String configId;
    private final OsgiFramework osgiFramework;
    private final Timer timerSingleton;
    private final Optional<SlobrokConfigSubscriber> slobrokConfigSubscriber;
    private final SessionCache sessionCache;
    private final FilterChainRepository defaultFilterChainRepository = new FilterChainRepository(new ChainsConfig(new ChainsConfig.Builder()), new ComponentRegistry(), new ComponentRegistry(), new ComponentRegistry(), new ComponentRegistry());
    private final OsgiFramework restrictedOsgiFramework;
    private volatile int applicationSerialNo = 0;
    private HandlersConfigurerDi configurer;
    private ScheduledThreadPoolExecutor shutdownDeadlineExecutor;
    private Thread reconfigurerThread;
    private Thread portWatcher;
    private QrConfig qrConfig;
    private Register slobrokRegistrator = null;
    private Supervisor supervisor = null;
    private Acceptor acceptor = null;

    public static void ensureVespaLoggingInitialized() {
    }

    @Inject
    public ConfiguredApplication(ContainerActivator activator, OsgiFramework osgiFramework, Timer timer, SubscriberFactory subscriberFactory) {
        this.activator = activator;
        this.osgiFramework = osgiFramework;
        this.timerSingleton = timer;
        this.subscriberFactory = subscriberFactory;
        this.configId = System.getProperty("config.id");
        this.slobrokConfigSubscriber = subscriberFactory instanceof CloudSubscriberFactory ? Optional.of(new SlobrokConfigSubscriber(this.configId)) : Optional.empty();
        this.sessionCache = new SessionCache(this.configId);
        this.restrictedOsgiFramework = new DisableOsgiFramework(new RestrictedBundleContext(osgiFramework.bundleContext()));
    }

    public void start() {
        this.qrConfig = this.getConfig(QrConfig.class);
        this.slobrokRegistrator = this.registerInSlobrok(this.qrConfig);
        ConfiguredApplication.hackToInitializeServer(this.qrConfig);
        ContainerBuilder builder = this.createBuilderWithGuiceBindings();
        this.configurer = this.createConfigurer(builder.guiceModules().activate());
        this.initializeAndActivateContainer(builder);
        this.startReconfigurerThread();
        this.portWatcher = new Thread(this::watchPortChange);
        this.portWatcher.setDaemon(true);
        this.portWatcher.start();
    }

    private Register registerInSlobrok(QrConfig qrConfig) {
        if (!qrConfig.rpc().enabled()) {
            return null;
        }
        this.supervisor = new Supervisor(new Transport("slobrok"));
        Spec listenSpec = new Spec(qrConfig.rpc().port());
        try {
            this.acceptor = this.supervisor.listen(listenSpec);
        }
        catch (ListenFailedException e) {
            throw new RuntimeException("Could not create rpc server listening on " + listenSpec, e);
        }
        SlobrokList slobrokList = this.getSlobrokList();
        Spec mySpec = new Spec(HostName.getLocalhost(), this.acceptor.port());
        this.slobrokRegistrator = new Register(this.supervisor, slobrokList, mySpec);
        this.slobrokRegistrator.registerName(qrConfig.rpc().slobrokId());
        log.log(Level.INFO, "Registered name '" + qrConfig.rpc().slobrokId() + "' at " + mySpec + " with: " + slobrokList);
        return this.slobrokRegistrator;
    }

    private SlobrokList getSlobrokList() {
        SlobrokList slobrokList;
        if (this.slobrokConfigSubscriber.isPresent()) {
            slobrokList = this.slobrokConfigSubscriber.get().getSlobroks();
        } else {
            slobrokList = new SlobrokList();
            SlobroksConfig slobrokConfig = this.getConfig(SlobroksConfig.class);
            slobrokList.setup((String[])slobrokConfig.slobrok().stream().map(SlobroksConfig.Slobrok::connectionspec).toArray(String[]::new));
        }
        return slobrokList;
    }

    private void unregisterInSlobrok() {
        if (this.slobrokRegistrator != null) {
            this.slobrokRegistrator.shutdown();
        }
        if (this.acceptor != null) {
            this.acceptor.shutdown().join();
        }
        if (this.supervisor != null) {
            this.supervisor.transport().shutdown().join();
        }
    }

    private static void hackToInitializeServer(QrConfig config) {
        try {
            Container.get().setupFileAcquirer(config.filedistributor());
            Container.get().setupUrlDownloader();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Caught exception when initializing server. Exiting.", e);
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigInstance> T getConfig(Class<T> configClass) {
        try (Subscriber subscriber = this.subscriberFactory.getSubscriber(Collections.singleton(new ConfigKey(configClass, this.configId)));){
            subscriber.waitNextGeneration();
            ConfigInstance configInstance = (ConfigInstance)configClass.cast(CollectionUtil.first(subscriber.config().values()));
            return (T)configInstance;
        }
    }

    private void watchPortChange() {
        Subscriber subscriber = this.subscriberFactory.getSubscriber(Collections.singleton(new ConfigKey(QrConfig.class, this.configId)));
        try {
            while (true) {
                subscriber.waitNextGeneration();
                QrConfig newConfig = (QrConfig)QrConfig.class.cast(CollectionUtil.first(subscriber.config().values()));
                if (this.qrConfig.rpc().port() != newConfig.rpc().port()) {
                    Process.logAndDie((String)("Rpc port config has changed from " + this.qrConfig.rpc().port() + " to " + newConfig.rpc().port() + ". This we can not handle without a restart so we will just bail out."));
                }
                log.fine("Received new QrConfig :" + newConfig);
            }
        }
        catch (Throwable throwable) {
            subscriber.close();
            throw throwable;
        }
    }

    private void initializeAndActivateContainer(ContainerBuilder builder) {
        ConfiguredApplication.addHandlerBindings(builder, (ComponentRegistry<RequestHandler>)Container.get().getRequestHandlerRegistry(), ((ApplicationContext)this.configurer.getComponent(ApplicationContext.class)).discBindingsConfig);
        ConfiguredApplication.installServerProviders(builder);
        this.activator.activateContainer(builder);
        ConfiguredApplication.startClients();
        ConfiguredApplication.startAndStopServers();
        log.info("Switching to the latest deployed set of configurations and components. Application switch number: " + this.applicationSerialNo++);
    }

    private ContainerBuilder createBuilderWithGuiceBindings() {
        ContainerBuilder builder = this.activator.newContainerBuilder();
        this.setupGuiceBindings(builder.guiceModules());
        return builder;
    }

    private void startReconfigurerThread() {
        this.reconfigurerThread = new Thread(() -> {
            while (!Thread.interrupted()) {
                try {
                    ContainerBuilder builder = this.createBuilderWithGuiceBindings();
                    this.configurer.getNewComponentGraph(builder.guiceModules().activate(), this.qrConfig.restartOnDeploy());
                    this.initializeAndActivateContainer(builder);
                }
                catch (ConfigInterruptedException e) {
                    break;
                }
                catch (Exception | LinkageError e) {
                    log.log(Level.SEVERE, "Reconfiguration failed, your application package must be fixed, unless this is a JNI reload issue: " + Exceptions.toMessageString((Throwable)e), e);
                }
                catch (Error e) {
                    Process.logAndDie((String)"java.lang.Error on reconfiguration: We are probably in a bad state and will terminate", (Throwable)e);
                }
            }
            log.fine("Shutting down HandlersConfigurerDi");
        });
        this.reconfigurerThread.start();
    }

    private static void installServerProviders(ContainerBuilder builder) {
        List serverProviders = Container.get().getServerProviderRegistry().allComponents();
        for (ServerProvider server : serverProviders) {
            builder.serverProviders().install(server);
        }
    }

    private static void startClients() {
        for (ClientProvider client : Container.get().getClientProviderRegistry().allComponents()) {
            if (startedClients.contains(client)) continue;
            client.start();
            startedClients.add(client);
        }
    }

    private static void startAndStopServers() {
        List currentServers = Container.get().getServerProviderRegistry().allComponents();
        HashSet<ServerProvider> serversToClose = new HashSet<ServerProvider>(startedServers);
        serversToClose.removeAll(currentServers);
        for (ServerProvider server : serversToClose) {
            ConfiguredApplication.closeServer(server);
        }
        for (ServerProvider server : currentServers) {
            if (startedServers.contains(server)) continue;
            server.start();
            startedServers.add(server);
        }
    }

    private static void closeServer(ServerProvider server) {
        server.close();
        startedServers.remove(server);
    }

    private HandlersConfigurerDi createConfigurer(Injector discInjector) {
        return new HandlersConfigurerDi(this.subscriberFactory, Container.get(), this.configId, (ComponentDeconstructor)new Deconstructor(true), discInjector, this.osgiFramework);
    }

    private void setupGuiceBindings(GuiceRepository modules) {
        modules.install((Module)new AbstractModule(){

            protected void configure() {
                this.bind(Metric.class).to(DisableGuiceMetric.class);
                this.bind(OsgiFramework.class).toInstance((Object)ConfiguredApplication.this.restrictedOsgiFramework);
                this.bind(Timer.class).toInstance((Object)ConfiguredApplication.this.timerSingleton);
                this.bind(FilterChainRepository.class).toInstance((Object)ConfiguredApplication.this.defaultFilterChainRepository);
                this.bind(SessionCache.class).toInstance((Object)ConfiguredApplication.this.sessionCache);
            }
        });
    }

    public void stop() {
        this.startShutdownDeadlineExecutor();
        this.shutdownReconfigurerThread();
        log.info("Stop: Closing servers");
        for (ServerProvider server : Container.get().getServerProviderRegistry().allComponents()) {
            if (!startedServers.contains(server)) continue;
            ConfiguredApplication.closeServer(server);
        }
        log.info("Stop: Shutting container down");
        this.configurer.shutdown((ComponentDeconstructor)new Deconstructor(false));
        this.slobrokConfigSubscriber.ifPresent(SlobrokConfigSubscriber::shutdown);
        Container.get().shutdown();
        this.unregisterInSlobrok();
        LogSetup.cleanup();
        log.info("Stop: Finished");
    }

    private void shutdownReconfigurerThread() {
        if (this.reconfigurerThread == null) {
            return;
        }
        this.reconfigurerThread.interrupt();
        try {
            while (this.reconfigurerThread.isAlive()) {
                this.reconfigurerThread.interrupt();
                long millis = 200L;
                this.reconfigurerThread.join(millis);
            }
        }
        catch (InterruptedException e) {
            log.info("Interrupted while joining on HandlersConfigurer reconfigure thread.");
            Thread.currentThread().interrupt();
        }
    }

    public void destroy() {
        if (this.shutdownDeadlineExecutor != null) {
            this.shutdownDeadlineExecutor.shutdownNow();
        }
    }

    private void startShutdownDeadlineExecutor() {
        this.shutdownDeadlineExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("Shutdown deadline timer"));
        this.shutdownDeadlineExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        long delayMillis = 50000L;
        this.shutdownDeadlineExecutor.schedule(() -> Process.logAndDie((String)"Timed out waiting for application shutdown. Please check that all your request handlers drain their request content channels.", (boolean)true), delayMillis, TimeUnit.MILLISECONDS);
    }

    private static void addHandlerBindings(ContainerBuilder builder, ComponentRegistry<RequestHandler> requestHandlerRegistry, JdiscBindingsConfig discBindingsConfig) {
        for (Map.Entry<String, JdiscBindingsConfig.Handlers> handlerEntry : discBindingsConfig.handlers().entrySet()) {
            String id = handlerEntry.getKey();
            JdiscBindingsConfig.Handlers handlerConfig = handlerEntry.getValue();
            RequestHandler handler = (RequestHandler)requestHandlerRegistry.getComponent(id);
            if (handler == null) {
                throw new RuntimeException("Binding configured for non-jdisc request handler " + id);
            }
            ConfiguredApplication.bindUri((BindingRepository<RequestHandler>)builder.serverBindings(), handlerConfig.serverBindings(), handler);
            ConfiguredApplication.bindUri((BindingRepository<RequestHandler>)builder.clientBindings(), handlerConfig.clientBindings(), handler);
        }
    }

    private static void bindUri(BindingRepository<RequestHandler> bindings, List<String> uriPatterns, RequestHandler target) {
        for (String uri : uriPatterns) {
            bindings.bind(uri, (Object)target);
        }
    }

    static {
        LogSetup.initVespaLogging((String)"Container");
        log.log(Level.INFO, "Starting container");
    }

    public static final class ApplicationContext {
        final JdiscBindingsConfig discBindingsConfig;

        public ApplicationContext(JdiscBindingsConfig discBindingsConfig) {
            this.discBindingsConfig = discBindingsConfig;
        }
    }
}

