/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.core.identity.IdentityConfig;
import com.yahoo.container.jdisc.athenz.AthenzIdentityProvider;
import com.yahoo.container.jdisc.athenz.AthenzIdentityProviderException;
import com.yahoo.container.jdisc.athenz.impl.AthenzCredentials;
import com.yahoo.container.jdisc.athenz.impl.AthenzCredentialsService;
import com.yahoo.container.jdisc.athenz.impl.AthenzService;
import com.yahoo.container.jdisc.athenz.impl.IdentityDocumentService;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogLevel;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class AthenzIdentityProviderImpl
extends AbstractComponent
implements AthenzIdentityProvider {
    private static final Logger log = Logger.getLogger(AthenzIdentityProviderImpl.class.getName());
    static final Duration EXPIRES_AFTER = Duration.ofDays(1L);
    static final Duration EXPIRATION_MARGIN = Duration.ofMinutes(30L);
    static final Duration INITIAL_WAIT_NTOKEN = Duration.ofMinutes(5L);
    static final Duration UPDATE_PERIOD = EXPIRES_AFTER.dividedBy(3L);
    static final Duration REDUCED_UPDATE_PERIOD = Duration.ofMinutes(30L);
    static final Duration INITIAL_BACKOFF_DELAY = Duration.ofMinutes(4L);
    static final Duration MAX_REGISTER_BACKOFF_DELAY = Duration.ofHours(1L);
    static final int BACKOFF_DELAY_MULTIPLIER = 2;
    static final Duration AWAIT_TERMINTATION_TIMEOUT = Duration.ofSeconds(90L);
    private static final Duration CERTIFICATE_EXPIRY_METRIC_UPDATE_PERIOD = Duration.ofMinutes(5L);
    private static final String CERTIFICATE_EXPIRY_METRIC_NAME = "athenz-tenant-cert.expiry.seconds";
    static final String REGISTER_INSTANCE_TAG = "register-instance";
    static final String UPDATE_CREDENTIALS_TAG = "update-credentials";
    static final String TIMEOUT_INITIAL_WAIT_TAG = "timeout-initial-wait";
    static final String METRICS_UPDATER_TAG = "metrics-updater";
    private final AtomicReference<AthenzCredentials> credentials = new AtomicReference();
    private final AtomicReference<Throwable> lastThrowable = new AtomicReference();
    private final CountDownLatch credentialsRetrievedSignal = new CountDownLatch(1);
    private final AthenzCredentialsService athenzCredentialsService;
    private final Scheduler scheduler;
    private final Clock clock;
    private final String domain;
    private final String service;
    private final CertificateExpiryMetricUpdater metricUpdater;

    @Inject
    public AthenzIdentityProviderImpl(IdentityConfig config, Metric metric) {
        this(config, metric, new AthenzCredentialsService(config, new IdentityDocumentService(config.loadBalancerAddress()), new AthenzService(), Clock.systemUTC()), new ThreadPoolScheduler(), Clock.systemUTC());
    }

    AthenzIdentityProviderImpl(IdentityConfig config, Metric metric, AthenzCredentialsService athenzCredentialsService, Scheduler scheduler, Clock clock) {
        this.athenzCredentialsService = athenzCredentialsService;
        this.scheduler = scheduler;
        this.clock = clock;
        this.domain = config.domain();
        this.service = config.service();
        scheduler.submit(new RegisterInstanceTask());
        scheduler.schedule(new TimeoutInitialWaitTask(), INITIAL_WAIT_NTOKEN);
        this.metricUpdater = new CertificateExpiryMetricUpdater(metric);
    }

    @Override
    public String getNToken() {
        try {
            this.credentialsRetrievedSignal.await();
            AthenzCredentials credentialsSnapshot = this.credentials.get();
            if (credentialsSnapshot == null) {
                throw new AthenzIdentityProviderException("Could not retrieve Athenz credentials", this.lastThrowable.get());
            }
            if (this.isExpired(credentialsSnapshot)) {
                throw new AthenzIdentityProviderException("Athenz credentials are expired", this.lastThrowable.get());
            }
            return credentialsSnapshot.getNToken();
        }
        catch (InterruptedException e) {
            throw new AthenzIdentityProviderException("Failed to register instance credentials", this.lastThrowable.get());
        }
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public SSLContext getSslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(this.createKeyManagersWithServiceCertificate(), AthenzIdentityProviderImpl.createTrustManagersWithAthenzCa(), null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyManager[] createKeyManagersWithServiceCertificate() {
        try {
            this.credentialsRetrievedSignal.await();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setKeyEntry("instance-key", this.credentials.get().getKeyPair().getPrivate(), new char[0], new Certificate[]{this.credentials.get().getCertificate()});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, new char[0]);
            return keyManagerFactory.getKeyManagers();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AthenzIdentityProviderException("Failed to register instance credentials", this.lastThrowable.get());
        }
    }

    private static TrustManager[] createTrustManagersWithAthenzCa() {
        try {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            try (FileInputStream in = new FileInputStream("/opt/yahoo/share/ssl/certs/yahoo_certificate_bundle.jks");){
                trustStore.load(in, null);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public void deconstruct() {
        this.scheduler.shutdown(AWAIT_TERMINTATION_TIMEOUT);
    }

    private boolean isExpired(AthenzCredentials credentials) {
        return this.clock.instant().isAfter(AthenzIdentityProviderImpl.getExpirationTime(credentials));
    }

    private static Instant getExpirationTime(AthenzCredentials credentials) {
        return credentials.getCreatedAt().plus(EXPIRES_AFTER).minus(EXPIRATION_MARGIN);
    }

    public static interface RunnableWithTag
    extends Runnable {
        public String tag();
    }

    public static interface Scheduler {
        public void schedule(RunnableWithTag var1, Duration var2);

        default public void submit(RunnableWithTag runnable) {
            this.schedule(runnable, Duration.ZERO);
        }

        default public void shutdown(Duration timeout) {
        }
    }

    private static class ThreadPoolScheduler
    implements Scheduler {
        private static final Logger log = Logger.getLogger(ThreadPoolScheduler.class.getName());
        private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(0);

        private ThreadPoolScheduler() {
        }

        @Override
        public void schedule(RunnableWithTag runnable, Duration delay) {
            log.log(LogLevel.FINE, String.format("Scheduling task '%s' in '%s'", runnable.tag(), delay));
            this.executor.schedule(runnable, delay.getSeconds(), TimeUnit.SECONDS);
        }

        @Override
        public void submit(RunnableWithTag runnable) {
            log.log(LogLevel.FINE, String.format("Scheduling task '%s' now", runnable.tag()));
            this.executor.submit(runnable);
        }

        @Override
        public void shutdown(Duration timeout) {
            try {
                this.executor.shutdownNow();
                this.executor.awaitTermination(AWAIT_TERMINTATION_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class TimeoutInitialWaitTask
    implements RunnableWithTag {
        private TimeoutInitialWaitTask() {
        }

        @Override
        public void run() {
            AthenzIdentityProviderImpl.this.credentialsRetrievedSignal.countDown();
        }

        @Override
        public String tag() {
            return AthenzIdentityProviderImpl.TIMEOUT_INITIAL_WAIT_TAG;
        }
    }

    private class CertificateExpiryMetricUpdater
    implements RunnableWithTag {
        private final Metric metric;

        private CertificateExpiryMetricUpdater(Metric metric) {
            this.metric = metric;
        }

        @Override
        public void run() {
            Instant expirationTime = AthenzIdentityProviderImpl.getExpirationTime((AthenzCredentials)AthenzIdentityProviderImpl.this.credentials.get());
            Duration remainingLifetime = Duration.between(AthenzIdentityProviderImpl.this.clock.instant(), expirationTime);
            this.metric.set(AthenzIdentityProviderImpl.CERTIFICATE_EXPIRY_METRIC_NAME, (Number)remainingLifetime.getSeconds(), null);
            AthenzIdentityProviderImpl.this.scheduler.schedule(this, CERTIFICATE_EXPIRY_METRIC_UPDATE_PERIOD);
        }

        @Override
        public String tag() {
            return AthenzIdentityProviderImpl.METRICS_UPDATER_TAG;
        }
    }

    private class UpdateCredentialsTask
    implements RunnableWithTag {
        private UpdateCredentialsTask() {
        }

        @Override
        public void run() {
            AthenzCredentials currentCredentials = (AthenzCredentials)AthenzIdentityProviderImpl.this.credentials.get();
            try {
                AthenzCredentials newCredentials = AthenzIdentityProviderImpl.this.isExpired(currentCredentials) ? AthenzIdentityProviderImpl.this.athenzCredentialsService.registerInstance() : AthenzIdentityProviderImpl.this.athenzCredentialsService.updateCredentials(currentCredentials);
                AthenzIdentityProviderImpl.this.credentials.set(newCredentials);
                AthenzIdentityProviderImpl.this.scheduler.schedule(new UpdateCredentialsTask(), UPDATE_PERIOD);
            }
            catch (Throwable t) {
                log.log(LogLevel.WARNING, "Failed to update credentials: " + t.getMessage(), t);
                AthenzIdentityProviderImpl.this.lastThrowable.set(t);
                Duration timeToExpiration = Duration.between(AthenzIdentityProviderImpl.this.clock.instant(), AthenzIdentityProviderImpl.getExpirationTime(currentCredentials));
                Duration updatePeriod = timeToExpiration.compareTo(UPDATE_PERIOD) > 0 ? UPDATE_PERIOD : REDUCED_UPDATE_PERIOD;
                AthenzIdentityProviderImpl.this.scheduler.schedule(new UpdateCredentialsTask(), updatePeriod);
            }
        }

        @Override
        public String tag() {
            return AthenzIdentityProviderImpl.UPDATE_CREDENTIALS_TAG;
        }
    }

    private class RegisterInstanceTask
    implements RunnableWithTag {
        private final Duration backoffDelay;

        RegisterInstanceTask() {
            this(INITIAL_BACKOFF_DELAY);
        }

        RegisterInstanceTask(Duration backoffDelay) {
            this.backoffDelay = backoffDelay;
        }

        @Override
        public void run() {
            try {
                AthenzIdentityProviderImpl.this.credentials.set(AthenzIdentityProviderImpl.this.athenzCredentialsService.registerInstance());
                AthenzIdentityProviderImpl.this.credentialsRetrievedSignal.countDown();
                AthenzIdentityProviderImpl.this.scheduler.schedule(new UpdateCredentialsTask(), UPDATE_PERIOD);
                AthenzIdentityProviderImpl.this.scheduler.submit(AthenzIdentityProviderImpl.this.metricUpdater);
            }
            catch (Throwable t) {
                log.log((Level)LogLevel.ERROR, "Failed to register instance: " + t.getMessage(), t);
                AthenzIdentityProviderImpl.this.lastThrowable.set(t);
                Duration nextBackoffDelay = this.backoffDelay.multipliedBy(2L);
                if (nextBackoffDelay.compareTo(MAX_REGISTER_BACKOFF_DELAY) > 0) {
                    nextBackoffDelay = MAX_REGISTER_BACKOFF_DELAY;
                }
                AthenzIdentityProviderImpl.this.scheduler.schedule(new RegisterInstanceTask(nextBackoffDelay), this.backoffDelay);
            }
        }

        @Override
        public String tag() {
            return AthenzIdentityProviderImpl.REGISTER_INSTANCE_TAG;
        }
    }
}

