/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.component;

import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.protect.Process;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deconstructor
implements ComponentDeconstructor {
    private static final Logger log = Logger.getLogger(Deconstructor.class.getName());
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ThreadFactoryFactory.getThreadFactory((String)"deconstructor"));
    private final int delay;

    public Deconstructor(boolean delayDeconstruction) {
        this.delay = delayDeconstruction ? 60 : 0;
    }

    public void deconstruct(Object component) {
        if (component instanceof AbstractComponent) {
            AbstractComponent abstractComponent = (AbstractComponent)component;
            if (abstractComponent.isDeconstructable()) {
                log.info("Scheduling deconstruction of " + abstractComponent);
                this.executor.schedule(new DestructComponentTask(abstractComponent), (long)this.delay, TimeUnit.SECONDS);
            }
        } else if (component instanceof Provider) {
            ((Provider)component).deconstruct();
        } else if (component instanceof SharedResource) {
            ((SharedResource)component).release();
        }
    }

    private static class DestructComponentTask
    implements Runnable {
        private final AbstractComponent component;

        DestructComponentTask(AbstractComponent component) {
            this.component = component;
        }

        @Override
        public void run() {
            log.info("Starting deconstruction of " + this.component);
            try {
                this.component.deconstruct();
                log.info("Finished deconstructing " + this.component);
            }
            catch (Error e) {
                try {
                    Thread.sleep((long)(new Random(System.nanoTime()).nextDouble() * 180.0 * 1000.0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Process.logAndDie((String)("Error when deconstructing " + this.component), (Throwable)e);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception thrown when deconstructing " + this.component, e);
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Unexpected Throwable thrown when deconstructing " + this.component, t);
            }
        }
    }
}

