/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.core.identity.IdentityConfig;
import com.yahoo.container.jdisc.athenz.AthenzIdentityProvider;
import com.yahoo.container.jdisc.athenz.AthenzIdentityProviderException;
import com.yahoo.container.jdisc.athenz.impl.AthenzCredentials;
import com.yahoo.container.jdisc.athenz.impl.AthenzCredentialsService;
import com.yahoo.container.jdisc.athenz.impl.AthenzService;
import com.yahoo.container.jdisc.athenz.impl.IdentityDocumentService;
import com.yahoo.log.LogLevel;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AthenzIdentityProviderImpl
extends AbstractComponent
implements AthenzIdentityProvider {
    private static final Logger log = Logger.getLogger(AthenzIdentityProviderImpl.class.getName());
    static final Duration EXPIRES_AFTER = Duration.ofDays(1L);
    static final Duration EXPIRATION_MARGIN = Duration.ofMinutes(30L);
    static final Duration INITIAL_WAIT_NTOKEN = Duration.ofMinutes(5L);
    static final Duration UPDATE_PERIOD = EXPIRES_AFTER.dividedBy(3L);
    static final Duration REDUCED_UPDATE_PERIOD = Duration.ofMinutes(30L);
    static final Duration INITIAL_BACKOFF_DELAY = Duration.ofMinutes(4L);
    static final Duration MAX_REGISTER_BACKOFF_DELAY = Duration.ofHours(1L);
    static final int BACKOFF_DELAY_MULTIPLIER = 2;
    static final Duration AWAIT_TERMINTATION_TIMEOUT = Duration.ofSeconds(90L);
    static final String REGISTER_INSTANCE_TAG = "register-instance";
    static final String UPDATE_CREDENTIALS_TAG = "update-credentials";
    static final String TIMEOUT_INITIAL_WAIT_TAG = "timeout-initial-wait";
    private final AtomicReference<AthenzCredentials> credentials = new AtomicReference();
    private final AtomicReference<Throwable> lastThrowable = new AtomicReference();
    private final CountDownLatch credentialsRetrievedSignal = new CountDownLatch(1);
    private final AthenzCredentialsService athenzCredentialsService;
    private final Scheduler scheduler;
    private final Clock clock;
    private final String domain;
    private final String service;

    @Inject
    public AthenzIdentityProviderImpl(IdentityConfig config) {
        this(config, new AthenzCredentialsService(config, new IdentityDocumentService(config.loadBalancerAddress()), new AthenzService(), Clock.systemUTC()), new ThreadPoolScheduler(), Clock.systemUTC());
    }

    AthenzIdentityProviderImpl(IdentityConfig config, AthenzCredentialsService athenzCredentialsService, Scheduler scheduler, Clock clock) {
        this.athenzCredentialsService = athenzCredentialsService;
        this.scheduler = scheduler;
        this.clock = clock;
        this.domain = config.domain();
        this.service = config.service();
        scheduler.submit(new RegisterInstanceTask());
        scheduler.schedule(new TimeoutInitialWaitTask(), INITIAL_WAIT_NTOKEN);
    }

    @Override
    public String getNToken() {
        try {
            this.credentialsRetrievedSignal.await();
            AthenzCredentials credentialsSnapshot = this.credentials.get();
            if (credentialsSnapshot == null) {
                throw new AthenzIdentityProviderException("Could not retrieve Athenz credentials", this.lastThrowable.get());
            }
            if (this.isExpired(credentialsSnapshot)) {
                throw new AthenzIdentityProviderException("Athenz credentials are expired", this.lastThrowable.get());
            }
            return credentialsSnapshot.getNToken();
        }
        catch (InterruptedException e) {
            throw new AthenzIdentityProviderException("Failed to register instance credentials", this.lastThrowable.get());
        }
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getService() {
        return this.service;
    }

    public void deconstruct() {
        this.scheduler.shutdown(AWAIT_TERMINTATION_TIMEOUT);
    }

    private boolean isExpired(AthenzCredentials credentials) {
        return this.clock.instant().isAfter(AthenzIdentityProviderImpl.getExpirationTime(credentials));
    }

    private static Instant getExpirationTime(AthenzCredentials credentials) {
        return credentials.getCreatedAt().plus(EXPIRES_AFTER).minus(EXPIRATION_MARGIN);
    }

    public static interface RunnableWithTag
    extends Runnable {
        public String tag();
    }

    public static interface Scheduler {
        public void schedule(RunnableWithTag var1, Duration var2);

        default public void submit(RunnableWithTag runnable) {
            this.schedule(runnable, Duration.ZERO);
        }

        default public void shutdown(Duration timeout) {
        }
    }

    private static class ThreadPoolScheduler
    implements Scheduler {
        private static final Logger log = Logger.getLogger(ThreadPoolScheduler.class.getName());
        private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(0);

        private ThreadPoolScheduler() {
        }

        @Override
        public void schedule(RunnableWithTag runnable, Duration delay) {
            log.log(LogLevel.FINE, String.format("Scheduling task '%s' in '%s'", runnable.tag(), delay));
            this.executor.schedule(runnable, delay.getSeconds(), TimeUnit.SECONDS);
        }

        @Override
        public void submit(RunnableWithTag runnable) {
            log.log(LogLevel.FINE, String.format("Scheduling task '%s' now", runnable.tag()));
            this.executor.submit(runnable);
        }

        @Override
        public void shutdown(Duration timeout) {
            try {
                this.executor.shutdownNow();
                this.executor.awaitTermination(AWAIT_TERMINTATION_TIMEOUT.getSeconds(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class TimeoutInitialWaitTask
    implements RunnableWithTag {
        private TimeoutInitialWaitTask() {
        }

        @Override
        public void run() {
            AthenzIdentityProviderImpl.this.credentialsRetrievedSignal.countDown();
        }

        @Override
        public String tag() {
            return AthenzIdentityProviderImpl.TIMEOUT_INITIAL_WAIT_TAG;
        }
    }

    private class UpdateCredentialsTask
    implements RunnableWithTag {
        private UpdateCredentialsTask() {
        }

        @Override
        public void run() {
            AthenzCredentials currentCredentials = (AthenzCredentials)AthenzIdentityProviderImpl.this.credentials.get();
            try {
                AthenzCredentials newCredentials = AthenzIdentityProviderImpl.this.isExpired(currentCredentials) ? AthenzIdentityProviderImpl.this.athenzCredentialsService.registerInstance() : AthenzIdentityProviderImpl.this.athenzCredentialsService.updateCredentials(currentCredentials);
                AthenzIdentityProviderImpl.this.credentials.set(newCredentials);
                AthenzIdentityProviderImpl.this.scheduler.schedule(new UpdateCredentialsTask(), UPDATE_PERIOD);
            }
            catch (Throwable t) {
                log.log(LogLevel.WARNING, "Failed to update credentials: " + t.getMessage(), t);
                AthenzIdentityProviderImpl.this.lastThrowable.set(t);
                Duration timeToExpiration = Duration.between(AthenzIdentityProviderImpl.this.clock.instant(), AthenzIdentityProviderImpl.getExpirationTime(currentCredentials));
                Duration updatePeriod = timeToExpiration.compareTo(UPDATE_PERIOD) > 0 ? UPDATE_PERIOD : REDUCED_UPDATE_PERIOD;
                AthenzIdentityProviderImpl.this.scheduler.schedule(new UpdateCredentialsTask(), updatePeriod);
            }
        }

        @Override
        public String tag() {
            return AthenzIdentityProviderImpl.UPDATE_CREDENTIALS_TAG;
        }
    }

    private class RegisterInstanceTask
    implements RunnableWithTag {
        private final Duration backoffDelay;

        RegisterInstanceTask() {
            this(INITIAL_BACKOFF_DELAY);
        }

        RegisterInstanceTask(Duration backoffDelay) {
            this.backoffDelay = backoffDelay;
        }

        @Override
        public void run() {
            try {
                AthenzIdentityProviderImpl.this.credentials.set(AthenzIdentityProviderImpl.this.athenzCredentialsService.registerInstance());
                AthenzIdentityProviderImpl.this.credentialsRetrievedSignal.countDown();
                AthenzIdentityProviderImpl.this.scheduler.schedule(new UpdateCredentialsTask(), UPDATE_PERIOD);
            }
            catch (Throwable t) {
                log.log((Level)LogLevel.ERROR, "Failed to register instance: " + t.getMessage(), t);
                AthenzIdentityProviderImpl.this.lastThrowable.set(t);
                Duration nextBackoffDelay = this.backoffDelay.multipliedBy(2L);
                if (nextBackoffDelay.compareTo(MAX_REGISTER_BACKOFF_DELAY) > 0) {
                    nextBackoffDelay = MAX_REGISTER_BACKOFF_DELAY;
                }
                AthenzIdentityProviderImpl.this.scheduler.schedule(new RegisterInstanceTask(nextBackoffDelay), this.backoffDelay);
            }
        }

        @Override
        public String tag() {
            return AthenzIdentityProviderImpl.REGISTER_INSTANCE_TAG;
        }
    }
}

