/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.yahoo.vespa.defaults.Defaults;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.http.HttpStatus;

public class ServiceProviderApi {
    private final URI providerUri;

    public ServiceProviderApi(String providerAddress) {
        this.providerUri = URI.create(String.format("https://%s:8443/athenz/v1/provider", providerAddress));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSignedIdentityDocument() {
        try (CloseableHttpClient httpClient = ServiceProviderApi.createHttpClient();){
            String uri = this.providerUri + "/identity-document?hostname=" + URLEncoder.encode(Defaults.getDefaults().vespaHostname(), "UTF-8");
            HttpUriRequest request = RequestBuilder.get().setUri(uri).build();
            CloseableHttpResponse idDocResponse = httpClient.execute(request);
            String responseContent = EntityUtils.toString((HttpEntity)idDocResponse.getEntity());
            if (HttpStatus.isSuccess((int)idDocResponse.getStatusLine().getStatusCode())) {
                String string = responseContent;
                return string;
            }
            throw new RuntimeException("Failed to initialize Athenz instance provider: " + idDocResponse.getStatusLine() + ": " + responseContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed getting signed identity document", e);
        }
    }

    private static CloseableHttpClient createHttpClient() {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

