/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.core.identity.IdentityConfig;
import com.yahoo.container.jdisc.athenz.AthenzIdentityProvider;
import com.yahoo.container.jdisc.athenz.impl.AthenzService;
import com.yahoo.container.jdisc.athenz.impl.CryptoUtils;
import com.yahoo.container.jdisc.athenz.impl.InstanceIdentity;
import com.yahoo.container.jdisc.athenz.impl.InstanceRegisterInformation;
import com.yahoo.container.jdisc.athenz.impl.ServiceProviderApi;
import com.yahoo.container.jdisc.athenz.impl.SignedIdentityDocument;
import java.io.IOException;
import java.security.KeyPair;

public final class AthenzIdentityProviderImpl
extends AbstractComponent
implements AthenzIdentityProvider {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private InstanceIdentity instanceIdentity;
    private final String dnsSuffix;
    private final String providerUniqueId;
    private final String domain;
    private final String service;

    @Inject
    public AthenzIdentityProviderImpl(IdentityConfig config) throws IOException {
        this(config, new ServiceProviderApi(config.loadBalancerAddress()), new AthenzService());
    }

    AthenzIdentityProviderImpl(IdentityConfig config, ServiceProviderApi serviceProviderApi, AthenzService athenzService) throws IOException {
        KeyPair keyPair = CryptoUtils.createKeyPair();
        this.domain = config.domain();
        this.service = config.service();
        String rawDocument = serviceProviderApi.getSignedIdentityDocument();
        SignedIdentityDocument document = (SignedIdentityDocument)this.objectMapper.readValue(rawDocument, SignedIdentityDocument.class);
        this.dnsSuffix = document.dnsSuffix;
        this.providerUniqueId = document.providerUniqueId;
        InstanceRegisterInformation instanceRegisterInformation = new InstanceRegisterInformation(document.providerService, this.domain, this.service, rawDocument, CryptoUtils.toPem(CryptoUtils.createCSR(this.domain, this.service, this.dnsSuffix, this.providerUniqueId, keyPair)), true);
        this.instanceIdentity = athenzService.sendInstanceRegisterRequest(instanceRegisterInformation, document.ztsEndpoint);
    }

    @Override
    public String getNToken() {
        return this.instanceIdentity.getServiceToken();
    }

    @Override
    public String getX509Cert() {
        return this.instanceIdentity.getX509Certificate();
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public String service() {
        return this.service;
    }
}

