/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class HttpServerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "e5b8ea27fc89e28b884941a264368ee2";
    public static final String CONFIG_DEF_NAME = "http-server";
    public static final String CONFIG_DEF_NAMESPACE = "container.jdisc.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.jdisc.config", "serverName string default=\"default\"", "tcpKeepAliveEnabled bool default=false", "httpKeepAliveEnabled bool default=true", "optimizedForPipeline bool default=false", "removeRawPostBodyForWwwUrlEncodedPost bool default=false", "responseChunkingEnabled bool default=true", "tcpNoDelayEnabled bool default=true", "listenPort int", "maxChunkSize int default=65536", "maxHeaderSize int default=65536", "maxInitialLineLength int default=65536", "maxUnchunkedResponseSize int default=10362880", "numWorkerThreads int default=16", "receiveBufferSize int default=-1", "responseCompressionLevel int default=6", "sendBufferSize int default=-1", "tcpListenBacklogLength int default=0", "connectTimeout double default=10", "idleConnectionTimeout double default=180", "soLinger double default=-1", "perRequestMetricsEnabled bool default=false", "metricUpdateInterval double default=1", "ssl.enabled bool default=false", "ssl.keyStoreType string default=\"JKS\"", "ssl.keyStorePath string default=\"default\"", "ssl.trustStorePath string default=\"default\"", "ssl.keyDBKey string default=\"\"", "ssl.algorithm string default=\"SunX509\"", "ssl.protocol string default=\"TLS\"", "filter[].id string", "filter[].binding string", "accessLog.bufferSize int default = 10240", "accessLog.flushTimeout double default = 5", "accessLog.fileName string default = \"\"", "accessLog.rotatable bool default = false", "accessLog.directory string default = \"logs/jdisc_core\"", "accessLog.prefix string default = \"access_log.\"", "accessLog.suffix string default = \"\"", "accessLog.fileDateFormat string default = \"yyyy-MM-dd\""};
    private final StringNode serverName;
    private final BooleanNode tcpKeepAliveEnabled;
    private final BooleanNode httpKeepAliveEnabled;
    private final BooleanNode optimizedForPipeline;
    private final BooleanNode removeRawPostBodyForWwwUrlEncodedPost;
    private final BooleanNode responseChunkingEnabled;
    private final BooleanNode tcpNoDelayEnabled;
    private final IntegerNode listenPort;
    private final IntegerNode maxChunkSize;
    private final IntegerNode maxHeaderSize;
    private final IntegerNode maxInitialLineLength;
    private final IntegerNode maxUnchunkedResponseSize;
    private final IntegerNode numWorkerThreads;
    private final IntegerNode receiveBufferSize;
    private final IntegerNode responseCompressionLevel;
    private final IntegerNode sendBufferSize;
    private final IntegerNode tcpListenBacklogLength;
    private final DoubleNode connectTimeout;
    private final DoubleNode idleConnectionTimeout;
    private final DoubleNode soLinger;
    private final BooleanNode perRequestMetricsEnabled;
    private final DoubleNode metricUpdateInterval;
    private final Ssl ssl;
    private final InnerNodeVector<Filter> filter;
    private final AccessLog accessLog;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public HttpServerConfig(Builder builder) {
        this(builder, true);
    }

    private HttpServerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for http-server must be initialized: " + builder.__uninitialized);
        }
        this.serverName = builder.serverName == null ? new StringNode("default") : new StringNode(builder.serverName);
        this.tcpKeepAliveEnabled = builder.tcpKeepAliveEnabled == null ? new BooleanNode(false) : new BooleanNode(builder.tcpKeepAliveEnabled.booleanValue());
        this.httpKeepAliveEnabled = builder.httpKeepAliveEnabled == null ? new BooleanNode(true) : new BooleanNode(builder.httpKeepAliveEnabled.booleanValue());
        this.optimizedForPipeline = builder.optimizedForPipeline == null ? new BooleanNode(false) : new BooleanNode(builder.optimizedForPipeline.booleanValue());
        this.removeRawPostBodyForWwwUrlEncodedPost = builder.removeRawPostBodyForWwwUrlEncodedPost == null ? new BooleanNode(false) : new BooleanNode(builder.removeRawPostBodyForWwwUrlEncodedPost.booleanValue());
        this.responseChunkingEnabled = builder.responseChunkingEnabled == null ? new BooleanNode(true) : new BooleanNode(builder.responseChunkingEnabled.booleanValue());
        this.tcpNoDelayEnabled = builder.tcpNoDelayEnabled == null ? new BooleanNode(true) : new BooleanNode(builder.tcpNoDelayEnabled.booleanValue());
        this.listenPort = builder.listenPort == null ? new IntegerNode() : new IntegerNode(builder.listenPort.intValue());
        this.maxChunkSize = builder.maxChunkSize == null ? new IntegerNode(65536) : new IntegerNode(builder.maxChunkSize.intValue());
        this.maxHeaderSize = builder.maxHeaderSize == null ? new IntegerNode(65536) : new IntegerNode(builder.maxHeaderSize.intValue());
        this.maxInitialLineLength = builder.maxInitialLineLength == null ? new IntegerNode(65536) : new IntegerNode(builder.maxInitialLineLength.intValue());
        this.maxUnchunkedResponseSize = builder.maxUnchunkedResponseSize == null ? new IntegerNode(10362880) : new IntegerNode(builder.maxUnchunkedResponseSize.intValue());
        this.numWorkerThreads = builder.numWorkerThreads == null ? new IntegerNode(16) : new IntegerNode(builder.numWorkerThreads.intValue());
        this.receiveBufferSize = builder.receiveBufferSize == null ? new IntegerNode(-1) : new IntegerNode(builder.receiveBufferSize.intValue());
        this.responseCompressionLevel = builder.responseCompressionLevel == null ? new IntegerNode(6) : new IntegerNode(builder.responseCompressionLevel.intValue());
        this.sendBufferSize = builder.sendBufferSize == null ? new IntegerNode(-1) : new IntegerNode(builder.sendBufferSize.intValue());
        this.tcpListenBacklogLength = builder.tcpListenBacklogLength == null ? new IntegerNode(0) : new IntegerNode(builder.tcpListenBacklogLength.intValue());
        this.connectTimeout = builder.connectTimeout == null ? new DoubleNode(10.0) : new DoubleNode(builder.connectTimeout.doubleValue());
        this.idleConnectionTimeout = builder.idleConnectionTimeout == null ? new DoubleNode(180.0) : new DoubleNode(builder.idleConnectionTimeout.doubleValue());
        this.soLinger = builder.soLinger == null ? new DoubleNode(-1.0) : new DoubleNode(builder.soLinger.doubleValue());
        this.perRequestMetricsEnabled = builder.perRequestMetricsEnabled == null ? new BooleanNode(false) : new BooleanNode(builder.perRequestMetricsEnabled.booleanValue());
        this.metricUpdateInterval = builder.metricUpdateInterval == null ? new DoubleNode(1.0) : new DoubleNode(builder.metricUpdateInterval.doubleValue());
        this.ssl = new Ssl(builder.ssl, throwIfUninitialized);
        this.filter = Filter.createVector(builder.filter);
        this.accessLog = new AccessLog(builder.accessLog, throwIfUninitialized);
    }

    public String serverName() {
        return this.serverName.value();
    }

    public boolean tcpKeepAliveEnabled() {
        return this.tcpKeepAliveEnabled.value();
    }

    public boolean httpKeepAliveEnabled() {
        return this.httpKeepAliveEnabled.value();
    }

    public boolean optimizedForPipeline() {
        return this.optimizedForPipeline.value();
    }

    public boolean removeRawPostBodyForWwwUrlEncodedPost() {
        return this.removeRawPostBodyForWwwUrlEncodedPost.value();
    }

    public boolean responseChunkingEnabled() {
        return this.responseChunkingEnabled.value();
    }

    public boolean tcpNoDelayEnabled() {
        return this.tcpNoDelayEnabled.value();
    }

    public int listenPort() {
        return this.listenPort.value();
    }

    public int maxChunkSize() {
        return this.maxChunkSize.value();
    }

    public int maxHeaderSize() {
        return this.maxHeaderSize.value();
    }

    public int maxInitialLineLength() {
        return this.maxInitialLineLength.value();
    }

    public int maxUnchunkedResponseSize() {
        return this.maxUnchunkedResponseSize.value();
    }

    public int numWorkerThreads() {
        return this.numWorkerThreads.value();
    }

    public int receiveBufferSize() {
        return this.receiveBufferSize.value();
    }

    public int responseCompressionLevel() {
        return this.responseCompressionLevel.value();
    }

    public int sendBufferSize() {
        return this.sendBufferSize.value();
    }

    public int tcpListenBacklogLength() {
        return this.tcpListenBacklogLength.value();
    }

    public double connectTimeout() {
        return this.connectTimeout.value();
    }

    public double idleConnectionTimeout() {
        return this.idleConnectionTimeout.value();
    }

    public double soLinger() {
        return this.soLinger.value();
    }

    public boolean perRequestMetricsEnabled() {
        return this.perRequestMetricsEnabled.value();
    }

    public double metricUpdateInterval() {
        return this.metricUpdateInterval.value();
    }

    public Ssl ssl() {
        return this.ssl;
    }

    public List<Filter> filter() {
        return this.filter;
    }

    public Filter filter(int i) {
        return (Filter)((Object)this.filter.get(i));
    }

    public AccessLog accessLog() {
        return this.accessLog;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HttpServerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class AccessLog
    extends InnerNode {
        private final IntegerNode bufferSize;
        private final DoubleNode flushTimeout;
        private final StringNode fileName;
        private final BooleanNode rotatable;
        private final StringNode directory;
        private final StringNode prefix;
        private final StringNode suffix;
        private final StringNode fileDateFormat;

        public AccessLog(Builder builder) {
            this(builder, true);
        }

        private AccessLog(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for http-server.accessLog must be initialized: " + builder.__uninitialized);
            }
            this.bufferSize = builder.bufferSize == null ? new IntegerNode(10240) : new IntegerNode(builder.bufferSize.intValue());
            this.flushTimeout = builder.flushTimeout == null ? new DoubleNode(5.0) : new DoubleNode(builder.flushTimeout.doubleValue());
            this.fileName = builder.fileName == null ? new StringNode(HttpServerConfig.CONFIG_DEF_VERSION) : new StringNode(builder.fileName);
            this.rotatable = builder.rotatable == null ? new BooleanNode(false) : new BooleanNode(builder.rotatable.booleanValue());
            this.directory = builder.directory == null ? new StringNode("logs/jdisc_core") : new StringNode(builder.directory);
            this.prefix = builder.prefix == null ? new StringNode("access_log.") : new StringNode(builder.prefix);
            this.suffix = builder.suffix == null ? new StringNode(HttpServerConfig.CONFIG_DEF_VERSION) : new StringNode(builder.suffix);
            this.fileDateFormat = builder.fileDateFormat == null ? new StringNode("yyyy-MM-dd") : new StringNode(builder.fileDateFormat);
        }

        public int bufferSize() {
            return this.bufferSize.value();
        }

        public double flushTimeout() {
            return this.flushTimeout.value();
        }

        public String fileName() {
            return this.fileName.value();
        }

        public boolean rotatable() {
            return this.rotatable.value();
        }

        public String directory() {
            return this.directory.value();
        }

        public String prefix() {
            return this.prefix.value();
        }

        public String suffix() {
            return this.suffix.value();
        }

        public String fileDateFormat() {
            return this.fileDateFormat.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(AccessLog newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("accessLog");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer bufferSize = null;
            private Double flushTimeout = null;
            private String fileName = null;
            private Boolean rotatable = null;
            private String directory = null;
            private String prefix = null;
            private String suffix = null;
            private String fileDateFormat = null;

            public Builder() {
            }

            public Builder(AccessLog config) {
                this.bufferSize(config.bufferSize());
                this.flushTimeout(config.flushTimeout());
                this.fileName(config.fileName());
                this.rotatable(config.rotatable());
                this.directory(config.directory());
                this.prefix(config.prefix());
                this.suffix(config.suffix());
                this.fileDateFormat(config.fileDateFormat());
            }

            private Builder override(Builder __superior) {
                if (__superior.bufferSize != null) {
                    this.bufferSize(__superior.bufferSize);
                }
                if (__superior.flushTimeout != null) {
                    this.flushTimeout(__superior.flushTimeout);
                }
                if (__superior.fileName != null) {
                    this.fileName(__superior.fileName);
                }
                if (__superior.rotatable != null) {
                    this.rotatable(__superior.rotatable);
                }
                if (__superior.directory != null) {
                    this.directory(__superior.directory);
                }
                if (__superior.prefix != null) {
                    this.prefix(__superior.prefix);
                }
                if (__superior.suffix != null) {
                    this.suffix(__superior.suffix);
                }
                if (__superior.fileDateFormat != null) {
                    this.fileDateFormat(__superior.fileDateFormat);
                }
                return this;
            }

            public Builder bufferSize(int __value) {
                this.bufferSize = __value;
                return this;
            }

            private Builder bufferSize(String __value) {
                return this.bufferSize(Integer.valueOf(__value));
            }

            public Builder flushTimeout(double __value) {
                this.flushTimeout = __value;
                return this;
            }

            private Builder flushTimeout(String __value) {
                return this.flushTimeout(Double.valueOf(__value));
            }

            public Builder fileName(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fileName = __value;
                return this;
            }

            public Builder rotatable(boolean __value) {
                this.rotatable = __value;
                return this;
            }

            private Builder rotatable(String __value) {
                return this.rotatable(Boolean.valueOf(__value));
            }

            public Builder directory(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.directory = __value;
                return this;
            }

            public Builder prefix(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.prefix = __value;
                return this;
            }

            public Builder suffix(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.suffix = __value;
                return this;
            }

            public Builder fileDateFormat(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fileDateFormat = __value;
                return this;
            }
        }
    }

    public static final class Filter
    extends InnerNode {
        private final StringNode id;
        private final StringNode binding;

        @Deprecated
        private Filter() {
            this(new Builder(), false);
        }

        public Filter(Builder builder) {
            this(builder, true);
        }

        private Filter(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for http-server.filter[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new StringNode() : new StringNode(builder.id);
            this.binding = builder.binding == null ? new StringNode() : new StringNode(builder.binding);
        }

        public String id() {
            return this.id.value();
        }

        public String binding() {
            return this.binding.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Filter newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("filter");
            return changes;
        }

        private static InnerNodeVector<Filter> createVector(List<Builder> builders) {
            ArrayList<Filter> elems = new ArrayList<Filter>();
            for (Builder b : builders) {
                elems.add(new Filter(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Filter());
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "binding"));
            private String id = null;
            private String binding = null;

            public Builder() {
            }

            public Builder(Filter config) {
                this.id(config.id());
                this.binding(config.binding());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.binding != null) {
                    this.binding(__superior.binding);
                }
                return this;
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder binding(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.binding = __value;
                this.__uninitialized.remove("binding");
                return this;
            }
        }
    }

    public static final class Ssl
    extends InnerNode {
        private final BooleanNode enabled;
        private final StringNode keyStoreType;
        private final StringNode keyStorePath;
        private final StringNode trustStorePath;
        private final StringNode keyDBKey;
        private final StringNode algorithm;
        private final StringNode protocol;

        public Ssl(Builder builder) {
            this(builder, true);
        }

        private Ssl(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for http-server.ssl must be initialized: " + builder.__uninitialized);
            }
            this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
            this.keyStoreType = builder.keyStoreType == null ? new StringNode("JKS") : new StringNode(builder.keyStoreType);
            this.keyStorePath = builder.keyStorePath == null ? new StringNode("default") : new StringNode(builder.keyStorePath);
            this.trustStorePath = builder.trustStorePath == null ? new StringNode("default") : new StringNode(builder.trustStorePath);
            this.keyDBKey = builder.keyDBKey == null ? new StringNode(HttpServerConfig.CONFIG_DEF_VERSION) : new StringNode(builder.keyDBKey);
            this.algorithm = builder.algorithm == null ? new StringNode("SunX509") : new StringNode(builder.algorithm);
            this.protocol = builder.protocol == null ? new StringNode("TLS") : new StringNode(builder.protocol);
        }

        public boolean enabled() {
            return this.enabled.value();
        }

        public String keyStoreType() {
            return this.keyStoreType.value();
        }

        public String keyStorePath() {
            return this.keyStorePath.value();
        }

        public String trustStorePath() {
            return this.trustStorePath.value();
        }

        public String keyDBKey() {
            return this.keyDBKey.value();
        }

        public String algorithm() {
            return this.algorithm.value();
        }

        public String protocol() {
            return this.protocol.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Ssl newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("ssl");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean enabled = null;
            private String keyStoreType = null;
            private String keyStorePath = null;
            private String trustStorePath = null;
            private String keyDBKey = null;
            private String algorithm = null;
            private String protocol = null;

            public Builder() {
            }

            public Builder(Ssl config) {
                this.enabled(config.enabled());
                this.keyStoreType(config.keyStoreType());
                this.keyStorePath(config.keyStorePath());
                this.trustStorePath(config.trustStorePath());
                this.keyDBKey(config.keyDBKey());
                this.algorithm(config.algorithm());
                this.protocol(config.protocol());
            }

            private Builder override(Builder __superior) {
                if (__superior.enabled != null) {
                    this.enabled(__superior.enabled);
                }
                if (__superior.keyStoreType != null) {
                    this.keyStoreType(__superior.keyStoreType);
                }
                if (__superior.keyStorePath != null) {
                    this.keyStorePath(__superior.keyStorePath);
                }
                if (__superior.trustStorePath != null) {
                    this.trustStorePath(__superior.trustStorePath);
                }
                if (__superior.keyDBKey != null) {
                    this.keyDBKey(__superior.keyDBKey);
                }
                if (__superior.algorithm != null) {
                    this.algorithm(__superior.algorithm);
                }
                if (__superior.protocol != null) {
                    this.protocol(__superior.protocol);
                }
                return this;
            }

            public Builder enabled(boolean __value) {
                this.enabled = __value;
                return this;
            }

            private Builder enabled(String __value) {
                return this.enabled(Boolean.valueOf(__value));
            }

            public Builder keyStoreType(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.keyStoreType = __value;
                return this;
            }

            public Builder keyStorePath(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.keyStorePath = __value;
                return this;
            }

            public Builder trustStorePath(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.trustStorePath = __value;
                return this;
            }

            public Builder keyDBKey(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.keyDBKey = __value;
                return this;
            }

            public Builder algorithm(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.algorithm = __value;
                return this;
            }

            public Builder protocol(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.protocol = __value;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("listenPort"));
        private String serverName = null;
        private Boolean tcpKeepAliveEnabled = null;
        private Boolean httpKeepAliveEnabled = null;
        private Boolean optimizedForPipeline = null;
        private Boolean removeRawPostBodyForWwwUrlEncodedPost = null;
        private Boolean responseChunkingEnabled = null;
        private Boolean tcpNoDelayEnabled = null;
        private Integer listenPort = null;
        private Integer maxChunkSize = null;
        private Integer maxHeaderSize = null;
        private Integer maxInitialLineLength = null;
        private Integer maxUnchunkedResponseSize = null;
        private Integer numWorkerThreads = null;
        private Integer receiveBufferSize = null;
        private Integer responseCompressionLevel = null;
        private Integer sendBufferSize = null;
        private Integer tcpListenBacklogLength = null;
        private Double connectTimeout = null;
        private Double idleConnectionTimeout = null;
        private Double soLinger = null;
        private Boolean perRequestMetricsEnabled = null;
        private Double metricUpdateInterval = null;
        public Ssl.Builder ssl = new Ssl.Builder();
        public List<Filter.Builder> filter = new ArrayList<Filter.Builder>();
        public AccessLog.Builder accessLog = new AccessLog.Builder();

        public Builder() {
        }

        public Builder(HttpServerConfig config) {
            this.serverName(config.serverName());
            this.tcpKeepAliveEnabled(config.tcpKeepAliveEnabled());
            this.httpKeepAliveEnabled(config.httpKeepAliveEnabled());
            this.optimizedForPipeline(config.optimizedForPipeline());
            this.removeRawPostBodyForWwwUrlEncodedPost(config.removeRawPostBodyForWwwUrlEncodedPost());
            this.responseChunkingEnabled(config.responseChunkingEnabled());
            this.tcpNoDelayEnabled(config.tcpNoDelayEnabled());
            this.listenPort(config.listenPort());
            this.maxChunkSize(config.maxChunkSize());
            this.maxHeaderSize(config.maxHeaderSize());
            this.maxInitialLineLength(config.maxInitialLineLength());
            this.maxUnchunkedResponseSize(config.maxUnchunkedResponseSize());
            this.numWorkerThreads(config.numWorkerThreads());
            this.receiveBufferSize(config.receiveBufferSize());
            this.responseCompressionLevel(config.responseCompressionLevel());
            this.sendBufferSize(config.sendBufferSize());
            this.tcpListenBacklogLength(config.tcpListenBacklogLength());
            this.connectTimeout(config.connectTimeout());
            this.idleConnectionTimeout(config.idleConnectionTimeout());
            this.soLinger(config.soLinger());
            this.perRequestMetricsEnabled(config.perRequestMetricsEnabled());
            this.metricUpdateInterval(config.metricUpdateInterval());
            this.ssl(new Ssl.Builder(config.ssl()));
            for (Filter f : config.filter()) {
                this.filter(new Filter.Builder(f));
            }
            this.accessLog(new AccessLog.Builder(config.accessLog()));
        }

        private Builder override(Builder __superior) {
            if (__superior.serverName != null) {
                this.serverName(__superior.serverName);
            }
            if (__superior.tcpKeepAliveEnabled != null) {
                this.tcpKeepAliveEnabled(__superior.tcpKeepAliveEnabled);
            }
            if (__superior.httpKeepAliveEnabled != null) {
                this.httpKeepAliveEnabled(__superior.httpKeepAliveEnabled);
            }
            if (__superior.optimizedForPipeline != null) {
                this.optimizedForPipeline(__superior.optimizedForPipeline);
            }
            if (__superior.removeRawPostBodyForWwwUrlEncodedPost != null) {
                this.removeRawPostBodyForWwwUrlEncodedPost(__superior.removeRawPostBodyForWwwUrlEncodedPost);
            }
            if (__superior.responseChunkingEnabled != null) {
                this.responseChunkingEnabled(__superior.responseChunkingEnabled);
            }
            if (__superior.tcpNoDelayEnabled != null) {
                this.tcpNoDelayEnabled(__superior.tcpNoDelayEnabled);
            }
            if (__superior.listenPort != null) {
                this.listenPort(__superior.listenPort);
            }
            if (__superior.maxChunkSize != null) {
                this.maxChunkSize(__superior.maxChunkSize);
            }
            if (__superior.maxHeaderSize != null) {
                this.maxHeaderSize(__superior.maxHeaderSize);
            }
            if (__superior.maxInitialLineLength != null) {
                this.maxInitialLineLength(__superior.maxInitialLineLength);
            }
            if (__superior.maxUnchunkedResponseSize != null) {
                this.maxUnchunkedResponseSize(__superior.maxUnchunkedResponseSize);
            }
            if (__superior.numWorkerThreads != null) {
                this.numWorkerThreads(__superior.numWorkerThreads);
            }
            if (__superior.receiveBufferSize != null) {
                this.receiveBufferSize(__superior.receiveBufferSize);
            }
            if (__superior.responseCompressionLevel != null) {
                this.responseCompressionLevel(__superior.responseCompressionLevel);
            }
            if (__superior.sendBufferSize != null) {
                this.sendBufferSize(__superior.sendBufferSize);
            }
            if (__superior.tcpListenBacklogLength != null) {
                this.tcpListenBacklogLength(__superior.tcpListenBacklogLength);
            }
            if (__superior.connectTimeout != null) {
                this.connectTimeout(__superior.connectTimeout);
            }
            if (__superior.idleConnectionTimeout != null) {
                this.idleConnectionTimeout(__superior.idleConnectionTimeout);
            }
            if (__superior.soLinger != null) {
                this.soLinger(__superior.soLinger);
            }
            if (__superior.perRequestMetricsEnabled != null) {
                this.perRequestMetricsEnabled(__superior.perRequestMetricsEnabled);
            }
            if (__superior.metricUpdateInterval != null) {
                this.metricUpdateInterval(__superior.metricUpdateInterval);
            }
            this.ssl(this.ssl.override(__superior.ssl));
            if (!__superior.filter.isEmpty()) {
                this.filter.addAll(__superior.filter);
            }
            this.accessLog(this.accessLog.override(__superior.accessLog));
            return this;
        }

        public Builder serverName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.serverName = __value;
            return this;
        }

        public Builder tcpKeepAliveEnabled(boolean __value) {
            this.tcpKeepAliveEnabled = __value;
            return this;
        }

        private Builder tcpKeepAliveEnabled(String __value) {
            return this.tcpKeepAliveEnabled(Boolean.valueOf(__value));
        }

        public Builder httpKeepAliveEnabled(boolean __value) {
            this.httpKeepAliveEnabled = __value;
            return this;
        }

        private Builder httpKeepAliveEnabled(String __value) {
            return this.httpKeepAliveEnabled(Boolean.valueOf(__value));
        }

        public Builder optimizedForPipeline(boolean __value) {
            this.optimizedForPipeline = __value;
            return this;
        }

        private Builder optimizedForPipeline(String __value) {
            return this.optimizedForPipeline(Boolean.valueOf(__value));
        }

        public Builder removeRawPostBodyForWwwUrlEncodedPost(boolean __value) {
            this.removeRawPostBodyForWwwUrlEncodedPost = __value;
            return this;
        }

        private Builder removeRawPostBodyForWwwUrlEncodedPost(String __value) {
            return this.removeRawPostBodyForWwwUrlEncodedPost(Boolean.valueOf(__value));
        }

        public Builder responseChunkingEnabled(boolean __value) {
            this.responseChunkingEnabled = __value;
            return this;
        }

        private Builder responseChunkingEnabled(String __value) {
            return this.responseChunkingEnabled(Boolean.valueOf(__value));
        }

        public Builder tcpNoDelayEnabled(boolean __value) {
            this.tcpNoDelayEnabled = __value;
            return this;
        }

        private Builder tcpNoDelayEnabled(String __value) {
            return this.tcpNoDelayEnabled(Boolean.valueOf(__value));
        }

        public Builder listenPort(int __value) {
            this.listenPort = __value;
            this.__uninitialized.remove("listenPort");
            return this;
        }

        private Builder listenPort(String __value) {
            return this.listenPort(Integer.valueOf(__value));
        }

        public Builder maxChunkSize(int __value) {
            this.maxChunkSize = __value;
            return this;
        }

        private Builder maxChunkSize(String __value) {
            return this.maxChunkSize(Integer.valueOf(__value));
        }

        public Builder maxHeaderSize(int __value) {
            this.maxHeaderSize = __value;
            return this;
        }

        private Builder maxHeaderSize(String __value) {
            return this.maxHeaderSize(Integer.valueOf(__value));
        }

        public Builder maxInitialLineLength(int __value) {
            this.maxInitialLineLength = __value;
            return this;
        }

        private Builder maxInitialLineLength(String __value) {
            return this.maxInitialLineLength(Integer.valueOf(__value));
        }

        public Builder maxUnchunkedResponseSize(int __value) {
            this.maxUnchunkedResponseSize = __value;
            return this;
        }

        private Builder maxUnchunkedResponseSize(String __value) {
            return this.maxUnchunkedResponseSize(Integer.valueOf(__value));
        }

        public Builder numWorkerThreads(int __value) {
            this.numWorkerThreads = __value;
            return this;
        }

        private Builder numWorkerThreads(String __value) {
            return this.numWorkerThreads(Integer.valueOf(__value));
        }

        public Builder receiveBufferSize(int __value) {
            this.receiveBufferSize = __value;
            return this;
        }

        private Builder receiveBufferSize(String __value) {
            return this.receiveBufferSize(Integer.valueOf(__value));
        }

        public Builder responseCompressionLevel(int __value) {
            this.responseCompressionLevel = __value;
            return this;
        }

        private Builder responseCompressionLevel(String __value) {
            return this.responseCompressionLevel(Integer.valueOf(__value));
        }

        public Builder sendBufferSize(int __value) {
            this.sendBufferSize = __value;
            return this;
        }

        private Builder sendBufferSize(String __value) {
            return this.sendBufferSize(Integer.valueOf(__value));
        }

        public Builder tcpListenBacklogLength(int __value) {
            this.tcpListenBacklogLength = __value;
            return this;
        }

        private Builder tcpListenBacklogLength(String __value) {
            return this.tcpListenBacklogLength(Integer.valueOf(__value));
        }

        public Builder connectTimeout(double __value) {
            this.connectTimeout = __value;
            return this;
        }

        private Builder connectTimeout(String __value) {
            return this.connectTimeout(Double.valueOf(__value));
        }

        public Builder idleConnectionTimeout(double __value) {
            this.idleConnectionTimeout = __value;
            return this;
        }

        private Builder idleConnectionTimeout(String __value) {
            return this.idleConnectionTimeout(Double.valueOf(__value));
        }

        public Builder soLinger(double __value) {
            this.soLinger = __value;
            return this;
        }

        private Builder soLinger(String __value) {
            return this.soLinger(Double.valueOf(__value));
        }

        public Builder perRequestMetricsEnabled(boolean __value) {
            this.perRequestMetricsEnabled = __value;
            return this;
        }

        private Builder perRequestMetricsEnabled(String __value) {
            return this.perRequestMetricsEnabled(Boolean.valueOf(__value));
        }

        public Builder metricUpdateInterval(double __value) {
            this.metricUpdateInterval = __value;
            return this;
        }

        private Builder metricUpdateInterval(String __value) {
            return this.metricUpdateInterval(Double.valueOf(__value));
        }

        public Builder ssl(Ssl.Builder __builder) {
            this.ssl = __builder;
            return this;
        }

        public Builder filter(Filter.Builder __builder) {
            this.filter.add(__builder);
            return this;
        }

        public Builder filter(List<Filter.Builder> __builders) {
            this.filter = __builders;
            return this;
        }

        public Builder accessLog(AccessLog.Builder __builder) {
            this.accessLog = __builder;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return HttpServerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return HttpServerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return HttpServerConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

