/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.osgi;

import com.yahoo.log.LogLevel;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public class JacksonJaxrsResolverHook
implements ResolverHook {
    private static Logger log = Logger.getLogger(JacksonJaxrsResolverHook.class.getName());

    public void filterResolvable(Collection<BundleRevision> bundleRevisions) {
    }

    public void filterSingletonCollisions(BundleCapability bundleCapability, Collection<BundleCapability> bundleCapabilities) {
    }

    public void filterMatches(BundleRequirement bundleRequirement, Collection<BundleCapability> bundleCapabilities) {
        Bundle bundle = bundleRequirement.getRevision().getBundle();
        String symbolicName = bundle.getSymbolicName();
        log.log((Level)LogLevel.DEBUG, "Filtering matches for " + symbolicName);
        if (symbolicName.startsWith("com.fasterxml.jackson.jaxrs")) {
            this.removeBundlesMatching(bundleCapabilities, JacksonJaxrsResolverHook::isJaxRs1Bundle);
        } else if (symbolicName.equals("jackson-jaxrs") && bundle.getVersion().getMajor() == 1) {
            this.removeBundlesMatching(bundleCapabilities, JacksonJaxrsResolverHook::isJaxRs2Bundle);
        }
    }

    private static boolean isJaxRs1Bundle(String bundleSymbolicName) {
        return bundleSymbolicName.startsWith("com.sun.jersey.");
    }

    private static boolean isJaxRs2Bundle(String bundleSymbolicName) {
        return bundleSymbolicName.startsWith("org.glassfish.jersey.") || bundleSymbolicName.equals("javax.ws.rs-api");
    }

    private void removeBundlesMatching(Collection<BundleCapability> bundleCapabilities, Predicate<String> symbolicNamePredicate) {
        Iterator<BundleCapability> i = bundleCapabilities.iterator();
        while (i.hasNext()) {
            BundleCapability bundleCapability = i.next();
            String symbolicName = bundleCapability.getRevision().getSymbolicName();
            if (!symbolicNamePredicate.test(symbolicName)) continue;
            log.log((Level)LogLevel.DEBUG, "- Removing bundle " + symbolicName);
            i.remove();
        }
    }

    public void end() {
    }

    public static class Factory
    implements ResolverHookFactory {
        public ResolverHook begin(Collection<BundleRevision> bundleRevisions) {
            return new JacksonJaxrsResolverHook();
        }
    }
}

