/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.http.filter.FilterChainRepository;
import com.yahoo.jdisc.application.BindingRepository;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilterChain;
import java.util.List;

class FilterUtil {
    private static final ComponentId SEARCH_SERVER_COMPONENT_ID = ComponentId.fromString((String)"SearchServer");
    private final BindingRepository<RequestFilter> requestFilters;
    private final BindingRepository<ResponseFilter> responseFilters;

    private FilterUtil(BindingRepository<RequestFilter> requestFilters, BindingRepository<ResponseFilter> responseFilters) {
        this.requestFilters = requestFilters;
        this.responseFilters = responseFilters;
    }

    private void configureFilters(List<FilterSpec> filtersConfig, FilterChainRepository filterChainRepository) {
        for (FilterSpec filterConfig : filtersConfig) {
            Object filter = filterChainRepository.getFilter(ComponentSpecification.fromString((String)filterConfig.getId()));
            if (filter == null) {
                throw new RuntimeException("No http filter with id " + filterConfig.getId());
            }
            this.addFilter(filter, filterConfig.getBinding());
        }
    }

    private void addFilter(Object filter, String binding) {
        if (filter instanceof RequestFilter && filter instanceof ResponseFilter) {
            throw new RuntimeException("The filter " + filter.getClass().getName() + " is unsupported since it's both a RequestFilter and a ResponseFilter.");
        }
        if (filter instanceof RequestFilter) {
            this.requestFilters.put(new UriPattern(binding), (Object)((RequestFilter)filter));
        } else if (filter instanceof ResponseFilter) {
            this.responseFilters.put(new UriPattern(binding), (Object)((ResponseFilter)filter));
        } else {
            throw new RuntimeException("Unknown filter type " + filter.getClass().getName());
        }
    }

    private void configureLegacyFilters(ComponentId id, ComponentRegistry<SecurityRequestFilter> legacyRequestFilters) {
        ComponentId serverName = id.getNamespace();
        if (SEARCH_SERVER_COMPONENT_ID.equals((Object)serverName) && !legacyRequestFilters.allComponents().isEmpty()) {
            this.requestFilters.bind("http://*/*", (Object)SecurityRequestFilterChain.newInstance((List)legacyRequestFilters.allComponents()));
        }
    }

    public static void setupFilters(ComponentId componentId, ComponentRegistry<SecurityRequestFilter> legacyRequestFilters, List<FilterSpec> filtersConfig, FilterChainRepository filterChainRepository, BindingRepository<RequestFilter> requestFilters, BindingRepository<ResponseFilter> responseFilters) {
        FilterUtil filterUtil = new FilterUtil(requestFilters, responseFilters);
        filterUtil.configureLegacyFilters(componentId, legacyRequestFilters);
        filterUtil.configureFilters(filtersConfig, filterChainRepository);
    }

    public static class FilterSpec {
        private final String id;
        private final String binding;

        public FilterSpec(String id, String binding) {
            this.id = id;
            this.binding = binding;
        }

        public String getId() {
            return this.id;
        }

        public String getBinding() {
            return this.binding;
        }
    }
}

