/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2.response;

import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.ClusterReindexing;
import com.yahoo.vespa.config.server.http.JSONResponse;
import java.util.Map;
import java.util.Set;

public class ReindexingResponse
extends JSONResponse {
    public ReindexingResponse(Map<String, Set<String>> documentTypes, ApplicationReindexing reindexing, Map<String, ClusterReindexing> clusters) {
        super(200);
        this.object.setBool("enabled", reindexing.enabled());
        Cursor clustersObject = this.object.setObject("clusters");
        documentTypes.forEach((cluster, types) -> {
            Cursor clusterObject = clustersObject.setObject(cluster);
            Cursor pendingObject = clusterObject.setObject("pending");
            Cursor readyObject = clusterObject.setObject("ready");
            for (String type : types) {
                Cursor statusObject = readyObject.setObject(type);
                if (reindexing.clusters().containsKey(cluster)) {
                    if (reindexing.clusters().get(cluster).pending().containsKey(type)) {
                        pendingObject.setLong(type, reindexing.clusters().get(cluster).pending().get(type).longValue());
                    }
                    if (reindexing.clusters().get(cluster).ready().containsKey(type)) {
                        ReindexingResponse.setStatus(statusObject, reindexing.clusters().get(cluster).ready().get(type));
                    }
                }
                if (!clusters.containsKey(cluster) || !((ClusterReindexing)clusters.get(cluster)).documentTypeStatus().containsKey(type)) continue;
                ReindexingResponse.setStatus(statusObject, ((ClusterReindexing)clusters.get(cluster)).documentTypeStatus().get(type));
            }
        });
    }

    private static void setStatus(Cursor object, ApplicationReindexing.Status readyStatus) {
        object.setLong("readyMillis", readyStatus.ready().toEpochMilli());
        object.setDouble("speed", readyStatus.speed());
        object.setString("cause", readyStatus.cause());
    }

    private static void setStatus(Cursor object, ClusterReindexing.Status status) {
        object.setLong("startedMillis", status.startedAt().toEpochMilli());
        status.endedAt().ifPresent(endedAt -> object.setLong("endedMillis", endedAt.toEpochMilli()));
        status.state().map(ClusterReindexing.State::asString).ifPresent(state -> object.setString("state", state));
        status.message().ifPresent(message -> object.setString("message", message));
        status.progress().ifPresent(progress -> object.setDouble("progress", progress.doubleValue()));
    }
}

