/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.monitoring;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.net.HostName;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZKMetricUpdater
implements Runnable {
    private static final Logger log = Logger.getLogger(ZKMetricUpdater.class.getName());
    public static final String METRIC_ZK_ZNODES = Metrics.getMetricName("zkZNodes");
    public static final String METRIC_ZK_LATENCY_AVERAGE = Metrics.getMetricName("zkAvgLatency");
    public static final String METRIC_ZK_LATENCY_MAX = Metrics.getMetricName("zkMaxLatency");
    public static final String METRIC_ZK_CONNECTIONS = Metrics.getMetricName("zkConnections");
    public static final String METRIC_ZK_OUTSTANDING_REQUESTS = Metrics.getMetricName("zkOutstandingRequests");
    private static final int CONNECTION_TIMEOUT_MS = 1000;
    private static final int READ_TIMEOUT_MS = 1000;
    private final AtomicReference<Map<String, Long>> zkMetrics = new AtomicReference(new HashMap());
    private final ScheduledExecutorService executorService;
    private final int zkPort;
    private static final Pattern MONITORING_REPORT = Pattern.compile("^(\\w+)\\s+(\\d+)$", 8);

    public ZKMetricUpdater(ZookeeperServerConfig zkServerConfig, long delayMS, long intervalMS) {
        this.zkPort = zkServerConfig.clientPort();
        if (intervalMS <= 0L) {
            throw new IllegalArgumentException("interval must be positive, was " + intervalMS + " ms");
        }
        this.executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("zkmetricupdater"));
        this.executorService.scheduleAtFixedRate(this, delayMS, intervalMS, TimeUnit.MILLISECONDS);
    }

    private void setMetricAttribute(String attribute, long value, Map<String, Long> data) {
        switch (attribute) {
            case "zk_znode_count": {
                data.put(METRIC_ZK_ZNODES, value);
                break;
            }
            case "zk_avg_latency": {
                data.put(METRIC_ZK_LATENCY_AVERAGE, value);
                break;
            }
            case "zk_max_latency": {
                data.put(METRIC_ZK_LATENCY_MAX, value);
                break;
            }
            case "zk_num_alive_connections": {
                data.put(METRIC_ZK_CONNECTIONS, value);
                break;
            }
            case "zk_outstanding_requests": {
                data.put(METRIC_ZK_OUTSTANDING_REQUESTS, value);
            }
        }
    }

    @Override
    public void run() {
        Optional<String> report = this.retrieveReport();
        report.ifPresent(this::parseReport);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> retrieveReport() {
        Optional<String> optional;
        OutputStream out;
        Socket socket;
        block10: {
            socket = null;
            InputStream in = null;
            out = null;
            try {
                socket = ZKMetricUpdater.createSocket();
                socket.setSoTimeout(1000);
                socket.connect(new InetSocketAddress(HostName.getLocalhost(), this.zkPort), 1000);
                in = socket.getInputStream();
                out = socket.getOutputStream();
                out.write("mntr\n".getBytes(StandardCharsets.UTF_8));
                out.flush();
                optional = Optional.of(new String(in.readAllBytes(), StandardCharsets.UTF_8));
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (socket != null && socket.isConnected()) {
                        socket.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warning("Failure in retrieving monitoring data: (" + e.getClass().getSimpleName() + ") " + e.getMessage());
                    log.log(Level.FINE, e, e::toString);
                    return Optional.empty();
                }
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
        if (socket != null && socket.isConnected()) {
            socket.close();
        }
        return optional;
    }

    private static Socket createSocket() throws IOException {
        TlsContext tlsContext = TransportSecurityUtils.getSystemTlsContext().orElse(null);
        if (tlsContext == null || TransportSecurityUtils.getInsecureMixedMode() == MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
            return new Socket();
        }
        return tlsContext.createClientSslSocket();
    }

    private void parseReport(String report) {
        Matcher matcher = MONITORING_REPORT.matcher(report);
        HashMap<String, Long> data = new HashMap<String, Long>();
        while (matcher.find()) {
            String attribute = matcher.group(1);
            long value = Long.parseLong(matcher.group(2));
            this.setMetricAttribute(attribute, value, data);
        }
        this.zkMetrics.set(data);
    }

    public Map<String, Long> getZKMetrics() {
        return this.zkMetrics.get();
    }
}

