/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class InheritableApplications {
    private final Map<String, FilesApplicationPackage> applications;

    private InheritableApplications(Map<String, FilesApplicationPackage> applications) {
        this.applications = applications;
    }

    public Map<String, FilesApplicationPackage> toMap() {
        return Collections.unmodifiableMap(this.applications);
    }

    public static InheritableApplications empty() {
        return new InheritableApplications(Map.of());
    }

    public static class DirectoryImporter {
        private static final Logger log = Logger.getLogger(DirectoryImporter.class.getName());

        public InheritableApplications importFrom(String dir) {
            return this.importFrom(new File(dir));
        }

        public InheritableApplications importFrom(File dir) {
            if (!dir.exists() || !dir.isDirectory()) {
                log.warning("Inherited application directory '" + dir.getAbsolutePath() + "' does not exist: No applications can be inherited");
                return InheritableApplications.empty();
            }
            HashMap<String, FilesApplicationPackage> inheritable = new HashMap<String, FilesApplicationPackage>();
            for (File namespaceDir : dir.listFiles()) {
                if (!namespaceDir.isDirectory()) continue;
                inheritable.putAll(this.importNamespaceFrom(namespaceDir));
            }
            return new InheritableApplications(inheritable);
        }

        private Map<String, FilesApplicationPackage> importNamespaceFrom(File namespaceDir) {
            HashMap<String, FilesApplicationPackage> inheritable = new HashMap<String, FilesApplicationPackage>();
            for (File applicationDir : namespaceDir.listFiles()) {
                if (!applicationDir.isDirectory()) continue;
                inheritable.put(namespaceDir.getName() + "." + applicationDir.getName(), this.importApplicationFrom(applicationDir));
            }
            return inheritable;
        }

        private FilesApplicationPackage importApplicationFrom(File applicationDir) {
            return FilesApplicationPackage.fromDir((File)applicationDir, Map.of());
        }
    }
}

