/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.component.Version;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public final class ApplicationVersions {
    private final Version latestVersion;
    private final ApplicationId applicationId;
    private final long generation;
    private final HashMap<Version, Application> applications = new HashMap();

    private ApplicationVersions(List<Application> applications) {
        if (applications.isEmpty()) {
            throw new IllegalArgumentException("application list cannot be empty");
        }
        if (applications.stream().map(Application::getId).distinct().count() > 1L) {
            throw new IllegalArgumentException("All application ids must be equal");
        }
        if (applications.stream().map(Application::getApplicationGeneration).distinct().count() > 1L) {
            throw new IllegalArgumentException("All config generations must be equal");
        }
        Application firstApp = applications.get(0);
        this.applicationId = firstApp.getId();
        this.generation = firstApp.getApplicationGeneration();
        applications.forEach(application -> this.applications.put(application.getVespaVersion(), (Application)application));
        this.latestVersion = (Version)this.applications.keySet().stream().max(Version::compareTo).get();
    }

    public static ApplicationVersions fromList(List<Application> applications) {
        return new ApplicationVersions(applications);
    }

    public static ApplicationVersions from(Application application) {
        return ApplicationVersions.fromList(List.of(application));
    }

    public Application getForVersionOrLatest(Optional<Version> optionalVersion, Instant now) {
        Version version = optionalVersion.orElse(this.latestVersion);
        return this.resolveForVersion(version, now).orElseThrow(() -> new VersionDoesNotExistException(String.valueOf(this.applicationId) + " has no model for Vespa version " + String.valueOf(version)));
    }

    private Optional<Application> resolveForVersion(Version vespaVersion, Instant now) {
        Application application = this.applications.get(vespaVersion);
        if (application != null) {
            return Optional.of(application);
        }
        Application latest = this.applications.get(this.latestVersion);
        if (latest.getModel().allowModelVersionMismatch(now)) {
            return Optional.of(latest);
        }
        return Optional.empty();
    }

    public Optional<Application> get(Version version) {
        return Optional.ofNullable(this.applications.get(version));
    }

    public ApplicationId getId() {
        return this.applicationId;
    }

    public Collection<String> allHosts() {
        return this.applications.values().stream().flatMap(app -> app.getModel().getHosts().stream().map(HostInfo::getHostname)).distinct().toList();
    }

    public void updateHostMetrics() {
        this.applications.values().forEach(app -> app.updateHostMetrics(app.getModel().getHosts().size()));
    }

    public long applicationGeneration() {
        return this.generation;
    }

    public List<Application> applications() {
        return new ArrayList<Application>(this.applications.values());
    }

    public List<Version> versions() {
        return this.applications.values().stream().map(Application::getVespaVersion).sorted().toList();
    }
}

