/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.SuperModel;
import com.yahoo.config.model.api.SuperModelListener;
import com.yahoo.config.model.api.SuperModelProvider;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.GenerationCounter;
import com.yahoo.vespa.config.server.application.ApplicationVersions;
import com.yahoo.vespa.config.server.model.SuperModelConfigProvider;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SuperModelManager
implements SuperModelProvider {
    private static final Logger logger = Logger.getLogger(SuperModelManager.class.getName());
    private final Zone zone;
    private final Object monitor = new Object();
    private final FlagSource flagSource;
    private SuperModelConfigProvider superModelConfigProvider;
    private final List<SuperModelListener> listeners = new ArrayList<SuperModelListener>();
    private long generation;
    private final long masterGeneration;
    private final GenerationCounter generationCounter;
    private final Optional<Set<ApplicationId>> bootstrapApplicationSet = Optional.empty();

    @Inject
    public SuperModelManager(ConfigserverConfig configserverConfig, Zone zone, GenerationCounter generationCounter, FlagSource flagSource) {
        this.flagSource = flagSource;
        this.zone = zone;
        this.generationCounter = generationCounter;
        this.masterGeneration = configserverConfig.masterGeneration();
        this.makeNewSuperModelConfigProvider(new SuperModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuperModel getSuperModel() {
        Object object = this.monitor;
        synchronized (object) {
            return this.superModelConfigProvider.getSuperModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuperModelConfigProvider getSuperModelConfigProvider() {
        Object object = this.monitor;
        synchronized (object) {
            return this.superModelConfigProvider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGeneration() {
        Object object = this.monitor;
        synchronized (object) {
            return this.generation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(SuperModelListener listener) {
        Object object = this.monitor;
        synchronized (object) {
            this.listeners.add(listener);
            SuperModel superModel = this.superModelConfigProvider.getSuperModel();
            superModel.getAllApplicationInfos().forEach(application -> listener.applicationActivated(superModel, application));
            if (superModel.isComplete()) {
                listener.notifyOfCompleteness(superModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configActivated(ApplicationVersions applicationVersions) {
        Object object = this.monitor;
        synchronized (object) {
            ApplicationInfo applicationInfo = applicationVersions.getForVersionOrLatest(Optional.empty(), Instant.now()).toApplicationInfo();
            SuperModel newSuperModel = this.superModelConfigProvider.getSuperModel().cloneAndSetApplication(applicationInfo);
            this.generationCounter.increment();
            this.makeNewSuperModelConfigProvider(newSuperModel);
            this.listeners.forEach(listener -> listener.applicationActivated(newSuperModel, applicationInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applicationRemoved(ApplicationId applicationId) {
        Object object = this.monitor;
        synchronized (object) {
            this.bootstrapApplicationSet.ifPresent(set -> set.remove(applicationId));
            SuperModel newSuperModel = this.superModelConfigProvider.getSuperModel().cloneAndRemoveApplication(applicationId);
            this.generationCounter.increment();
            this.makeNewSuperModelConfigProvider(newSuperModel);
            this.listeners.forEach(listener -> listener.applicationRemoved(newSuperModel, applicationId));
        }
    }

    public void markAsComplete() {
        logger.log(Level.FINE, "Super model is complete");
        SuperModel newSuperModel = this.getSuperModel().cloneAsComplete();
        this.superModelConfigProvider = new SuperModelConfigProvider(newSuperModel, this.zone, this.flagSource);
        this.listeners.forEach(listener -> listener.notifyOfCompleteness(newSuperModel));
    }

    private void makeNewSuperModelConfigProvider(SuperModel newSuperModel) {
        this.generation = this.masterGeneration + this.generationCounter.get();
        this.superModelConfigProvider = new SuperModelConfigProvider(newSuperModel, this.zone, this.flagSource);
    }
}

