/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.v2.response.ProtonMetricsResponse;
import com.yahoo.vespa.config.server.metrics.ClusterProtonMetricsRetriever;
import com.yahoo.vespa.config.server.metrics.ProtonMetricsAggregator;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class ProtonMetricsRetriever {
    private final ClusterProtonMetricsRetriever metricsRetriever;

    public ProtonMetricsRetriever() {
        this(new ClusterProtonMetricsRetriever());
    }

    public ProtonMetricsRetriever(ClusterProtonMetricsRetriever metricsRetriever) {
        this.metricsRetriever = metricsRetriever;
    }

    public ProtonMetricsResponse getMetrics(Application application) {
        Collection<URI> hosts = ProtonMetricsRetriever.getHostsOfApplication(application);
        Map<String, ProtonMetricsAggregator> clusterMetrics = this.metricsRetriever.requestMetricsGroupedByCluster(hosts);
        return new ProtonMetricsResponse(application.getId(), clusterMetrics);
    }

    private static Collection<URI> getHostsOfApplication(Application application) {
        return application.getModel().getHosts().stream().filter(host -> host.getServices().stream().anyMatch(ProtonMetricsRetriever.isSearchNode())).map(HostInfo::getHostname).map(ProtonMetricsRetriever::createMetricsProxyURI).toList();
    }

    private static Predicate<ServiceInfo> isSearchNode() {
        return serviceInfo -> serviceInfo.getServiceType().equalsIgnoreCase("searchnode");
    }

    private static URI createMetricsProxyURI(String hostname) {
        return URI.create("http://" + hostname + ":19092/metrics/v2/values");
    }
}

