/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.net.HostName;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FileDistributionUtil {
    public static Set<String> getFileReferencesOnDisk(File directory) {
        HashSet<String> fileReferencesOnDisk = new HashSet<String>();
        File[] filesOnDisk = directory.listFiles();
        if (filesOnDisk != null) {
            fileReferencesOnDisk.addAll(Arrays.stream(filesOnDisk).map(File::getName).collect(Collectors.toSet()));
        }
        return fileReferencesOnDisk;
    }

    public static List<String> getOtherConfigServersInCluster(ConfigserverConfig configserverConfig) {
        return ConfigServerSpec.fromConfig(configserverConfig).stream().filter(spec -> !spec.getHostName().equals(HostName.getLocalhost())).map(spec -> "tcp/" + spec.getHostName() + ":" + spec.getConfigServerPort()).collect(Collectors.toList());
    }

    public static boolean fileReferenceExistsOnDisk(File downloadDirectory, FileReference applicationPackageReference) {
        return FileDistributionUtil.getFileReferencesOnDisk(downloadDirectory).contains(applicationPackageReference.value());
    }
}

