/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.status;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;

public class StatusHandler
extends HttpHandler {
    private final ModelFactoryRegistry modelFactoryRegistry;
    private final ConfigserverConfig configserverConfig;

    @Inject
    public StatusHandler(ThreadedHttpRequestHandler.Context ctx, ModelFactoryRegistry modelFactoryRegistry, ConfigserverConfig configserverConfig) {
        super(ctx);
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.configserverConfig = configserverConfig;
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        return new StatusResponse(200, this.modelFactoryRegistry, this.configserverConfig);
    }

    private static class StatusResponse
    extends JSONResponse {
        StatusResponse(int status, ModelFactoryRegistry modelFactoryRegistry, ConfigserverConfig configserverConfig) {
            super(status);
            Cursor configCursor = this.object.setObject("configserverConfig");
            SlimeUtils.copyObject((Inspector)ConfigPayload.fromInstance((ConfigInstance)configserverConfig).getSlime().get(), (Cursor)configCursor);
            Cursor modelVersionsCursor = this.object.setArray("modelVersions");
            modelFactoryRegistry.getFactories().stream().map(ModelFactory::version).map(Version::toFullString).forEach(arg_0 -> ((Cursor)modelVersionsCursor).addString(arg_0));
        }
    }
}

