/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.model;

import com.google.common.base.Joiner;
import com.yahoo.cloud.config.LbServicesConfig;
import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import com.yahoo.config.model.api.ApplicationClusterInfo;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LbServicesProducer
implements LbServicesConfig.Producer {
    private final Map<TenantName, Set<ApplicationInfo>> models;
    private final Zone zone;
    private final BooleanFlag generateNonMtlsEndpoint;

    public LbServicesProducer(Map<TenantName, Set<ApplicationInfo>> models, Zone zone, FlagSource flagSource) {
        this.models = models;
        this.zone = zone;
        this.generateNonMtlsEndpoint = (BooleanFlag)Flags.GENERATE_NON_MTLS_ENDPOINT.bindTo(flagSource);
    }

    public void getConfig(LbServicesConfig.Builder builder) {
        this.models.keySet().stream().sorted().forEach(tenant -> builder.tenants(tenant.value(), this.getTenantConfig(this.models.get(tenant))));
    }

    private LbServicesConfig.Tenants.Builder getTenantConfig(Set<ApplicationInfo> apps) {
        LbServicesConfig.Tenants.Builder tb = new LbServicesConfig.Tenants.Builder();
        apps.stream().sorted(Comparator.comparing(ApplicationInfo::getApplicationId)).filter(applicationInfo -> this.generateRoutingConfig(applicationInfo.getApplicationId())).forEach(applicationInfo -> tb.applications(this.createLbAppIdKey(applicationInfo.getApplicationId()), this.getAppConfig((ApplicationInfo)applicationInfo)));
        return tb;
    }

    private boolean generateRoutingConfig(ApplicationId applicationId) {
        return !applicationId.instance().isTester();
    }

    private String createLbAppIdKey(ApplicationId applicationId) {
        return applicationId.application().value() + ":" + this.zone.environment().value() + ":" + this.zone.region().value() + ":" + applicationId.instance().value();
    }

    private LbServicesConfig.Tenants.Applications.Builder getAppConfig(ApplicationInfo app) {
        LbServicesConfig.Tenants.Applications.Builder ab = new LbServicesConfig.Tenants.Applications.Builder();
        ab.activeRotation(this.getActiveRotation(app));
        ab.usePowerOfTwoChoicesLb(true);
        ab.generateNonMtlsEndpoint(this.generateNonMtlsEndpoint(app));
        app.getModel().getHosts().stream().sorted((a, b) -> a.getHostname().compareTo(b.getHostname())).forEach(hostInfo -> ab.hosts(hostInfo.getHostname(), this.getHostsConfig((HostInfo)hostInfo)));
        Set applicationClusterInfos = app.getModel().applicationClusterInfo();
        List endpointBuilder = applicationClusterInfos.stream().map(ApplicationClusterInfo::endpoints).flatMap(endpoints -> this.getEndpointConfig((List<ApplicationClusterEndpoint>)endpoints).stream()).collect(Collectors.toList());
        ab.endpoints(endpointBuilder);
        return ab;
    }

    private List<LbServicesConfig.Tenants.Applications.Endpoints.Builder> getEndpointConfig(List<ApplicationClusterEndpoint> clusterEndpoints) {
        return clusterEndpoints.stream().map(this::getEndpointConfig).collect(Collectors.toList());
    }

    private LbServicesConfig.Tenants.Applications.Endpoints.Builder getEndpointConfig(ApplicationClusterEndpoint clusterEndpoints) {
        LbServicesConfig.Tenants.Applications.Endpoints.Builder builder = new LbServicesConfig.Tenants.Applications.Endpoints.Builder();
        return builder.dnsName(clusterEndpoints.dnsName().value()).scope(LbServicesConfig.Tenants.Applications.Endpoints.Scope.Enum.valueOf((String)clusterEndpoints.scope().name())).routingMethod(LbServicesConfig.Tenants.Applications.Endpoints.RoutingMethod.Enum.valueOf((String)clusterEndpoints.routingMethod().name())).weight(clusterEndpoints.weight()).hosts((Collection)clusterEndpoints.hostNames()).clusterId(clusterEndpoints.clusterId());
    }

    private boolean getActiveRotation(ApplicationInfo app) {
        boolean activeRotation = false;
        for (HostInfo hostInfo : app.getModel().getHosts()) {
            Optional<ServiceInfo> container = hostInfo.getServices().stream().filter(serviceInfo -> serviceInfo.getServiceType().equals(ContainerServiceType.CONTAINER.serviceName) || serviceInfo.getServiceType().equals(ContainerServiceType.QRSERVER.serviceName)).findAny();
            if (!container.isPresent()) continue;
            activeRotation |= Boolean.parseBoolean(container.get().getProperty("activeRotation").orElse("false"));
        }
        return activeRotation;
    }

    private boolean generateNonMtlsEndpoint(ApplicationInfo app) {
        return ((BooleanFlag)this.generateNonMtlsEndpoint.with(FetchVector.Dimension.APPLICATION_ID, app.getApplicationId().serializedForm())).value();
    }

    private LbServicesConfig.Tenants.Applications.Hosts.Builder getHostsConfig(HostInfo hostInfo) {
        LbServicesConfig.Tenants.Applications.Hosts.Builder hb = new LbServicesConfig.Tenants.Applications.Hosts.Builder();
        hb.hostname(hostInfo.getHostname());
        hostInfo.getServices().forEach(serviceInfo -> hb.services(serviceInfo.getServiceName(), this.getServiceConfig((ServiceInfo)serviceInfo)));
        return hb;
    }

    private LbServicesConfig.Tenants.Applications.Hosts.Services.Builder getServiceConfig(ServiceInfo serviceInfo) {
        List endpointAliases = Stream.of(serviceInfo.getProperty("endpointaliases").orElse("").split(",")).filter(prop -> !"".equals(prop)).collect(Collectors.toList());
        endpointAliases.addAll(Stream.of(serviceInfo.getProperty("rotations").orElse("").split(",")).filter(prop -> !"".equals(prop)).collect(Collectors.toList()));
        Collections.sort(endpointAliases);
        LbServicesConfig.Tenants.Applications.Hosts.Services.Builder sb = new LbServicesConfig.Tenants.Applications.Hosts.Services.Builder().type(serviceInfo.getServiceType()).clustertype(serviceInfo.getProperty("clustertype").orElse("")).clustername(serviceInfo.getProperty("clustername").orElse("")).configId(serviceInfo.getConfigId()).servicealiases((Collection)Stream.of(serviceInfo.getProperty("servicealiases").orElse("").split(",")).filter(prop -> !"".equals(prop)).sorted((a, b) -> a.compareTo((String)b)).collect(Collectors.toList())).endpointaliases(endpointAliases).index(Integer.parseInt(serviceInfo.getProperty("index").orElse("999999")));
        serviceInfo.getPorts().forEach(portInfo -> {
            LbServicesConfig.Tenants.Applications.Hosts.Services.Ports.Builder pb = new LbServicesConfig.Tenants.Applications.Hosts.Services.Ports.Builder().number(portInfo.getPort()).tags(Joiner.on((String)" ").join((Iterable)portInfo.getTags()));
            sb.ports(pb);
        });
        return sb;
    }
}

