/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.CertificateNotReadyException;
import com.yahoo.config.provision.OutOfCapacityException;
import com.yahoo.config.provision.ParentHostUnavailableException;
import com.yahoo.config.provision.exception.ActivationConflictException;
import com.yahoo.config.provision.exception.LoadBalancerServiceException;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.http.RequestTimeoutException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.yolean.Exceptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.logging.Level;

public class HttpHandler
extends LoggingRequestHandler {
    public HttpHandler(LoggingRequestHandler.Context ctx) {
        super(ctx);
    }

    public HttpResponse handle(HttpRequest request) {
        this.log.log(Level.FINE, () -> request.getMethod() + " " + request.getUri().toString());
        try {
            switch (request.getMethod()) {
                case POST: {
                    return this.handlePOST(request);
                }
                case GET: {
                    return this.handleGET(request);
                }
                case PUT: {
                    return this.handlePUT(request);
                }
                case DELETE: {
                    return this.handleDELETE(request);
                }
            }
            return this.createErrorResponse(request.getMethod());
        }
        catch (NotFoundException | com.yahoo.vespa.config.server.http.NotFoundException e) {
            return HttpErrorResponse.notFoundError(this.getMessage(e, request));
        }
        catch (ActivationConflictException e) {
            return HttpErrorResponse.conflictWhenActivating(this.getMessage((Exception)((Object)e), request));
        }
        catch (InvalidApplicationException e) {
            return HttpErrorResponse.invalidApplicationPackage(this.getMessage(e, request));
        }
        catch (IllegalArgumentException e) {
            return HttpErrorResponse.badRequest(this.getMessage(e, request));
        }
        catch (OutOfCapacityException e) {
            return HttpErrorResponse.outOfCapacity(this.getMessage((Exception)((Object)e), request));
        }
        catch (InternalServerException e) {
            return HttpErrorResponse.internalServerError(this.getMessage(e, request));
        }
        catch (UnknownVespaVersionException e) {
            return HttpErrorResponse.unknownVespaVersion(this.getMessage(e, request));
        }
        catch (RequestTimeoutException e) {
            return HttpErrorResponse.requestTimeout(this.getMessage(e, request));
        }
        catch (ApplicationLockException e) {
            return HttpErrorResponse.applicationLockFailure(this.getMessage((Exception)((Object)e), request));
        }
        catch (ParentHostUnavailableException e) {
            return HttpErrorResponse.parentHostNotReady(this.getMessage((Exception)((Object)e), request));
        }
        catch (CertificateNotReadyException e) {
            return HttpErrorResponse.certificateNotReady(this.getMessage((Exception)((Object)e), request));
        }
        catch (LoadBalancerServiceException e) {
            return HttpErrorResponse.loadBalancerNotReady(this.getMessage((Exception)((Object)e), request));
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unexpected exception handling a config server request", e);
            return HttpErrorResponse.internalServerError(this.getMessage(e, request));
        }
    }

    protected static Duration getRequestTimeout(HttpRequest request, Duration defaultTimeout) {
        if (!request.hasProperty("timeout")) {
            return defaultTimeout;
        }
        try {
            return Duration.ofMillis((long)(Double.parseDouble(request.getProperty("timeout")) * 1000.0));
        }
        catch (Exception e) {
            return defaultTimeout;
        }
    }

    private String getMessage(Exception e, HttpRequest request) {
        if (request.getBooleanProperty("debug")) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        return Exceptions.toMessageString((Throwable)e);
    }

    protected HttpResponse handleGET(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handlePOST(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handlePUT(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    protected HttpResponse handleDELETE(HttpRequest request) {
        return this.createErrorResponse(request.getMethod());
    }

    private HttpResponse createErrorResponse(HttpRequest.Method method) {
        return HttpErrorResponse.methodNotAllowed("Method '" + method + "' is not supported");
    }
}

