/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.curator.Curator;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.recipes.cache.ChildData;

public class SessionStateWatcher {
    private static final Logger log = Logger.getLogger(SessionStateWatcher.class.getName());
    private final Curator.FileCache fileCache;
    private final TenantApplications tenantApplications;
    private final RemoteSession remoteSession;
    private final MetricUpdater metrics;
    private final Executor zkWatcherExecutor;
    private final SessionRepository sessionRepository;
    private Optional<LocalSession> localSession;

    SessionStateWatcher(Curator.FileCache fileCache, TenantApplications tenantApplications, RemoteSession remoteSession, Optional<LocalSession> localSession, MetricUpdater metrics, Executor zkWatcherExecutor, SessionRepository sessionRepository) {
        this.fileCache = fileCache;
        this.tenantApplications = tenantApplications;
        this.remoteSession = remoteSession;
        this.localSession = localSession;
        this.metrics = metrics;
        this.fileCache.addListener(this::nodeChanged);
        this.fileCache.start();
        this.zkWatcherExecutor = zkWatcherExecutor;
        this.sessionRepository = sessionRepository;
    }

    private void sessionStatusChanged(Session.Status newStatus) {
        long sessionId = this.remoteSession.getSessionId();
        if (newStatus.equals((Object)Session.Status.PREPARE)) {
            this.createLocalSession(sessionId);
            log.log(Level.FINE, this.remoteSession.logPre() + "Loading prepared session: " + sessionId);
            this.remoteSession.loadPrepared();
        } else if (newStatus.equals((Object)Session.Status.ACTIVATE)) {
            this.createLocalSession(sessionId);
            this.remoteSession.makeActive(this.tenantApplications);
        } else if (newStatus.equals((Object)Session.Status.DEACTIVATE)) {
            this.remoteSession.deactivate();
        } else if (newStatus.equals((Object)Session.Status.DELETE)) {
            this.remoteSession.deactivate();
            this.localSession.ifPresent(session -> {
                log.log(Level.FINE, session.logPre() + "Deleting session " + sessionId);
                this.sessionRepository.deleteLocalSession((LocalSession)session);
            });
        }
    }

    private void createLocalSession(long sessionId) {
        if (this.sessionRepository.distributeApplicationPackage() && this.localSession.isEmpty()) {
            this.localSession = this.sessionRepository.createLocalSessionUsingDistributedApplicationPackage(sessionId);
        }
    }

    public long getSessionId() {
        return this.remoteSession.getSessionId();
    }

    public void close() {
        try {
            this.fileCache.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when closing watcher", e);
        }
    }

    private void nodeChanged() {
        this.zkWatcherExecutor.execute(() -> {
            Session.Status newStatus = Session.Status.NONE;
            try {
                ChildData node = this.fileCache.getCurrentData();
                if (node != null) {
                    newStatus = Session.Status.parse(Utf8.toString((byte[])node.getData()));
                    log.log(Level.FINE, this.remoteSession.logPre() + "Session change: Session " + this.remoteSession.getSessionId() + " changed status to " + newStatus.name());
                    this.sessionStatusChanged(newStatus);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, this.remoteSession.logPre() + "Error handling session change to " + newStatus.name() + " for session " + this.getSessionId(), e);
                this.metrics.incSessionChangeErrors();
            }
        });
    }

    void addLocalSession(LocalSession session) {
        this.localSession = Optional.of(session);
    }
}

