/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.concurrent.maintenance.JobControl;
import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.concurrent.maintenance.StringSetSerializer;
import com.yahoo.path.Path;
import com.yahoo.transaction.Mutex;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ConfigServerMaintainer
extends Maintainer {
    protected final ApplicationRepository applicationRepository;

    ConfigServerMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration initialDelay, Duration interval) {
        super(null, interval, initialDelay, new JobControl((JobControl.Db)new JobControlDb(curator)));
        this.applicationRepository = applicationRepository;
    }

    private static class JobControlDb
    implements JobControl.Db {
        private static final Logger log = Logger.getLogger(JobControlDb.class.getName());
        private static final Path root = Path.fromString((String)"/configserver/v1/");
        private static final Path lockRoot = root.append("locks");
        private static final Path inactiveJobsPath = root.append("inactiveJobs");
        private final Curator curator;
        private final StringSetSerializer serializer = new StringSetSerializer();

        public JobControlDb(Curator curator) {
            this.curator = curator;
        }

        public Set<String> readInactiveJobs() {
            try {
                return this.curator.getData(inactiveJobsPath).filter(data -> ((byte[])data).length > 0).map(arg_0 -> ((StringSetSerializer)this.serializer).fromJson(arg_0)).orElseGet(HashSet::new);
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, "Error reading inactive jobs, deleting inactive state");
                this.writeInactiveJobs(Set.of());
                return new HashSet<String>();
            }
        }

        public void writeInactiveJobs(Set<String> inactiveJobs) {
            this.curator.set(inactiveJobsPath, this.serializer.toJson(inactiveJobs));
        }

        public Mutex lockInactiveJobs() {
            return this.curator.lock(lockRoot.append("inactiveJobsLock"), Duration.ofSeconds(1L));
        }

        public Mutex lockMaintenanceJob(String job) {
            return this.curator.lock(lockRoot.append(job), Duration.ofSeconds(1L));
        }
    }
}

