/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.configserver.flags.http;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.configserver.flags.http.SlimeJsonResponse;

public class ErrorResponse
extends SlimeJsonResponse {
    public ErrorResponse(int statusCode, String errorType, String message) {
        super(statusCode, ErrorResponse.asSlimeMessage(errorType, message));
    }

    private static Slime asSlimeMessage(String errorType, String message) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        root.setString("error-code", errorType);
        root.setString("message", message);
        return slime;
    }

    public static ErrorResponse notFoundError(String message) {
        return new ErrorResponse(404, errorCodes.NOT_FOUND.name(), message);
    }

    public static ErrorResponse internalServerError(String message) {
        return new ErrorResponse(500, errorCodes.INTERNAL_SERVER_ERROR.name(), message);
    }

    public static ErrorResponse badRequest(String message) {
        return new ErrorResponse(400, errorCodes.BAD_REQUEST.name(), message);
    }

    public static ErrorResponse forbidden(String message) {
        return new ErrorResponse(403, errorCodes.FORBIDDEN.name(), message);
    }

    public static ErrorResponse unauthorized(String message) {
        return new ErrorResponse(401, errorCodes.UNAUTHORIZED.name(), message);
    }

    public static ErrorResponse methodNotAllowed(String message) {
        return new ErrorResponse(405, errorCodes.METHOD_NOT_ALLOWED.name(), message);
    }

    public static enum errorCodes {
        NOT_FOUND,
        BAD_REQUEST,
        FORBIDDEN,
        METHOD_NOT_ALLOWED,
        INTERNAL_SERVER_ERROR,
        UNAUTHORIZED;

    }
}

