/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.embedding.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GgufEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "d2d71ba8236be9b2dfafe4b0959e8ada";
    public static final String CONFIG_DEF_NAME = "gguf-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.embedding.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.embedding.config", "embeddingModel model", "gpuLayers int default=0", "poolingType enum {UNSPECIFIED, NONE, MEAN, CLS, LAST, RANK} default=UNSPECIFIED", "physicalMaxBatchSize int default=-1", "logicalMaxBatchSize int default=-1", "continuousBatching bool default=false", "contextSize int default=0", "maxPromptTokens int default=0", "seed int default = -1", "parallel int default=1", "threads double default=0", "batchThreads double default=0"};
    private final ModelNode embeddingModel;
    private final IntegerNode gpuLayers;
    private final PoolingType poolingType;
    private final IntegerNode physicalMaxBatchSize;
    private final IntegerNode logicalMaxBatchSize;
    private final BooleanNode continuousBatching;
    private final IntegerNode contextSize;
    private final IntegerNode maxPromptTokens;
    private final IntegerNode seed;
    private final IntegerNode parallel;
    private final DoubleNode threads;
    private final DoubleNode batchThreads;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public GgufEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private GgufEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for gguf-embedder must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.embeddingModel = builder.embeddingModel == null ? new ModelNode() : new ModelNode(builder.embeddingModel);
        this.gpuLayers = builder.gpuLayers == null ? new IntegerNode(0) : new IntegerNode(builder.gpuLayers.intValue());
        this.poolingType = builder.poolingType == null ? new PoolingType(PoolingType.UNSPECIFIED) : new PoolingType(builder.poolingType);
        this.physicalMaxBatchSize = builder.physicalMaxBatchSize == null ? new IntegerNode(-1) : new IntegerNode(builder.physicalMaxBatchSize.intValue());
        this.logicalMaxBatchSize = builder.logicalMaxBatchSize == null ? new IntegerNode(-1) : new IntegerNode(builder.logicalMaxBatchSize.intValue());
        this.continuousBatching = builder.continuousBatching == null ? new BooleanNode(false) : new BooleanNode(builder.continuousBatching.booleanValue());
        this.contextSize = builder.contextSize == null ? new IntegerNode(0) : new IntegerNode(builder.contextSize.intValue());
        this.maxPromptTokens = builder.maxPromptTokens == null ? new IntegerNode(0) : new IntegerNode(builder.maxPromptTokens.intValue());
        this.seed = builder.seed == null ? new IntegerNode(-1) : new IntegerNode(builder.seed.intValue());
        this.parallel = builder.parallel == null ? new IntegerNode(1) : new IntegerNode(builder.parallel.intValue());
        this.threads = builder.threads == null ? new DoubleNode(0.0) : new DoubleNode(builder.threads.doubleValue());
        this.batchThreads = builder.batchThreads == null ? new DoubleNode(0.0) : new DoubleNode(builder.batchThreads.doubleValue());
    }

    public Path embeddingModel() {
        return (Path)this.embeddingModel.value();
    }

    public ModelReference embeddingModelReference() {
        return this.embeddingModel.getModelReference();
    }

    public int gpuLayers() {
        return this.gpuLayers.value();
    }

    public PoolingType.Enum poolingType() {
        return (PoolingType.Enum)((Object)this.poolingType.value());
    }

    public int physicalMaxBatchSize() {
        return this.physicalMaxBatchSize.value();
    }

    public int logicalMaxBatchSize() {
        return this.logicalMaxBatchSize.value();
    }

    public boolean continuousBatching() {
        return this.continuousBatching.value();
    }

    public int contextSize() {
        return this.contextSize.value();
    }

    public int maxPromptTokens() {
        return this.maxPromptTokens.value();
    }

    public int seed() {
        return this.seed.value();
    }

    public int parallel() {
        return this.parallel.value();
    }

    public double threads() {
        return this.threads.value();
    }

    public double batchThreads() {
        return this.batchThreads.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(GgufEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("embeddingModel"));
        private ModelReference embeddingModel = null;
        private Integer gpuLayers = null;
        private PoolingType.Enum poolingType = null;
        private Integer physicalMaxBatchSize = null;
        private Integer logicalMaxBatchSize = null;
        private Boolean continuousBatching = null;
        private Integer contextSize = null;
        private Integer maxPromptTokens = null;
        private Integer seed = null;
        private Integer parallel = null;
        private Double threads = null;
        private Double batchThreads = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(GgufEmbedderConfig config) {
            this.embeddingModel(config.embeddingModel.getModelReference());
            this.gpuLayers(config.gpuLayers());
            this.poolingType(config.poolingType());
            this.physicalMaxBatchSize(config.physicalMaxBatchSize());
            this.logicalMaxBatchSize(config.logicalMaxBatchSize());
            this.continuousBatching(config.continuousBatching());
            this.contextSize(config.contextSize());
            this.maxPromptTokens(config.maxPromptTokens());
            this.seed(config.seed());
            this.parallel(config.parallel());
            this.threads(config.threads());
            this.batchThreads(config.batchThreads());
        }

        private Builder override(Builder __superior) {
            if (__superior.embeddingModel != null) {
                this.embeddingModel(__superior.embeddingModel);
            }
            if (__superior.gpuLayers != null) {
                this.gpuLayers(__superior.gpuLayers);
            }
            if (__superior.poolingType != null) {
                this.poolingType(__superior.poolingType);
            }
            if (__superior.physicalMaxBatchSize != null) {
                this.physicalMaxBatchSize(__superior.physicalMaxBatchSize);
            }
            if (__superior.logicalMaxBatchSize != null) {
                this.logicalMaxBatchSize(__superior.logicalMaxBatchSize);
            }
            if (__superior.continuousBatching != null) {
                this.continuousBatching(__superior.continuousBatching);
            }
            if (__superior.contextSize != null) {
                this.contextSize(__superior.contextSize);
            }
            if (__superior.maxPromptTokens != null) {
                this.maxPromptTokens(__superior.maxPromptTokens);
            }
            if (__superior.seed != null) {
                this.seed(__superior.seed);
            }
            if (__superior.parallel != null) {
                this.parallel(__superior.parallel);
            }
            if (__superior.threads != null) {
                this.threads(__superior.threads);
            }
            if (__superior.batchThreads != null) {
                this.batchThreads(__superior.batchThreads);
            }
            return this;
        }

        public Builder embeddingModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.embeddingModel = __value;
            this.__uninitialized.remove("embeddingModel");
            return this;
        }

        public Builder gpuLayers(int __value) {
            this.gpuLayers = __value;
            return this;
        }

        private Builder gpuLayers(String __value) {
            return this.gpuLayers(Integer.valueOf(__value));
        }

        public Builder poolingType(PoolingType.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.poolingType = __value;
            return this;
        }

        private Builder poolingType(String __value) {
            return this.poolingType(PoolingType.Enum.valueOf(__value));
        }

        public Builder physicalMaxBatchSize(int __value) {
            this.physicalMaxBatchSize = __value;
            return this;
        }

        private Builder physicalMaxBatchSize(String __value) {
            return this.physicalMaxBatchSize(Integer.valueOf(__value));
        }

        public Builder logicalMaxBatchSize(int __value) {
            this.logicalMaxBatchSize = __value;
            return this;
        }

        private Builder logicalMaxBatchSize(String __value) {
            return this.logicalMaxBatchSize(Integer.valueOf(__value));
        }

        public Builder continuousBatching(boolean __value) {
            this.continuousBatching = __value;
            return this;
        }

        private Builder continuousBatching(String __value) {
            return this.continuousBatching(Boolean.valueOf(__value));
        }

        public Builder contextSize(int __value) {
            this.contextSize = __value;
            return this;
        }

        private Builder contextSize(String __value) {
            return this.contextSize(Integer.valueOf(__value));
        }

        public Builder maxPromptTokens(int __value) {
            this.maxPromptTokens = __value;
            return this;
        }

        private Builder maxPromptTokens(String __value) {
            return this.maxPromptTokens(Integer.valueOf(__value));
        }

        public Builder seed(int __value) {
            this.seed = __value;
            return this;
        }

        private Builder seed(String __value) {
            return this.seed(Integer.valueOf(__value));
        }

        public Builder parallel(int __value) {
            this.parallel = __value;
            return this;
        }

        private Builder parallel(String __value) {
            return this.parallel(Integer.valueOf(__value));
        }

        public Builder threads(double __value) {
            this.threads = __value;
            return this;
        }

        private Builder threads(String __value) {
            return this.threads(Double.valueOf(__value));
        }

        public Builder batchThreads(double __value) {
            this.batchThreads = __value;
            return this;
        }

        private Builder batchThreads(String __value) {
            return this.batchThreads(Double.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return GgufEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return GgufEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return GgufEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public GgufEmbedderConfig build() {
            return new GgufEmbedderConfig(this);
        }
    }

    public static final class PoolingType
    extends EnumNode<Enum> {
        public static final Enum UNSPECIFIED = Enum.UNSPECIFIED;
        public static final Enum NONE = Enum.NONE;
        public static final Enum MEAN = Enum.MEAN;
        public static final Enum CLS = Enum.CLS;
        public static final Enum LAST = Enum.LAST;
        public static final Enum RANK = Enum.RANK;

        public PoolingType() {
            this.value = null;
        }

        public PoolingType(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            UNSPECIFIED,
            NONE,
            MEAN,
            CLS,
            LAST,
            RANK;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

