/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import java.util.HashSet;
import java.util.Set;

public final class DispatchConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "71bb1cf01498373f40a98e09b7d9d981";
    public static final String CONFIG_DEF_NAME = "dispatch";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "prioritizeAvailability bool default=true", "minActivedocsPercentage double default=97.0", "distributionPolicy enum { ROUNDROBIN, BEST_OF_RANDOM_2, LATENCY_AMORTIZED_OVER_REQUESTS, LATENCY_AMORTIZED_OVER_TIME, ADAPTIVE } default=ADAPTIVE", "maxHitsPerNode int default=2147483647", "topKProbability double default=0.9999", "redundancy long default=1", "minSearchCoverage double default=100", "minWaitAfterCoverageFactor double default=0", "maxWaitAfterCoverageFactor double default=1", "numJrtTransportThreads int default=8", "numJrtConnectionsPerNode int default=8", "warmuptime double default=0.1", "summaryDecodePolicy enum {EAGER, ONDEMAND} default=EAGER"};
    private final BooleanNode prioritizeAvailability;
    private final DoubleNode minActivedocsPercentage;
    private final DistributionPolicy distributionPolicy;
    private final IntegerNode maxHitsPerNode;
    private final DoubleNode topKProbability;
    private final LongNode redundancy;
    private final DoubleNode minSearchCoverage;
    private final DoubleNode minWaitAfterCoverageFactor;
    private final DoubleNode maxWaitAfterCoverageFactor;
    private final IntegerNode numJrtTransportThreads;
    private final IntegerNode numJrtConnectionsPerNode;
    private final DoubleNode warmuptime;
    private final SummaryDecodePolicy summaryDecodePolicy;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DispatchConfig(Builder builder) {
        this(builder, true);
    }

    private DispatchConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for dispatch must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.prioritizeAvailability = builder.prioritizeAvailability == null ? new BooleanNode(true) : new BooleanNode(builder.prioritizeAvailability.booleanValue());
        this.minActivedocsPercentage = builder.minActivedocsPercentage == null ? new DoubleNode(97.0) : new DoubleNode(builder.minActivedocsPercentage.doubleValue());
        this.distributionPolicy = builder.distributionPolicy == null ? new DistributionPolicy(DistributionPolicy.ADAPTIVE) : new DistributionPolicy(builder.distributionPolicy);
        this.maxHitsPerNode = builder.maxHitsPerNode == null ? new IntegerNode(Integer.MAX_VALUE) : new IntegerNode(builder.maxHitsPerNode.intValue());
        this.topKProbability = builder.topKProbability == null ? new DoubleNode(0.9999) : new DoubleNode(builder.topKProbability.doubleValue());
        this.redundancy = builder.redundancy == null ? new LongNode(1L) : new LongNode(builder.redundancy.longValue());
        this.minSearchCoverage = builder.minSearchCoverage == null ? new DoubleNode(100.0) : new DoubleNode(builder.minSearchCoverage.doubleValue());
        this.minWaitAfterCoverageFactor = builder.minWaitAfterCoverageFactor == null ? new DoubleNode(0.0) : new DoubleNode(builder.minWaitAfterCoverageFactor.doubleValue());
        this.maxWaitAfterCoverageFactor = builder.maxWaitAfterCoverageFactor == null ? new DoubleNode(1.0) : new DoubleNode(builder.maxWaitAfterCoverageFactor.doubleValue());
        this.numJrtTransportThreads = builder.numJrtTransportThreads == null ? new IntegerNode(8) : new IntegerNode(builder.numJrtTransportThreads.intValue());
        this.numJrtConnectionsPerNode = builder.numJrtConnectionsPerNode == null ? new IntegerNode(8) : new IntegerNode(builder.numJrtConnectionsPerNode.intValue());
        this.warmuptime = builder.warmuptime == null ? new DoubleNode(0.1) : new DoubleNode(builder.warmuptime.doubleValue());
        this.summaryDecodePolicy = builder.summaryDecodePolicy == null ? new SummaryDecodePolicy(SummaryDecodePolicy.EAGER) : new SummaryDecodePolicy(builder.summaryDecodePolicy);
    }

    public boolean prioritizeAvailability() {
        return this.prioritizeAvailability.value();
    }

    public double minActivedocsPercentage() {
        return this.minActivedocsPercentage.value();
    }

    public DistributionPolicy.Enum distributionPolicy() {
        return (DistributionPolicy.Enum)((Object)this.distributionPolicy.value());
    }

    public int maxHitsPerNode() {
        return this.maxHitsPerNode.value();
    }

    public double topKProbability() {
        return this.topKProbability.value();
    }

    public long redundancy() {
        return this.redundancy.value();
    }

    public double minSearchCoverage() {
        return this.minSearchCoverage.value();
    }

    public double minWaitAfterCoverageFactor() {
        return this.minWaitAfterCoverageFactor.value();
    }

    public double maxWaitAfterCoverageFactor() {
        return this.maxWaitAfterCoverageFactor.value();
    }

    public int numJrtTransportThreads() {
        return this.numJrtTransportThreads.value();
    }

    public int numJrtConnectionsPerNode() {
        return this.numJrtConnectionsPerNode.value();
    }

    public double warmuptime() {
        return this.warmuptime.value();
    }

    public SummaryDecodePolicy.Enum summaryDecodePolicy() {
        return (SummaryDecodePolicy.Enum)((Object)this.summaryDecodePolicy.value());
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DispatchConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean prioritizeAvailability = null;
        private Double minActivedocsPercentage = null;
        private DistributionPolicy.Enum distributionPolicy = null;
        private Integer maxHitsPerNode = null;
        private Double topKProbability = null;
        private Long redundancy = null;
        private Double minSearchCoverage = null;
        private Double minWaitAfterCoverageFactor = null;
        private Double maxWaitAfterCoverageFactor = null;
        private Integer numJrtTransportThreads = null;
        private Integer numJrtConnectionsPerNode = null;
        private Double warmuptime = null;
        private SummaryDecodePolicy.Enum summaryDecodePolicy = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DispatchConfig config) {
            this.prioritizeAvailability(config.prioritizeAvailability());
            this.minActivedocsPercentage(config.minActivedocsPercentage());
            this.distributionPolicy(config.distributionPolicy());
            this.maxHitsPerNode(config.maxHitsPerNode());
            this.topKProbability(config.topKProbability());
            this.redundancy(config.redundancy());
            this.minSearchCoverage(config.minSearchCoverage());
            this.minWaitAfterCoverageFactor(config.minWaitAfterCoverageFactor());
            this.maxWaitAfterCoverageFactor(config.maxWaitAfterCoverageFactor());
            this.numJrtTransportThreads(config.numJrtTransportThreads());
            this.numJrtConnectionsPerNode(config.numJrtConnectionsPerNode());
            this.warmuptime(config.warmuptime());
            this.summaryDecodePolicy(config.summaryDecodePolicy());
        }

        private Builder override(Builder __superior) {
            if (__superior.prioritizeAvailability != null) {
                this.prioritizeAvailability(__superior.prioritizeAvailability);
            }
            if (__superior.minActivedocsPercentage != null) {
                this.minActivedocsPercentage(__superior.minActivedocsPercentage);
            }
            if (__superior.distributionPolicy != null) {
                this.distributionPolicy(__superior.distributionPolicy);
            }
            if (__superior.maxHitsPerNode != null) {
                this.maxHitsPerNode(__superior.maxHitsPerNode);
            }
            if (__superior.topKProbability != null) {
                this.topKProbability(__superior.topKProbability);
            }
            if (__superior.redundancy != null) {
                this.redundancy(__superior.redundancy);
            }
            if (__superior.minSearchCoverage != null) {
                this.minSearchCoverage(__superior.minSearchCoverage);
            }
            if (__superior.minWaitAfterCoverageFactor != null) {
                this.minWaitAfterCoverageFactor(__superior.minWaitAfterCoverageFactor);
            }
            if (__superior.maxWaitAfterCoverageFactor != null) {
                this.maxWaitAfterCoverageFactor(__superior.maxWaitAfterCoverageFactor);
            }
            if (__superior.numJrtTransportThreads != null) {
                this.numJrtTransportThreads(__superior.numJrtTransportThreads);
            }
            if (__superior.numJrtConnectionsPerNode != null) {
                this.numJrtConnectionsPerNode(__superior.numJrtConnectionsPerNode);
            }
            if (__superior.warmuptime != null) {
                this.warmuptime(__superior.warmuptime);
            }
            if (__superior.summaryDecodePolicy != null) {
                this.summaryDecodePolicy(__superior.summaryDecodePolicy);
            }
            return this;
        }

        public Builder prioritizeAvailability(boolean __value) {
            this.prioritizeAvailability = __value;
            return this;
        }

        private Builder prioritizeAvailability(String __value) {
            return this.prioritizeAvailability(Boolean.valueOf(__value));
        }

        public Builder minActivedocsPercentage(double __value) {
            this.minActivedocsPercentage = __value;
            return this;
        }

        private Builder minActivedocsPercentage(String __value) {
            return this.minActivedocsPercentage(Double.valueOf(__value));
        }

        public Builder distributionPolicy(DistributionPolicy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.distributionPolicy = __value;
            return this;
        }

        private Builder distributionPolicy(String __value) {
            return this.distributionPolicy(DistributionPolicy.Enum.valueOf(__value));
        }

        public Builder maxHitsPerNode(int __value) {
            this.maxHitsPerNode = __value;
            return this;
        }

        private Builder maxHitsPerNode(String __value) {
            return this.maxHitsPerNode(Integer.valueOf(__value));
        }

        public Builder topKProbability(double __value) {
            this.topKProbability = __value;
            return this;
        }

        private Builder topKProbability(String __value) {
            return this.topKProbability(Double.valueOf(__value));
        }

        public Builder redundancy(long __value) {
            this.redundancy = __value;
            return this;
        }

        private Builder redundancy(String __value) {
            return this.redundancy(Long.valueOf(__value));
        }

        public Builder minSearchCoverage(double __value) {
            this.minSearchCoverage = __value;
            return this;
        }

        private Builder minSearchCoverage(String __value) {
            return this.minSearchCoverage(Double.valueOf(__value));
        }

        public Builder minWaitAfterCoverageFactor(double __value) {
            this.minWaitAfterCoverageFactor = __value;
            return this;
        }

        private Builder minWaitAfterCoverageFactor(String __value) {
            return this.minWaitAfterCoverageFactor(Double.valueOf(__value));
        }

        public Builder maxWaitAfterCoverageFactor(double __value) {
            this.maxWaitAfterCoverageFactor = __value;
            return this;
        }

        private Builder maxWaitAfterCoverageFactor(String __value) {
            return this.maxWaitAfterCoverageFactor(Double.valueOf(__value));
        }

        public Builder numJrtTransportThreads(int __value) {
            this.numJrtTransportThreads = __value;
            return this;
        }

        private Builder numJrtTransportThreads(String __value) {
            return this.numJrtTransportThreads(Integer.valueOf(__value));
        }

        public Builder numJrtConnectionsPerNode(int __value) {
            this.numJrtConnectionsPerNode = __value;
            return this;
        }

        private Builder numJrtConnectionsPerNode(String __value) {
            return this.numJrtConnectionsPerNode(Integer.valueOf(__value));
        }

        public Builder warmuptime(double __value) {
            this.warmuptime = __value;
            return this;
        }

        private Builder warmuptime(String __value) {
            return this.warmuptime(Double.valueOf(__value));
        }

        public Builder summaryDecodePolicy(SummaryDecodePolicy.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.summaryDecodePolicy = __value;
            return this;
        }

        private Builder summaryDecodePolicy(String __value) {
            return this.summaryDecodePolicy(SummaryDecodePolicy.Enum.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DispatchConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DispatchConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DispatchConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DispatchConfig build() {
            return new DispatchConfig(this);
        }
    }

    public static final class DistributionPolicy
    extends EnumNode<Enum> {
        public static final Enum ROUNDROBIN = Enum.ROUNDROBIN;
        public static final Enum BEST_OF_RANDOM_2 = Enum.BEST_OF_RANDOM_2;
        public static final Enum LATENCY_AMORTIZED_OVER_REQUESTS = Enum.LATENCY_AMORTIZED_OVER_REQUESTS;
        public static final Enum LATENCY_AMORTIZED_OVER_TIME = Enum.LATENCY_AMORTIZED_OVER_TIME;
        public static final Enum ADAPTIVE = Enum.ADAPTIVE;

        public DistributionPolicy() {
            this.value = null;
        }

        public DistributionPolicy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ROUNDROBIN,
            BEST_OF_RANDOM_2,
            LATENCY_AMORTIZED_OVER_REQUESTS,
            LATENCY_AMORTIZED_OVER_TIME,
            ADAPTIVE;

        }
    }

    public static final class SummaryDecodePolicy
    extends EnumNode<Enum> {
        public static final Enum EAGER = Enum.EAGER;
        public static final Enum ONDEMAND = Enum.ONDEMAND;

        public SummaryDecodePolicy() {
            this.value = null;
        }

        public SummaryDecodePolicy(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            EAGER,
            ONDEMAND;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

