/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.language.huggingface.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class HuggingFaceTokenizerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "3cb0f5da9cf3a1bd23ab75d8a6b9b771";
    public static final String CONFIG_DEF_NAME = "hugging-face-tokenizer";
    public static final String CONFIG_DEF_NAMESPACE = "language.huggingface.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=language.huggingface.config", "model[].language string", "model[].path model", "addSpecialTokens bool default=true", "maxLength int default=-1", "truncation enum { ON, OFF, NOTSET } default=NOTSET", "padding enum { ON, OFF, NOTSET } default=NOTSET"};
    private final InnerNodeVector<Model> model;
    private final BooleanNode addSpecialTokens;
    private final IntegerNode maxLength;
    private final Truncation truncation;
    private final Padding padding;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public HuggingFaceTokenizerConfig(Builder builder) {
        this(builder, true);
    }

    private HuggingFaceTokenizerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for hugging-face-tokenizer must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.model = Model.createVector(builder.model);
        this.addSpecialTokens = builder.addSpecialTokens == null ? new BooleanNode(true) : new BooleanNode(builder.addSpecialTokens.booleanValue());
        this.maxLength = builder.maxLength == null ? new IntegerNode(-1) : new IntegerNode(builder.maxLength.intValue());
        this.truncation = builder.truncation == null ? new Truncation(Truncation.NOTSET) : new Truncation(builder.truncation);
        this.padding = builder.padding == null ? new Padding(Padding.NOTSET) : new Padding(builder.padding);
    }

    public List<Model> model() {
        return this.model;
    }

    public Model model(int i) {
        return (Model)((Object)this.model.get(i));
    }

    public boolean addSpecialTokens() {
        return this.addSpecialTokens.value();
    }

    public int maxLength() {
        return this.maxLength.value();
    }

    public Truncation.Enum truncation() {
        return (Truncation.Enum)((Object)this.truncation.value());
    }

    public Padding.Enum padding() {
        return (Padding.Enum)((Object)this.padding.value());
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HuggingFaceTokenizerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Model.Builder> model = new ArrayList<Model.Builder>();
        private Boolean addSpecialTokens = null;
        private Integer maxLength = null;
        private Truncation.Enum truncation = null;
        private Padding.Enum padding = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(HuggingFaceTokenizerConfig config) {
            for (Model m : config.model()) {
                this.model(new Model.Builder(m));
            }
            this.addSpecialTokens(config.addSpecialTokens());
            this.maxLength(config.maxLength());
            this.truncation(config.truncation());
            this.padding(config.padding());
        }

        private Builder override(Builder __superior) {
            if (!__superior.model.isEmpty()) {
                this.model.addAll(__superior.model);
            }
            if (__superior.addSpecialTokens != null) {
                this.addSpecialTokens(__superior.addSpecialTokens);
            }
            if (__superior.maxLength != null) {
                this.maxLength(__superior.maxLength);
            }
            if (__superior.truncation != null) {
                this.truncation(__superior.truncation);
            }
            if (__superior.padding != null) {
                this.padding(__superior.padding);
            }
            return this;
        }

        public Builder model(Model.Builder __builder) {
            this.model.add(__builder);
            return this;
        }

        public Builder model(Consumer<Model.Builder> __func) {
            Model.Builder __inner = new Model.Builder();
            __func.accept(__inner);
            this.model.add(__inner);
            return this;
        }

        public Builder model(List<Model.Builder> __builders) {
            this.model = __builders;
            return this;
        }

        public Builder addSpecialTokens(boolean __value) {
            this.addSpecialTokens = __value;
            return this;
        }

        private Builder addSpecialTokens(String __value) {
            return this.addSpecialTokens(Boolean.valueOf(__value));
        }

        public Builder maxLength(int __value) {
            this.maxLength = __value;
            return this;
        }

        private Builder maxLength(String __value) {
            return this.maxLength(Integer.valueOf(__value));
        }

        public Builder truncation(Truncation.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.truncation = __value;
            return this;
        }

        private Builder truncation(String __value) {
            return this.truncation(Truncation.Enum.valueOf(__value));
        }

        public Builder padding(Padding.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.padding = __value;
            return this;
        }

        private Builder padding(String __value) {
            return this.padding(Padding.Enum.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return HuggingFaceTokenizerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return HuggingFaceTokenizerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return HuggingFaceTokenizerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public HuggingFaceTokenizerConfig build() {
            return new HuggingFaceTokenizerConfig(this);
        }
    }

    public static final class Model
    extends InnerNode {
        private final StringNode language;
        private final ModelNode path;

        public Model(Builder builder) {
            this(builder, true);
        }

        private Model(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for hugging-face-tokenizer.model[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.language = builder.language == null ? new StringNode() : new StringNode(builder.language);
            this.path = builder.path == null ? new ModelNode() : new ModelNode(builder.path);
        }

        public String language() {
            return this.language.value();
        }

        public Path path() {
            return (Path)this.path.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
            return changes;
        }

        private static InnerNodeVector<Model> createVector(List<Builder> builders) {
            ArrayList<Model> elems = new ArrayList<Model>();
            for (Builder b : builders) {
                elems.add(new Model(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("language", "path"));
            private String language = null;
            private ModelReference path = null;

            public Builder() {
            }

            public Builder(Model config) {
                this.language(config.language());
                this.path(config.path.getModelReference());
            }

            private Builder override(Builder __superior) {
                if (__superior.language != null) {
                    this.language(__superior.language);
                }
                if (__superior.path != null) {
                    this.path(__superior.path);
                }
                return this;
            }

            public Builder language(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.language = __value;
                this.__uninitialized.remove("language");
                return this;
            }

            public Builder path(ModelReference __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.path = __value;
                this.__uninitialized.remove("path");
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    public static final class Truncation
    extends EnumNode<Enum> {
        public static final Enum ON = Enum.ON;
        public static final Enum OFF = Enum.OFF;
        public static final Enum NOTSET = Enum.NOTSET;

        public Truncation() {
            this.value = null;
        }

        public Truncation(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ON,
            OFF,
            NOTSET;

        }
    }

    public static final class Padding
    extends EnumNode<Enum> {
        public static final Enum ON = Enum.ON;
        public static final Enum OFF = Enum.OFF;
        public static final Enum NOTSET = Enum.NOTSET;

        public Padding() {
            this.value = null;
        }

        public Padding(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ON,
            OFF,
            NOTSET;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

