/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.embedding;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SpladeEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "18fdf7febcb71658372f618e0e800429";
    public static final String CONFIG_DEF_NAME = "splade-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "embedding";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=embedding", "tokenizerPath model", "transformerModel model", "transformerMaxTokens int default=512", "transformerInputIds string default=input_ids", "transformerAttentionMask string default=attention_mask", "transformerTokenTypeIds string default=token_type_ids", "transformerOutput string default=logits", "termScoreThreshold double default=0.0", "transformerExecutionMode enum { parallel, sequential } default=sequential", "transformerInterOpThreads int default=1", "transformerIntraOpThreads int default=-4", "transformerGpuDevice int default=0"};
    private final ModelNode tokenizerPath;
    private final ModelNode transformerModel;
    private final IntegerNode transformerMaxTokens;
    private final StringNode transformerInputIds;
    private final StringNode transformerAttentionMask;
    private final StringNode transformerTokenTypeIds;
    private final StringNode transformerOutput;
    private final DoubleNode termScoreThreshold;
    private final TransformerExecutionMode transformerExecutionMode;
    private final IntegerNode transformerInterOpThreads;
    private final IntegerNode transformerIntraOpThreads;
    private final IntegerNode transformerGpuDevice;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SpladeEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private SpladeEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for splade-embedder must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.tokenizerPath = builder.tokenizerPath == null ? new ModelNode() : new ModelNode(builder.tokenizerPath);
        this.transformerModel = builder.transformerModel == null ? new ModelNode() : new ModelNode(builder.transformerModel);
        this.transformerMaxTokens = builder.transformerMaxTokens == null ? new IntegerNode(512) : new IntegerNode(builder.transformerMaxTokens.intValue());
        this.transformerInputIds = builder.transformerInputIds == null ? new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
        this.transformerAttentionMask = builder.transformerAttentionMask == null ? new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
        this.transformerTokenTypeIds = builder.transformerTokenTypeIds == null ? new StringNode("token_type_ids") : new StringNode(builder.transformerTokenTypeIds);
        this.transformerOutput = builder.transformerOutput == null ? new StringNode("logits") : new StringNode(builder.transformerOutput);
        this.termScoreThreshold = builder.termScoreThreshold == null ? new DoubleNode(0.0) : new DoubleNode(builder.termScoreThreshold.doubleValue());
        this.transformerExecutionMode = builder.transformerExecutionMode == null ? new TransformerExecutionMode(TransformerExecutionMode.sequential) : new TransformerExecutionMode(builder.transformerExecutionMode);
        this.transformerInterOpThreads = builder.transformerInterOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.transformerInterOpThreads.intValue());
        this.transformerIntraOpThreads = builder.transformerIntraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.transformerIntraOpThreads.intValue());
        this.transformerGpuDevice = builder.transformerGpuDevice == null ? new IntegerNode(0) : new IntegerNode(builder.transformerGpuDevice.intValue());
    }

    public Path tokenizerPath() {
        return (Path)this.tokenizerPath.value();
    }

    public Path transformerModel() {
        return (Path)this.transformerModel.value();
    }

    public int transformerMaxTokens() {
        return this.transformerMaxTokens.value();
    }

    public String transformerInputIds() {
        return this.transformerInputIds.value();
    }

    public String transformerAttentionMask() {
        return this.transformerAttentionMask.value();
    }

    public String transformerTokenTypeIds() {
        return this.transformerTokenTypeIds.value();
    }

    public String transformerOutput() {
        return this.transformerOutput.value();
    }

    public double termScoreThreshold() {
        return this.termScoreThreshold.value();
    }

    public TransformerExecutionMode.Enum transformerExecutionMode() {
        return (TransformerExecutionMode.Enum)((Object)this.transformerExecutionMode.value());
    }

    public int transformerInterOpThreads() {
        return this.transformerInterOpThreads.value();
    }

    public int transformerIntraOpThreads() {
        return this.transformerIntraOpThreads.value();
    }

    public int transformerGpuDevice() {
        return this.transformerGpuDevice.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SpladeEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("tokenizerPath", "transformerModel"));
        private ModelReference tokenizerPath = null;
        private ModelReference transformerModel = null;
        private Integer transformerMaxTokens = null;
        private String transformerInputIds = null;
        private String transformerAttentionMask = null;
        private String transformerTokenTypeIds = null;
        private String transformerOutput = null;
        private Double termScoreThreshold = null;
        private TransformerExecutionMode.Enum transformerExecutionMode = null;
        private Integer transformerInterOpThreads = null;
        private Integer transformerIntraOpThreads = null;
        private Integer transformerGpuDevice = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SpladeEmbedderConfig config) {
            this.tokenizerPath(config.tokenizerPath.getModelReference());
            this.transformerModel(config.transformerModel.getModelReference());
            this.transformerMaxTokens(config.transformerMaxTokens());
            this.transformerInputIds(config.transformerInputIds());
            this.transformerAttentionMask(config.transformerAttentionMask());
            this.transformerTokenTypeIds(config.transformerTokenTypeIds());
            this.transformerOutput(config.transformerOutput());
            this.termScoreThreshold(config.termScoreThreshold());
            this.transformerExecutionMode(config.transformerExecutionMode());
            this.transformerInterOpThreads(config.transformerInterOpThreads());
            this.transformerIntraOpThreads(config.transformerIntraOpThreads());
            this.transformerGpuDevice(config.transformerGpuDevice());
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenizerPath != null) {
                this.tokenizerPath(__superior.tokenizerPath);
            }
            if (__superior.transformerModel != null) {
                this.transformerModel(__superior.transformerModel);
            }
            if (__superior.transformerMaxTokens != null) {
                this.transformerMaxTokens(__superior.transformerMaxTokens);
            }
            if (__superior.transformerInputIds != null) {
                this.transformerInputIds(__superior.transformerInputIds);
            }
            if (__superior.transformerAttentionMask != null) {
                this.transformerAttentionMask(__superior.transformerAttentionMask);
            }
            if (__superior.transformerTokenTypeIds != null) {
                this.transformerTokenTypeIds(__superior.transformerTokenTypeIds);
            }
            if (__superior.transformerOutput != null) {
                this.transformerOutput(__superior.transformerOutput);
            }
            if (__superior.termScoreThreshold != null) {
                this.termScoreThreshold(__superior.termScoreThreshold);
            }
            if (__superior.transformerExecutionMode != null) {
                this.transformerExecutionMode(__superior.transformerExecutionMode);
            }
            if (__superior.transformerInterOpThreads != null) {
                this.transformerInterOpThreads(__superior.transformerInterOpThreads);
            }
            if (__superior.transformerIntraOpThreads != null) {
                this.transformerIntraOpThreads(__superior.transformerIntraOpThreads);
            }
            if (__superior.transformerGpuDevice != null) {
                this.transformerGpuDevice(__superior.transformerGpuDevice);
            }
            return this;
        }

        public Builder tokenizerPath(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerPath = __value;
            this.__uninitialized.remove("tokenizerPath");
            return this;
        }

        public Builder transformerModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerModel = __value;
            this.__uninitialized.remove("transformerModel");
            return this;
        }

        public Builder transformerMaxTokens(int __value) {
            this.transformerMaxTokens = __value;
            return this;
        }

        private Builder transformerMaxTokens(String __value) {
            return this.transformerMaxTokens(Integer.valueOf(__value));
        }

        public Builder transformerInputIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerInputIds = __value;
            return this;
        }

        public Builder transformerAttentionMask(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerAttentionMask = __value;
            return this;
        }

        public Builder transformerTokenTypeIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerTokenTypeIds = __value;
            return this;
        }

        public Builder transformerOutput(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerOutput = __value;
            return this;
        }

        public Builder termScoreThreshold(double __value) {
            this.termScoreThreshold = __value;
            return this;
        }

        private Builder termScoreThreshold(String __value) {
            return this.termScoreThreshold(Double.valueOf(__value));
        }

        public Builder transformerExecutionMode(TransformerExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerExecutionMode = __value;
            return this;
        }

        private Builder transformerExecutionMode(String __value) {
            return this.transformerExecutionMode(TransformerExecutionMode.Enum.valueOf(__value));
        }

        public Builder transformerInterOpThreads(int __value) {
            this.transformerInterOpThreads = __value;
            return this;
        }

        private Builder transformerInterOpThreads(String __value) {
            return this.transformerInterOpThreads(Integer.valueOf(__value));
        }

        public Builder transformerIntraOpThreads(int __value) {
            this.transformerIntraOpThreads = __value;
            return this;
        }

        private Builder transformerIntraOpThreads(String __value) {
            return this.transformerIntraOpThreads(Integer.valueOf(__value));
        }

        public Builder transformerGpuDevice(int __value) {
            this.transformerGpuDevice = __value;
            return this;
        }

        private Builder transformerGpuDevice(String __value) {
            return this.transformerGpuDevice(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SpladeEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SpladeEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SpladeEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SpladeEmbedderConfig build() {
            return new SpladeEmbedderConfig(this);
        }
    }

    public static final class TransformerExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public TransformerExecutionMode() {
            this.value = null;
        }

        public TransformerExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

