/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ZookeeperServerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "df50f0640cedb06f94499efacb35784a";
    public static final String CONFIG_DEF_NAME = "zookeeper-server";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "zooKeeperConfigFile string default=\"var/zookeeper/conf/zookeeper.cfg\"", "tickTime int default=6000", "initLimit int default=20", "syncLimit int default=15", "maxClientConnections int default=0", "dataDir string default=\"var/zookeeper\"", "clientPort int default=2181", "snapshotCount int default=50000", "autopurge.purgeInterval int default=1", "autopurge.snapRetainCount int default=15", "myidFile string default=\"var/zookeeper/myid\"", "juteMaxBuffer int default=52428800", "myid int restart", "server[].id int", "server[].hostname string", "server[].clientPort int default=2181", "server[].quorumPort int default=2182", "server[].electionPort int default=2183", "server[].joining bool default=false", "server[].retired bool default=false", "trustEmptySnapshot bool default=true", "dynamicReconfiguration bool default=false", "snapshotMethod string default=\"\"", "vespaTlsConfigFile string default=\"\"", "leaderCloseSocketAsync bool default=false", "learnerAsyncSending bool default=false", "reconfigureEnsemble bool default=true", "preAllocSizeKb long default=65536"};
    private final StringNode zooKeeperConfigFile;
    private final IntegerNode tickTime;
    private final IntegerNode initLimit;
    private final IntegerNode syncLimit;
    private final IntegerNode maxClientConnections;
    private final StringNode dataDir;
    private final IntegerNode clientPort;
    private final IntegerNode snapshotCount;
    private final Autopurge autopurge;
    private final StringNode myidFile;
    private final IntegerNode juteMaxBuffer;
    private final IntegerNode myid;
    private final InnerNodeVector<Server> server;
    private final BooleanNode trustEmptySnapshot;
    private final BooleanNode dynamicReconfiguration;
    private final StringNode snapshotMethod;
    private final StringNode vespaTlsConfigFile;
    private final BooleanNode leaderCloseSocketAsync;
    private final BooleanNode learnerAsyncSending;
    private final BooleanNode reconfigureEnsemble;
    private final LongNode preAllocSizeKb;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ZookeeperServerConfig(Builder builder) {
        this(builder, true);
    }

    private ZookeeperServerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for zookeeper-server must be initialized: " + builder.__uninitialized);
        }
        this.zooKeeperConfigFile = builder.zooKeeperConfigFile == null ? new StringNode("var/zookeeper/conf/zookeeper.cfg") : new StringNode(builder.zooKeeperConfigFile);
        this.tickTime = builder.tickTime == null ? new IntegerNode(6000) : new IntegerNode(builder.tickTime.intValue());
        this.initLimit = builder.initLimit == null ? new IntegerNode(20) : new IntegerNode(builder.initLimit.intValue());
        this.syncLimit = builder.syncLimit == null ? new IntegerNode(15) : new IntegerNode(builder.syncLimit.intValue());
        this.maxClientConnections = builder.maxClientConnections == null ? new IntegerNode(0) : new IntegerNode(builder.maxClientConnections.intValue());
        this.dataDir = builder.dataDir == null ? new StringNode("var/zookeeper") : new StringNode(builder.dataDir);
        this.clientPort = builder.clientPort == null ? new IntegerNode(2181) : new IntegerNode(builder.clientPort.intValue());
        this.snapshotCount = builder.snapshotCount == null ? new IntegerNode(50000) : new IntegerNode(builder.snapshotCount.intValue());
        this.autopurge = new Autopurge(builder.autopurge, throwIfUninitialized);
        this.myidFile = builder.myidFile == null ? new StringNode("var/zookeeper/myid") : new StringNode(builder.myidFile);
        this.juteMaxBuffer = builder.juteMaxBuffer == null ? new IntegerNode(0x3200000) : new IntegerNode(builder.juteMaxBuffer.intValue());
        this.myid = builder.myid == null ? new IntegerNode() : new IntegerNode(builder.myid.intValue());
        this.server = Server.createVector(builder.server);
        this.trustEmptySnapshot = builder.trustEmptySnapshot == null ? new BooleanNode(true) : new BooleanNode(builder.trustEmptySnapshot.booleanValue());
        this.dynamicReconfiguration = builder.dynamicReconfiguration == null ? new BooleanNode(false) : new BooleanNode(builder.dynamicReconfiguration.booleanValue());
        this.snapshotMethod = builder.snapshotMethod == null ? new StringNode("") : new StringNode(builder.snapshotMethod);
        this.vespaTlsConfigFile = builder.vespaTlsConfigFile == null ? new StringNode("") : new StringNode(builder.vespaTlsConfigFile);
        this.leaderCloseSocketAsync = builder.leaderCloseSocketAsync == null ? new BooleanNode(false) : new BooleanNode(builder.leaderCloseSocketAsync.booleanValue());
        this.learnerAsyncSending = builder.learnerAsyncSending == null ? new BooleanNode(false) : new BooleanNode(builder.learnerAsyncSending.booleanValue());
        this.reconfigureEnsemble = builder.reconfigureEnsemble == null ? new BooleanNode(true) : new BooleanNode(builder.reconfigureEnsemble.booleanValue());
        this.preAllocSizeKb = builder.preAllocSizeKb == null ? new LongNode(65536L) : new LongNode(builder.preAllocSizeKb.longValue());
    }

    public String zooKeeperConfigFile() {
        return this.zooKeeperConfigFile.value();
    }

    public int tickTime() {
        return this.tickTime.value();
    }

    public int initLimit() {
        return this.initLimit.value();
    }

    public int syncLimit() {
        return this.syncLimit.value();
    }

    public int maxClientConnections() {
        return this.maxClientConnections.value();
    }

    public String dataDir() {
        return this.dataDir.value();
    }

    public int clientPort() {
        return this.clientPort.value();
    }

    public int snapshotCount() {
        return this.snapshotCount.value();
    }

    public Autopurge autopurge() {
        return this.autopurge;
    }

    public String myidFile() {
        return this.myidFile.value();
    }

    public int juteMaxBuffer() {
        return this.juteMaxBuffer.value();
    }

    public int myid() {
        return this.myid.value();
    }

    public List<Server> server() {
        return this.server;
    }

    public Server server(int i) {
        return (Server)((Object)this.server.get(i));
    }

    public boolean trustEmptySnapshot() {
        return this.trustEmptySnapshot.value();
    }

    public boolean dynamicReconfiguration() {
        return this.dynamicReconfiguration.value();
    }

    public String snapshotMethod() {
        return this.snapshotMethod.value();
    }

    public String vespaTlsConfigFile() {
        return this.vespaTlsConfigFile.value();
    }

    public boolean leaderCloseSocketAsync() {
        return this.leaderCloseSocketAsync.value();
    }

    public boolean learnerAsyncSending() {
        return this.learnerAsyncSending.value();
    }

    public boolean reconfigureEnsemble() {
        return this.reconfigureEnsemble.value();
    }

    public long preAllocSizeKb() {
        return this.preAllocSizeKb.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ZookeeperServerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.myid, (Node)newConfig.myid, "myid", "");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("myid"));
        private String zooKeeperConfigFile = null;
        private Integer tickTime = null;
        private Integer initLimit = null;
        private Integer syncLimit = null;
        private Integer maxClientConnections = null;
        private String dataDir = null;
        private Integer clientPort = null;
        private Integer snapshotCount = null;
        public Autopurge.Builder autopurge = new Autopurge.Builder();
        private String myidFile = null;
        private Integer juteMaxBuffer = null;
        private Integer myid = null;
        public List<Server.Builder> server = new ArrayList<Server.Builder>();
        private Boolean trustEmptySnapshot = null;
        private Boolean dynamicReconfiguration = null;
        private String snapshotMethod = null;
        private String vespaTlsConfigFile = null;
        private Boolean leaderCloseSocketAsync = null;
        private Boolean learnerAsyncSending = null;
        private Boolean reconfigureEnsemble = null;
        private Long preAllocSizeKb = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ZookeeperServerConfig config) {
            this.zooKeeperConfigFile(config.zooKeeperConfigFile());
            this.tickTime(config.tickTime());
            this.initLimit(config.initLimit());
            this.syncLimit(config.syncLimit());
            this.maxClientConnections(config.maxClientConnections());
            this.dataDir(config.dataDir());
            this.clientPort(config.clientPort());
            this.snapshotCount(config.snapshotCount());
            this.autopurge(new Autopurge.Builder(config.autopurge()));
            this.myidFile(config.myidFile());
            this.juteMaxBuffer(config.juteMaxBuffer());
            this.myid(config.myid());
            for (Server s : config.server()) {
                this.server(new Server.Builder(s));
            }
            this.trustEmptySnapshot(config.trustEmptySnapshot());
            this.dynamicReconfiguration(config.dynamicReconfiguration());
            this.snapshotMethod(config.snapshotMethod());
            this.vespaTlsConfigFile(config.vespaTlsConfigFile());
            this.leaderCloseSocketAsync(config.leaderCloseSocketAsync());
            this.learnerAsyncSending(config.learnerAsyncSending());
            this.reconfigureEnsemble(config.reconfigureEnsemble());
            this.preAllocSizeKb(config.preAllocSizeKb());
        }

        private Builder override(Builder __superior) {
            if (__superior.zooKeeperConfigFile != null) {
                this.zooKeeperConfigFile(__superior.zooKeeperConfigFile);
            }
            if (__superior.tickTime != null) {
                this.tickTime(__superior.tickTime);
            }
            if (__superior.initLimit != null) {
                this.initLimit(__superior.initLimit);
            }
            if (__superior.syncLimit != null) {
                this.syncLimit(__superior.syncLimit);
            }
            if (__superior.maxClientConnections != null) {
                this.maxClientConnections(__superior.maxClientConnections);
            }
            if (__superior.dataDir != null) {
                this.dataDir(__superior.dataDir);
            }
            if (__superior.clientPort != null) {
                this.clientPort(__superior.clientPort);
            }
            if (__superior.snapshotCount != null) {
                this.snapshotCount(__superior.snapshotCount);
            }
            this.autopurge(this.autopurge.override(__superior.autopurge));
            if (__superior.myidFile != null) {
                this.myidFile(__superior.myidFile);
            }
            if (__superior.juteMaxBuffer != null) {
                this.juteMaxBuffer(__superior.juteMaxBuffer);
            }
            if (__superior.myid != null) {
                this.myid(__superior.myid);
            }
            if (!__superior.server.isEmpty()) {
                this.server.addAll(__superior.server);
            }
            if (__superior.trustEmptySnapshot != null) {
                this.trustEmptySnapshot(__superior.trustEmptySnapshot);
            }
            if (__superior.dynamicReconfiguration != null) {
                this.dynamicReconfiguration(__superior.dynamicReconfiguration);
            }
            if (__superior.snapshotMethod != null) {
                this.snapshotMethod(__superior.snapshotMethod);
            }
            if (__superior.vespaTlsConfigFile != null) {
                this.vespaTlsConfigFile(__superior.vespaTlsConfigFile);
            }
            if (__superior.leaderCloseSocketAsync != null) {
                this.leaderCloseSocketAsync(__superior.leaderCloseSocketAsync);
            }
            if (__superior.learnerAsyncSending != null) {
                this.learnerAsyncSending(__superior.learnerAsyncSending);
            }
            if (__superior.reconfigureEnsemble != null) {
                this.reconfigureEnsemble(__superior.reconfigureEnsemble);
            }
            if (__superior.preAllocSizeKb != null) {
                this.preAllocSizeKb(__superior.preAllocSizeKb);
            }
            return this;
        }

        public Builder zooKeeperConfigFile(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.zooKeeperConfigFile = __value;
            return this;
        }

        public Builder tickTime(int __value) {
            this.tickTime = __value;
            return this;
        }

        private Builder tickTime(String __value) {
            return this.tickTime(Integer.valueOf(__value));
        }

        public Builder initLimit(int __value) {
            this.initLimit = __value;
            return this;
        }

        private Builder initLimit(String __value) {
            return this.initLimit(Integer.valueOf(__value));
        }

        public Builder syncLimit(int __value) {
            this.syncLimit = __value;
            return this;
        }

        private Builder syncLimit(String __value) {
            return this.syncLimit(Integer.valueOf(__value));
        }

        public Builder maxClientConnections(int __value) {
            this.maxClientConnections = __value;
            return this;
        }

        private Builder maxClientConnections(String __value) {
            return this.maxClientConnections(Integer.valueOf(__value));
        }

        public Builder dataDir(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.dataDir = __value;
            return this;
        }

        public Builder clientPort(int __value) {
            this.clientPort = __value;
            return this;
        }

        private Builder clientPort(String __value) {
            return this.clientPort(Integer.valueOf(__value));
        }

        public Builder snapshotCount(int __value) {
            this.snapshotCount = __value;
            return this;
        }

        private Builder snapshotCount(String __value) {
            return this.snapshotCount(Integer.valueOf(__value));
        }

        public Builder autopurge(Autopurge.Builder __builder) {
            this.autopurge = __builder;
            return this;
        }

        public Builder autopurge(Consumer<Autopurge.Builder> __func) {
            Autopurge.Builder __inner = new Autopurge.Builder();
            __func.accept(__inner);
            this.autopurge = __inner;
            return this;
        }

        public Builder myidFile(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.myidFile = __value;
            return this;
        }

        public Builder juteMaxBuffer(int __value) {
            this.juteMaxBuffer = __value;
            return this;
        }

        private Builder juteMaxBuffer(String __value) {
            return this.juteMaxBuffer(Integer.valueOf(__value));
        }

        public Builder myid(int __value) {
            this.myid = __value;
            this.__uninitialized.remove("myid");
            return this;
        }

        private Builder myid(String __value) {
            return this.myid(Integer.valueOf(__value));
        }

        public Builder server(Server.Builder __builder) {
            this.server.add(__builder);
            return this;
        }

        public Builder server(Consumer<Server.Builder> __func) {
            Server.Builder __inner = new Server.Builder();
            __func.accept(__inner);
            this.server.add(__inner);
            return this;
        }

        public Builder server(List<Server.Builder> __builders) {
            this.server = __builders;
            return this;
        }

        public Builder trustEmptySnapshot(boolean __value) {
            this.trustEmptySnapshot = __value;
            return this;
        }

        private Builder trustEmptySnapshot(String __value) {
            return this.trustEmptySnapshot(Boolean.valueOf(__value));
        }

        public Builder dynamicReconfiguration(boolean __value) {
            this.dynamicReconfiguration = __value;
            return this;
        }

        private Builder dynamicReconfiguration(String __value) {
            return this.dynamicReconfiguration(Boolean.valueOf(__value));
        }

        public Builder snapshotMethod(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.snapshotMethod = __value;
            return this;
        }

        public Builder vespaTlsConfigFile(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.vespaTlsConfigFile = __value;
            return this;
        }

        public Builder leaderCloseSocketAsync(boolean __value) {
            this.leaderCloseSocketAsync = __value;
            return this;
        }

        private Builder leaderCloseSocketAsync(String __value) {
            return this.leaderCloseSocketAsync(Boolean.valueOf(__value));
        }

        public Builder learnerAsyncSending(boolean __value) {
            this.learnerAsyncSending = __value;
            return this;
        }

        private Builder learnerAsyncSending(String __value) {
            return this.learnerAsyncSending(Boolean.valueOf(__value));
        }

        public Builder reconfigureEnsemble(boolean __value) {
            this.reconfigureEnsemble = __value;
            return this;
        }

        private Builder reconfigureEnsemble(String __value) {
            return this.reconfigureEnsemble(Boolean.valueOf(__value));
        }

        public Builder preAllocSizeKb(long __value) {
            this.preAllocSizeKb = __value;
            return this;
        }

        private Builder preAllocSizeKb(String __value) {
            return this.preAllocSizeKb(Long.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ZookeeperServerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ZookeeperServerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ZookeeperServerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ZookeeperServerConfig build() {
            return new ZookeeperServerConfig(this);
        }
    }

    public static final class Autopurge
    extends InnerNode {
        private final IntegerNode purgeInterval;
        private final IntegerNode snapRetainCount;

        public Autopurge(Builder builder) {
            this(builder, true);
        }

        private Autopurge(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for zookeeper-server.autopurge must be initialized: " + builder.__uninitialized);
            }
            this.purgeInterval = builder.purgeInterval == null ? new IntegerNode(1) : new IntegerNode(builder.purgeInterval.intValue());
            this.snapRetainCount = builder.snapRetainCount == null ? new IntegerNode(15) : new IntegerNode(builder.snapRetainCount.intValue());
        }

        public int purgeInterval() {
            return this.purgeInterval.value();
        }

        public int snapRetainCount() {
            return this.snapRetainCount.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Autopurge newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("autopurge");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer purgeInterval = null;
            private Integer snapRetainCount = null;

            public Builder() {
            }

            public Builder(Autopurge config) {
                this.purgeInterval(config.purgeInterval());
                this.snapRetainCount(config.snapRetainCount());
            }

            private Builder override(Builder __superior) {
                if (__superior.purgeInterval != null) {
                    this.purgeInterval(__superior.purgeInterval);
                }
                if (__superior.snapRetainCount != null) {
                    this.snapRetainCount(__superior.snapRetainCount);
                }
                return this;
            }

            public Builder purgeInterval(int __value) {
                this.purgeInterval = __value;
                return this;
            }

            private Builder purgeInterval(String __value) {
                return this.purgeInterval(Integer.valueOf(__value));
            }

            public Builder snapRetainCount(int __value) {
                this.snapRetainCount = __value;
                return this;
            }

            private Builder snapRetainCount(String __value) {
                return this.snapRetainCount(Integer.valueOf(__value));
            }

            public Autopurge build() {
                return new Autopurge(this);
            }
        }
    }

    public static final class Server
    extends InnerNode {
        private final IntegerNode id;
        private final StringNode hostname;
        private final IntegerNode clientPort;
        private final IntegerNode quorumPort;
        private final IntegerNode electionPort;
        private final BooleanNode joining;
        private final BooleanNode retired;

        public Server(Builder builder) {
            this(builder, true);
        }

        private Server(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for zookeeper-server.server[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.hostname = builder.hostname == null ? new StringNode() : new StringNode(builder.hostname);
            this.clientPort = builder.clientPort == null ? new IntegerNode(2181) : new IntegerNode(builder.clientPort.intValue());
            this.quorumPort = builder.quorumPort == null ? new IntegerNode(2182) : new IntegerNode(builder.quorumPort.intValue());
            this.electionPort = builder.electionPort == null ? new IntegerNode(2183) : new IntegerNode(builder.electionPort.intValue());
            this.joining = builder.joining == null ? new BooleanNode(false) : new BooleanNode(builder.joining.booleanValue());
            this.retired = builder.retired == null ? new BooleanNode(false) : new BooleanNode(builder.retired.booleanValue());
        }

        public int id() {
            return this.id.value();
        }

        public String hostname() {
            return this.hostname.value();
        }

        public int clientPort() {
            return this.clientPort.value();
        }

        public int quorumPort() {
            return this.quorumPort.value();
        }

        public int electionPort() {
            return this.electionPort.value();
        }

        public boolean joining() {
            return this.joining.value();
        }

        public boolean retired() {
            return this.retired.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Server newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("server");
            return changes;
        }

        private static InnerNodeVector<Server> createVector(List<Builder> builders) {
            ArrayList<Server> elems = new ArrayList<Server>();
            for (Builder b : builders) {
                elems.add(new Server(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("id", "hostname"));
            private Integer id = null;
            private String hostname = null;
            private Integer clientPort = null;
            private Integer quorumPort = null;
            private Integer electionPort = null;
            private Boolean joining = null;
            private Boolean retired = null;

            public Builder() {
            }

            public Builder(Server config) {
                this.id(config.id());
                this.hostname(config.hostname());
                this.clientPort(config.clientPort());
                this.quorumPort(config.quorumPort());
                this.electionPort(config.electionPort());
                this.joining(config.joining());
                this.retired(config.retired());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.hostname != null) {
                    this.hostname(__superior.hostname);
                }
                if (__superior.clientPort != null) {
                    this.clientPort(__superior.clientPort);
                }
                if (__superior.quorumPort != null) {
                    this.quorumPort(__superior.quorumPort);
                }
                if (__superior.electionPort != null) {
                    this.electionPort(__superior.electionPort);
                }
                if (__superior.joining != null) {
                    this.joining(__superior.joining);
                }
                if (__superior.retired != null) {
                    this.retired(__superior.retired);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder hostname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.hostname = __value;
                this.__uninitialized.remove("hostname");
                return this;
            }

            public Builder clientPort(int __value) {
                this.clientPort = __value;
                return this;
            }

            private Builder clientPort(String __value) {
                return this.clientPort(Integer.valueOf(__value));
            }

            public Builder quorumPort(int __value) {
                this.quorumPort = __value;
                return this;
            }

            private Builder quorumPort(String __value) {
                return this.quorumPort(Integer.valueOf(__value));
            }

            public Builder electionPort(int __value) {
                this.electionPort = __value;
                return this;
            }

            private Builder electionPort(String __value) {
                return this.electionPort(Integer.valueOf(__value));
            }

            public Builder joining(boolean __value) {
                this.joining = __value;
                return this;
            }

            private Builder joining(String __value) {
                return this.joining(Boolean.valueOf(__value));
            }

            public Builder retired(boolean __value) {
                this.retired = __value;
                return this;
            }

            private Builder retired(String __value) {
                return this.retired(Boolean.valueOf(__value));
            }

            public Server build() {
                return new Server(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

