/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class AttributesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "2f1fe4e3cf48edc1514b4e1fa9f70e34";
    public static final String CONFIG_DEF_NAME = "attributes";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "attribute[].name string", "attribute[].datatype enum { STRING, BOOL, UINT2, UINT4, INT8, INT16, INT32, INT64, FLOAT16, FLOAT, DOUBLE, PREDICATE, TENSOR, REFERENCE, RAW, NONE } default=NONE", "attribute[].collectiontype enum { SINGLE, ARRAY, WEIGHTEDSET } default=SINGLE", "attribute[].dictionary.type enum { BTREE, HASH, BTREE_AND_HASH } default = BTREE", "attribute[].dictionary.match enum { CASE_SENSITIVE, CASE_INSENSITIVE, CASED, UNCASED } default=UNCASED", "attribute[].match enum { CASED, UNCASED } default=UNCASED", "attribute[].removeifzero bool default=false", "attribute[].createifnonexistent bool default=false", "attribute[].fastsearch bool default=false", "attribute[].paged bool default=false", "attribute[].ismutable bool default=false", "attribute[].sortascending bool default=true", "attribute[].sortfunction enum { RAW, LOWERCASE, UCA } default=UCA", "attribute[].sortstrength enum { PRIMARY, SECONDARY, TERTIARY, QUATERNARY, IDENTICAL } default=PRIMARY", "attribute[].sortlocale string default=\"\"", "attribute[].enableonlybitvector bool default=false", "attribute[].fastaccess bool default=false", "attribute[].arity int default=8", "attribute[].lowerbound long default=-9223372036854775808", "attribute[].upperbound long default=9223372036854775807", "attribute[].densepostinglistthreshold double default=0.40", "attribute[].tensortype string default=\"\"", "attribute[].imported bool default=false", "attribute[].maxuncommittedmemory long default=130000", "attribute[].distancemetric enum { EUCLIDEAN, ANGULAR, GEODEGREES, INNERPRODUCT, HAMMING, PRENORMALIZED_ANGULAR, DOTPRODUCT } default=EUCLIDEAN", "attribute[].index.hnsw.enabled bool default=false", "attribute[].index.hnsw.maxlinkspernode int default=16", "attribute[].index.hnsw.neighborstoexploreatinsert int default=200", "attribute[].index.hnsw.multithreadedindexing bool default=true"};
    private final InnerNodeVector<Attribute> attribute;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public AttributesConfig(Builder builder) {
        this(builder, true);
    }

    private AttributesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for attributes must be initialized: " + builder.__uninitialized);
        }
        this.attribute = Attribute.createVector(builder.attribute);
    }

    public List<Attribute> attribute() {
        return this.attribute;
    }

    public Attribute attribute(int i) {
        return (Attribute)((Object)this.attribute.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(AttributesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Attribute.Builder> attribute = new ArrayList<Attribute.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(AttributesConfig config) {
            for (Attribute a : config.attribute()) {
                this.attribute(new Attribute.Builder(a));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.attribute.isEmpty()) {
                this.attribute.addAll(__superior.attribute);
            }
            return this;
        }

        public Builder attribute(Attribute.Builder __builder) {
            this.attribute.add(__builder);
            return this;
        }

        public Builder attribute(Consumer<Attribute.Builder> __func) {
            Attribute.Builder __inner = new Attribute.Builder();
            __func.accept(__inner);
            this.attribute.add(__inner);
            return this;
        }

        public Builder attribute(List<Attribute.Builder> __builders) {
            this.attribute = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return AttributesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return AttributesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return AttributesConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public AttributesConfig build() {
            return new AttributesConfig(this);
        }
    }

    public static final class Attribute
    extends InnerNode {
        private final StringNode name;
        private final Datatype datatype;
        private final Collectiontype collectiontype;
        private final Dictionary dictionary;
        private final Match match;
        private final BooleanNode removeifzero;
        private final BooleanNode createifnonexistent;
        private final BooleanNode fastsearch;
        private final BooleanNode paged;
        private final BooleanNode ismutable;
        private final BooleanNode sortascending;
        private final Sortfunction sortfunction;
        private final Sortstrength sortstrength;
        private final StringNode sortlocale;
        private final BooleanNode enableonlybitvector;
        private final BooleanNode fastaccess;
        private final IntegerNode arity;
        private final LongNode lowerbound;
        private final LongNode upperbound;
        private final DoubleNode densepostinglistthreshold;
        private final StringNode tensortype;
        private final BooleanNode imported;
        private final LongNode maxuncommittedmemory;
        private final Distancemetric distancemetric;
        private final Index index;

        public Attribute(Builder builder) {
            this(builder, true);
        }

        private Attribute(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for attributes.attribute[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.datatype = builder.datatype == null ? new Datatype(Datatype.NONE) : new Datatype(builder.datatype);
            this.collectiontype = builder.collectiontype == null ? new Collectiontype(Collectiontype.SINGLE) : new Collectiontype(builder.collectiontype);
            this.dictionary = new Dictionary(builder.dictionary, throwIfUninitialized);
            this.match = builder.match == null ? new Match(Match.UNCASED) : new Match(builder.match);
            this.removeifzero = builder.removeifzero == null ? new BooleanNode(false) : new BooleanNode(builder.removeifzero.booleanValue());
            this.createifnonexistent = builder.createifnonexistent == null ? new BooleanNode(false) : new BooleanNode(builder.createifnonexistent.booleanValue());
            this.fastsearch = builder.fastsearch == null ? new BooleanNode(false) : new BooleanNode(builder.fastsearch.booleanValue());
            this.paged = builder.paged == null ? new BooleanNode(false) : new BooleanNode(builder.paged.booleanValue());
            this.ismutable = builder.ismutable == null ? new BooleanNode(false) : new BooleanNode(builder.ismutable.booleanValue());
            this.sortascending = builder.sortascending == null ? new BooleanNode(true) : new BooleanNode(builder.sortascending.booleanValue());
            this.sortfunction = builder.sortfunction == null ? new Sortfunction(Sortfunction.UCA) : new Sortfunction(builder.sortfunction);
            this.sortstrength = builder.sortstrength == null ? new Sortstrength(Sortstrength.PRIMARY) : new Sortstrength(builder.sortstrength);
            this.sortlocale = builder.sortlocale == null ? new StringNode("") : new StringNode(builder.sortlocale);
            this.enableonlybitvector = builder.enableonlybitvector == null ? new BooleanNode(false) : new BooleanNode(builder.enableonlybitvector.booleanValue());
            this.fastaccess = builder.fastaccess == null ? new BooleanNode(false) : new BooleanNode(builder.fastaccess.booleanValue());
            this.arity = builder.arity == null ? new IntegerNode(8) : new IntegerNode(builder.arity.intValue());
            this.lowerbound = builder.lowerbound == null ? new LongNode(Long.MIN_VALUE) : new LongNode(builder.lowerbound.longValue());
            this.upperbound = builder.upperbound == null ? new LongNode(Long.MAX_VALUE) : new LongNode(builder.upperbound.longValue());
            this.densepostinglistthreshold = builder.densepostinglistthreshold == null ? new DoubleNode(0.4) : new DoubleNode(builder.densepostinglistthreshold.doubleValue());
            this.tensortype = builder.tensortype == null ? new StringNode("") : new StringNode(builder.tensortype);
            this.imported = builder.imported == null ? new BooleanNode(false) : new BooleanNode(builder.imported.booleanValue());
            this.maxuncommittedmemory = builder.maxuncommittedmemory == null ? new LongNode(130000L) : new LongNode(builder.maxuncommittedmemory.longValue());
            this.distancemetric = builder.distancemetric == null ? new Distancemetric(Distancemetric.EUCLIDEAN) : new Distancemetric(builder.distancemetric);
            this.index = new Index(builder.index, throwIfUninitialized);
        }

        public String name() {
            return this.name.value();
        }

        public Datatype.Enum datatype() {
            return (Datatype.Enum)((Object)this.datatype.value());
        }

        public Collectiontype.Enum collectiontype() {
            return (Collectiontype.Enum)((Object)this.collectiontype.value());
        }

        public Dictionary dictionary() {
            return this.dictionary;
        }

        public Match.Enum match() {
            return (Match.Enum)((Object)this.match.value());
        }

        public boolean removeifzero() {
            return this.removeifzero.value();
        }

        public boolean createifnonexistent() {
            return this.createifnonexistent.value();
        }

        public boolean fastsearch() {
            return this.fastsearch.value();
        }

        public boolean paged() {
            return this.paged.value();
        }

        public boolean ismutable() {
            return this.ismutable.value();
        }

        public boolean sortascending() {
            return this.sortascending.value();
        }

        public Sortfunction.Enum sortfunction() {
            return (Sortfunction.Enum)((Object)this.sortfunction.value());
        }

        public Sortstrength.Enum sortstrength() {
            return (Sortstrength.Enum)((Object)this.sortstrength.value());
        }

        public String sortlocale() {
            return this.sortlocale.value();
        }

        public boolean enableonlybitvector() {
            return this.enableonlybitvector.value();
        }

        public boolean fastaccess() {
            return this.fastaccess.value();
        }

        public int arity() {
            return this.arity.value();
        }

        public long lowerbound() {
            return this.lowerbound.value();
        }

        public long upperbound() {
            return this.upperbound.value();
        }

        public double densepostinglistthreshold() {
            return this.densepostinglistthreshold.value();
        }

        public String tensortype() {
            return this.tensortype.value();
        }

        public boolean imported() {
            return this.imported.value();
        }

        public long maxuncommittedmemory() {
            return this.maxuncommittedmemory.value();
        }

        public Distancemetric.Enum distancemetric() {
            return (Distancemetric.Enum)((Object)this.distancemetric.value());
        }

        public Index index() {
            return this.index;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
            return changes;
        }

        private static InnerNodeVector<Attribute> createVector(List<Builder> builders) {
            ArrayList<Attribute> elems = new ArrayList<Attribute>();
            for (Builder b : builders) {
                elems.add(new Attribute(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
            private String name = null;
            private Datatype.Enum datatype = null;
            private Collectiontype.Enum collectiontype = null;
            public Dictionary.Builder dictionary = new Dictionary.Builder();
            private Match.Enum match = null;
            private Boolean removeifzero = null;
            private Boolean createifnonexistent = null;
            private Boolean fastsearch = null;
            private Boolean paged = null;
            private Boolean ismutable = null;
            private Boolean sortascending = null;
            private Sortfunction.Enum sortfunction = null;
            private Sortstrength.Enum sortstrength = null;
            private String sortlocale = null;
            private Boolean enableonlybitvector = null;
            private Boolean fastaccess = null;
            private Integer arity = null;
            private Long lowerbound = null;
            private Long upperbound = null;
            private Double densepostinglistthreshold = null;
            private String tensortype = null;
            private Boolean imported = null;
            private Long maxuncommittedmemory = null;
            private Distancemetric.Enum distancemetric = null;
            public Index.Builder index = new Index.Builder();

            public Builder() {
            }

            public Builder(Attribute config) {
                this.name(config.name());
                this.datatype(config.datatype());
                this.collectiontype(config.collectiontype());
                this.dictionary(new Dictionary.Builder(config.dictionary()));
                this.match(config.match());
                this.removeifzero(config.removeifzero());
                this.createifnonexistent(config.createifnonexistent());
                this.fastsearch(config.fastsearch());
                this.paged(config.paged());
                this.ismutable(config.ismutable());
                this.sortascending(config.sortascending());
                this.sortfunction(config.sortfunction());
                this.sortstrength(config.sortstrength());
                this.sortlocale(config.sortlocale());
                this.enableonlybitvector(config.enableonlybitvector());
                this.fastaccess(config.fastaccess());
                this.arity(config.arity());
                this.lowerbound(config.lowerbound());
                this.upperbound(config.upperbound());
                this.densepostinglistthreshold(config.densepostinglistthreshold());
                this.tensortype(config.tensortype());
                this.imported(config.imported());
                this.maxuncommittedmemory(config.maxuncommittedmemory());
                this.distancemetric(config.distancemetric());
                this.index(new Index.Builder(config.index()));
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.datatype != null) {
                    this.datatype(__superior.datatype);
                }
                if (__superior.collectiontype != null) {
                    this.collectiontype(__superior.collectiontype);
                }
                this.dictionary(this.dictionary.override(__superior.dictionary));
                if (__superior.match != null) {
                    this.match(__superior.match);
                }
                if (__superior.removeifzero != null) {
                    this.removeifzero(__superior.removeifzero);
                }
                if (__superior.createifnonexistent != null) {
                    this.createifnonexistent(__superior.createifnonexistent);
                }
                if (__superior.fastsearch != null) {
                    this.fastsearch(__superior.fastsearch);
                }
                if (__superior.paged != null) {
                    this.paged(__superior.paged);
                }
                if (__superior.ismutable != null) {
                    this.ismutable(__superior.ismutable);
                }
                if (__superior.sortascending != null) {
                    this.sortascending(__superior.sortascending);
                }
                if (__superior.sortfunction != null) {
                    this.sortfunction(__superior.sortfunction);
                }
                if (__superior.sortstrength != null) {
                    this.sortstrength(__superior.sortstrength);
                }
                if (__superior.sortlocale != null) {
                    this.sortlocale(__superior.sortlocale);
                }
                if (__superior.enableonlybitvector != null) {
                    this.enableonlybitvector(__superior.enableonlybitvector);
                }
                if (__superior.fastaccess != null) {
                    this.fastaccess(__superior.fastaccess);
                }
                if (__superior.arity != null) {
                    this.arity(__superior.arity);
                }
                if (__superior.lowerbound != null) {
                    this.lowerbound(__superior.lowerbound);
                }
                if (__superior.upperbound != null) {
                    this.upperbound(__superior.upperbound);
                }
                if (__superior.densepostinglistthreshold != null) {
                    this.densepostinglistthreshold(__superior.densepostinglistthreshold);
                }
                if (__superior.tensortype != null) {
                    this.tensortype(__superior.tensortype);
                }
                if (__superior.imported != null) {
                    this.imported(__superior.imported);
                }
                if (__superior.maxuncommittedmemory != null) {
                    this.maxuncommittedmemory(__superior.maxuncommittedmemory);
                }
                if (__superior.distancemetric != null) {
                    this.distancemetric(__superior.distancemetric);
                }
                this.index(this.index.override(__superior.index));
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder datatype(Datatype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.datatype = __value;
                return this;
            }

            private Builder datatype(String __value) {
                return this.datatype(Datatype.Enum.valueOf(__value));
            }

            public Builder collectiontype(Collectiontype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.collectiontype = __value;
                return this;
            }

            private Builder collectiontype(String __value) {
                return this.collectiontype(Collectiontype.Enum.valueOf(__value));
            }

            public Builder dictionary(Dictionary.Builder __builder) {
                this.dictionary = __builder;
                return this;
            }

            public Builder dictionary(Consumer<Dictionary.Builder> __func) {
                Dictionary.Builder __inner = new Dictionary.Builder();
                __func.accept(__inner);
                this.dictionary = __inner;
                return this;
            }

            public Builder match(Match.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.match = __value;
                return this;
            }

            private Builder match(String __value) {
                return this.match(Match.Enum.valueOf(__value));
            }

            public Builder removeifzero(boolean __value) {
                this.removeifzero = __value;
                return this;
            }

            private Builder removeifzero(String __value) {
                return this.removeifzero(Boolean.valueOf(__value));
            }

            public Builder createifnonexistent(boolean __value) {
                this.createifnonexistent = __value;
                return this;
            }

            private Builder createifnonexistent(String __value) {
                return this.createifnonexistent(Boolean.valueOf(__value));
            }

            public Builder fastsearch(boolean __value) {
                this.fastsearch = __value;
                return this;
            }

            private Builder fastsearch(String __value) {
                return this.fastsearch(Boolean.valueOf(__value));
            }

            public Builder paged(boolean __value) {
                this.paged = __value;
                return this;
            }

            private Builder paged(String __value) {
                return this.paged(Boolean.valueOf(__value));
            }

            public Builder ismutable(boolean __value) {
                this.ismutable = __value;
                return this;
            }

            private Builder ismutable(String __value) {
                return this.ismutable(Boolean.valueOf(__value));
            }

            public Builder sortascending(boolean __value) {
                this.sortascending = __value;
                return this;
            }

            private Builder sortascending(String __value) {
                return this.sortascending(Boolean.valueOf(__value));
            }

            public Builder sortfunction(Sortfunction.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.sortfunction = __value;
                return this;
            }

            private Builder sortfunction(String __value) {
                return this.sortfunction(Sortfunction.Enum.valueOf(__value));
            }

            public Builder sortstrength(Sortstrength.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.sortstrength = __value;
                return this;
            }

            private Builder sortstrength(String __value) {
                return this.sortstrength(Sortstrength.Enum.valueOf(__value));
            }

            public Builder sortlocale(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.sortlocale = __value;
                return this;
            }

            public Builder enableonlybitvector(boolean __value) {
                this.enableonlybitvector = __value;
                return this;
            }

            private Builder enableonlybitvector(String __value) {
                return this.enableonlybitvector(Boolean.valueOf(__value));
            }

            public Builder fastaccess(boolean __value) {
                this.fastaccess = __value;
                return this;
            }

            private Builder fastaccess(String __value) {
                return this.fastaccess(Boolean.valueOf(__value));
            }

            public Builder arity(int __value) {
                this.arity = __value;
                return this;
            }

            private Builder arity(String __value) {
                return this.arity(Integer.valueOf(__value));
            }

            public Builder lowerbound(long __value) {
                this.lowerbound = __value;
                return this;
            }

            private Builder lowerbound(String __value) {
                return this.lowerbound(Long.valueOf(__value));
            }

            public Builder upperbound(long __value) {
                this.upperbound = __value;
                return this;
            }

            private Builder upperbound(String __value) {
                return this.upperbound(Long.valueOf(__value));
            }

            public Builder densepostinglistthreshold(double __value) {
                this.densepostinglistthreshold = __value;
                return this;
            }

            private Builder densepostinglistthreshold(String __value) {
                return this.densepostinglistthreshold(Double.valueOf(__value));
            }

            public Builder tensortype(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.tensortype = __value;
                return this;
            }

            public Builder imported(boolean __value) {
                this.imported = __value;
                return this;
            }

            private Builder imported(String __value) {
                return this.imported(Boolean.valueOf(__value));
            }

            public Builder maxuncommittedmemory(long __value) {
                this.maxuncommittedmemory = __value;
                return this;
            }

            private Builder maxuncommittedmemory(String __value) {
                return this.maxuncommittedmemory(Long.valueOf(__value));
            }

            public Builder distancemetric(Distancemetric.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.distancemetric = __value;
                return this;
            }

            private Builder distancemetric(String __value) {
                return this.distancemetric(Distancemetric.Enum.valueOf(__value));
            }

            public Builder index(Index.Builder __builder) {
                this.index = __builder;
                return this;
            }

            public Builder index(Consumer<Index.Builder> __func) {
                Index.Builder __inner = new Index.Builder();
                __func.accept(__inner);
                this.index = __inner;
                return this;
            }

            public Attribute build() {
                return new Attribute(this);
            }
        }

        public static final class Datatype
        extends EnumNode<Enum> {
            public static final Enum STRING = Enum.STRING;
            public static final Enum BOOL = Enum.BOOL;
            public static final Enum UINT2 = Enum.UINT2;
            public static final Enum UINT4 = Enum.UINT4;
            public static final Enum INT8 = Enum.INT8;
            public static final Enum INT16 = Enum.INT16;
            public static final Enum INT32 = Enum.INT32;
            public static final Enum INT64 = Enum.INT64;
            public static final Enum FLOAT16 = Enum.FLOAT16;
            public static final Enum FLOAT = Enum.FLOAT;
            public static final Enum DOUBLE = Enum.DOUBLE;
            public static final Enum PREDICATE = Enum.PREDICATE;
            public static final Enum TENSOR = Enum.TENSOR;
            public static final Enum REFERENCE = Enum.REFERENCE;
            public static final Enum RAW = Enum.RAW;
            public static final Enum NONE = Enum.NONE;

            public Datatype() {
                this.value = null;
            }

            public Datatype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                STRING,
                BOOL,
                UINT2,
                UINT4,
                INT8,
                INT16,
                INT32,
                INT64,
                FLOAT16,
                FLOAT,
                DOUBLE,
                PREDICATE,
                TENSOR,
                REFERENCE,
                RAW,
                NONE;

            }
        }

        public static final class Collectiontype
        extends EnumNode<Enum> {
            public static final Enum SINGLE = Enum.SINGLE;
            public static final Enum ARRAY = Enum.ARRAY;
            public static final Enum WEIGHTEDSET = Enum.WEIGHTEDSET;

            public Collectiontype() {
                this.value = null;
            }

            public Collectiontype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                SINGLE,
                ARRAY,
                WEIGHTEDSET;

            }
        }

        public static final class Dictionary
        extends InnerNode {
            private final Type type;
            private final Match match;

            public Dictionary(Builder builder) {
                this(builder, true);
            }

            private Dictionary(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for attributes.attribute[].dictionary must be initialized: " + builder.__uninitialized);
                }
                this.type = builder.type == null ? new Type(Type.BTREE) : new Type(builder.type);
                this.match = builder.match == null ? new Match(Match.UNCASED) : new Match(builder.match);
            }

            public Type.Enum type() {
                return (Type.Enum)((Object)this.type.value());
            }

            public Match.Enum match() {
                return (Match.Enum)((Object)this.match.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Dictionary newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("dictionary");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Type.Enum type = null;
                private Match.Enum match = null;

                public Builder() {
                }

                public Builder(Dictionary config) {
                    this.type(config.type());
                    this.match(config.match());
                }

                private Builder override(Builder __superior) {
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    if (__superior.match != null) {
                        this.match(__superior.match);
                    }
                    return this;
                }

                public Builder type(Type.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    return this;
                }

                private Builder type(String __value) {
                    return this.type(Type.Enum.valueOf(__value));
                }

                public Builder match(Match.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.match = __value;
                    return this;
                }

                private Builder match(String __value) {
                    return this.match(Match.Enum.valueOf(__value));
                }

                public Dictionary build() {
                    return new Dictionary(this);
                }
            }

            public static final class Type
            extends EnumNode<Enum> {
                public static final Enum BTREE = Enum.BTREE;
                public static final Enum HASH = Enum.HASH;
                public static final Enum BTREE_AND_HASH = Enum.BTREE_AND_HASH;

                public Type() {
                    this.value = null;
                }

                public Type(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    BTREE,
                    HASH,
                    BTREE_AND_HASH;

                }
            }

            public static final class Match
            extends EnumNode<Enum> {
                public static final Enum CASE_SENSITIVE = Enum.CASE_SENSITIVE;
                public static final Enum CASE_INSENSITIVE = Enum.CASE_INSENSITIVE;
                public static final Enum CASED = Enum.CASED;
                public static final Enum UNCASED = Enum.UNCASED;

                public Match() {
                    this.value = null;
                }

                public Match(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    CASE_SENSITIVE,
                    CASE_INSENSITIVE,
                    CASED,
                    UNCASED;

                }
            }
        }

        public static final class Match
        extends EnumNode<Enum> {
            public static final Enum CASED = Enum.CASED;
            public static final Enum UNCASED = Enum.UNCASED;

            public Match() {
                this.value = null;
            }

            public Match(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                CASED,
                UNCASED;

            }
        }

        public static final class Sortfunction
        extends EnumNode<Enum> {
            public static final Enum RAW = Enum.RAW;
            public static final Enum LOWERCASE = Enum.LOWERCASE;
            public static final Enum UCA = Enum.UCA;

            public Sortfunction() {
                this.value = null;
            }

            public Sortfunction(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                RAW,
                LOWERCASE,
                UCA;

            }
        }

        public static final class Sortstrength
        extends EnumNode<Enum> {
            public static final Enum PRIMARY = Enum.PRIMARY;
            public static final Enum SECONDARY = Enum.SECONDARY;
            public static final Enum TERTIARY = Enum.TERTIARY;
            public static final Enum QUATERNARY = Enum.QUATERNARY;
            public static final Enum IDENTICAL = Enum.IDENTICAL;

            public Sortstrength() {
                this.value = null;
            }

            public Sortstrength(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                PRIMARY,
                SECONDARY,
                TERTIARY,
                QUATERNARY,
                IDENTICAL;

            }
        }

        public static final class Distancemetric
        extends EnumNode<Enum> {
            public static final Enum EUCLIDEAN = Enum.EUCLIDEAN;
            public static final Enum ANGULAR = Enum.ANGULAR;
            public static final Enum GEODEGREES = Enum.GEODEGREES;
            public static final Enum INNERPRODUCT = Enum.INNERPRODUCT;
            public static final Enum HAMMING = Enum.HAMMING;
            public static final Enum PRENORMALIZED_ANGULAR = Enum.PRENORMALIZED_ANGULAR;
            public static final Enum DOTPRODUCT = Enum.DOTPRODUCT;

            public Distancemetric() {
                this.value = null;
            }

            public Distancemetric(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                EUCLIDEAN,
                ANGULAR,
                GEODEGREES,
                INNERPRODUCT,
                HAMMING,
                PRENORMALIZED_ANGULAR,
                DOTPRODUCT;

            }
        }

        public static final class Index
        extends InnerNode {
            private final Hnsw hnsw;

            public Index(Builder builder) {
                this(builder, true);
            }

            private Index(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for attributes.attribute[].index must be initialized: " + builder.__uninitialized);
                }
                this.hnsw = new Hnsw(builder.hnsw, throwIfUninitialized);
            }

            public Hnsw hnsw() {
                return this.hnsw;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Index newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("index");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public Hnsw.Builder hnsw = new Hnsw.Builder();

                public Builder() {
                }

                public Builder(Index config) {
                    this.hnsw(new Hnsw.Builder(config.hnsw()));
                }

                private Builder override(Builder __superior) {
                    this.hnsw(this.hnsw.override(__superior.hnsw));
                    return this;
                }

                public Builder hnsw(Hnsw.Builder __builder) {
                    this.hnsw = __builder;
                    return this;
                }

                public Builder hnsw(Consumer<Hnsw.Builder> __func) {
                    Hnsw.Builder __inner = new Hnsw.Builder();
                    __func.accept(__inner);
                    this.hnsw = __inner;
                    return this;
                }

                public Index build() {
                    return new Index(this);
                }
            }

            public static final class Hnsw
            extends InnerNode {
                private final BooleanNode enabled;
                private final IntegerNode maxlinkspernode;
                private final IntegerNode neighborstoexploreatinsert;
                private final BooleanNode multithreadedindexing;

                public Hnsw(Builder builder) {
                    this(builder, true);
                }

                private Hnsw(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for attributes.attribute[].index.hnsw must be initialized: " + builder.__uninitialized);
                    }
                    this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
                    this.maxlinkspernode = builder.maxlinkspernode == null ? new IntegerNode(16) : new IntegerNode(builder.maxlinkspernode.intValue());
                    this.neighborstoexploreatinsert = builder.neighborstoexploreatinsert == null ? new IntegerNode(200) : new IntegerNode(builder.neighborstoexploreatinsert.intValue());
                    this.multithreadedindexing = builder.multithreadedindexing == null ? new BooleanNode(true) : new BooleanNode(builder.multithreadedindexing.booleanValue());
                }

                public boolean enabled() {
                    return this.enabled.value();
                }

                public int maxlinkspernode() {
                    return this.maxlinkspernode.value();
                }

                public int neighborstoexploreatinsert() {
                    return this.neighborstoexploreatinsert.value();
                }

                public boolean multithreadedindexing() {
                    return this.multithreadedindexing.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Hnsw newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("hnsw");
                    return changes;
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Boolean enabled = null;
                    private Integer maxlinkspernode = null;
                    private Integer neighborstoexploreatinsert = null;
                    private Boolean multithreadedindexing = null;

                    public Builder() {
                    }

                    public Builder(Hnsw config) {
                        this.enabled(config.enabled());
                        this.maxlinkspernode(config.maxlinkspernode());
                        this.neighborstoexploreatinsert(config.neighborstoexploreatinsert());
                        this.multithreadedindexing(config.multithreadedindexing());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.enabled != null) {
                            this.enabled(__superior.enabled);
                        }
                        if (__superior.maxlinkspernode != null) {
                            this.maxlinkspernode(__superior.maxlinkspernode);
                        }
                        if (__superior.neighborstoexploreatinsert != null) {
                            this.neighborstoexploreatinsert(__superior.neighborstoexploreatinsert);
                        }
                        if (__superior.multithreadedindexing != null) {
                            this.multithreadedindexing(__superior.multithreadedindexing);
                        }
                        return this;
                    }

                    public Builder enabled(boolean __value) {
                        this.enabled = __value;
                        return this;
                    }

                    private Builder enabled(String __value) {
                        return this.enabled(Boolean.valueOf(__value));
                    }

                    public Builder maxlinkspernode(int __value) {
                        this.maxlinkspernode = __value;
                        return this;
                    }

                    private Builder maxlinkspernode(String __value) {
                        return this.maxlinkspernode(Integer.valueOf(__value));
                    }

                    public Builder neighborstoexploreatinsert(int __value) {
                        this.neighborstoexploreatinsert = __value;
                        return this;
                    }

                    private Builder neighborstoexploreatinsert(String __value) {
                        return this.neighborstoexploreatinsert(Integer.valueOf(__value));
                    }

                    public Builder multithreadedindexing(boolean __value) {
                        this.multithreadedindexing = __value;
                        return this;
                    }

                    private Builder multithreadedindexing(String __value) {
                        return this.multithreadedindexing(Boolean.valueOf(__value));
                    }

                    public Hnsw build() {
                        return new Hnsw(this);
                    }
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

