/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SlobroksConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "4d375b91d30ffdbbe45de52ee5aa9fe0";
    public static final String CONFIG_DEF_NAME = "slobroks";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "slobrok[].connectionspec string restart"};
    private final InnerNodeVector<Slobrok> slobrok;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SlobroksConfig(Builder builder) {
        this(builder, true);
    }

    private SlobroksConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for slobroks must be initialized: " + builder.__uninitialized);
        }
        this.slobrok = Slobrok.createVector(builder.slobrok);
    }

    public List<Slobrok> slobrok() {
        return this.slobrok;
    }

    public Slobrok slobrok(int i) {
        return (Slobrok)((Object)this.slobrok.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SlobroksConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compareArray(this.slobrok, newConfig.slobrok, "slobrok", "", (a, b) -> ((Slobrok)a).getChangesRequiringRestart((Slobrok)b));
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Slobrok.Builder> slobrok = new ArrayList<Slobrok.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SlobroksConfig config) {
            for (Slobrok s : config.slobrok()) {
                this.slobrok(new Slobrok.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.slobrok.isEmpty()) {
                this.slobrok.addAll(__superior.slobrok);
            }
            return this;
        }

        public Builder slobrok(Slobrok.Builder __builder) {
            this.slobrok.add(__builder);
            return this;
        }

        public Builder slobrok(Consumer<Slobrok.Builder> __func) {
            Slobrok.Builder __inner = new Slobrok.Builder();
            __func.accept(__inner);
            this.slobrok.add(__inner);
            return this;
        }

        public Builder slobrok(List<Slobrok.Builder> __builders) {
            this.slobrok = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SlobroksConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SlobroksConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SlobroksConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SlobroksConfig build() {
            return new SlobroksConfig(this);
        }
    }

    public static final class Slobrok
    extends InnerNode {
        private final StringNode connectionspec;

        public Slobrok(Builder builder) {
            this(builder, true);
        }

        private Slobrok(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for slobroks.slobrok[] must be initialized: " + builder.__uninitialized);
            }
            this.connectionspec = builder.connectionspec == null ? new StringNode() : new StringNode(builder.connectionspec);
        }

        public String connectionspec() {
            return this.connectionspec.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Slobrok newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("slobrok");
            changes.compare((Node)this.connectionspec, (Node)newConfig.connectionspec, "connectionspec", "Changes to this config requires restart\n\nThe connectionspec for a slobrok is used for connecting to it using\nthe FNET Remote Tools framework. It is normally on the form\ntcp/hostname:portnumber where hostname is the same name returned by\ngethostname() on the machine. This string is also used by the\nactual slobrok to figure out which port it should listen to.\n");
            return changes;
        }

        private static InnerNodeVector<Slobrok> createVector(List<Builder> builders) {
            ArrayList<Slobrok> elems = new ArrayList<Slobrok>();
            for (Builder b : builders) {
                elems.add(new Slobrok(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("connectionspec"));
            private String connectionspec = null;

            public Builder() {
            }

            public Builder(Slobrok config) {
                this.connectionspec(config.connectionspec());
            }

            private Builder override(Builder __superior) {
                if (__superior.connectionspec != null) {
                    this.connectionspec(__superior.connectionspec);
                }
                return this;
            }

            public Builder connectionspec(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.connectionspec = __value;
                this.__uninitialized.remove("connectionspec");
                return this;
            }

            public Slobrok build() {
                return new Slobrok(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

