/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.embedding;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ColBertEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "38e1992daf465384b36674208d96f9fc";
    public static final String CONFIG_DEF_NAME = "col-bert-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "embedding";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=embedding", "tokenizerPath model", "transformerModel model", "maxQueryTokens int default=32", "maxDocumentTokens int default=512", "transformerMaxTokens int default=512", "transformerInputIds string default=input_ids", "transformerAttentionMask string default=attention_mask", "transformerStartSequenceToken int default=101", "transformerEndSequenceToken int default=102", "transformerMaskToken int default=103", "transformerOutput string default=contextual", "transformerExecutionMode enum { parallel, sequential } default=sequential", "transformerInterOpThreads int default=1", "transformerIntraOpThreads int default=-4", "transformerGpuDevice int default=0"};
    private final ModelNode tokenizerPath;
    private final ModelNode transformerModel;
    private final IntegerNode maxQueryTokens;
    private final IntegerNode maxDocumentTokens;
    private final IntegerNode transformerMaxTokens;
    private final StringNode transformerInputIds;
    private final StringNode transformerAttentionMask;
    private final IntegerNode transformerStartSequenceToken;
    private final IntegerNode transformerEndSequenceToken;
    private final IntegerNode transformerMaskToken;
    private final StringNode transformerOutput;
    private final TransformerExecutionMode transformerExecutionMode;
    private final IntegerNode transformerInterOpThreads;
    private final IntegerNode transformerIntraOpThreads;
    private final IntegerNode transformerGpuDevice;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ColBertEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private ColBertEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for col-bert-embedder must be initialized: " + builder.__uninitialized);
        }
        this.tokenizerPath = builder.tokenizerPath == null ? new ModelNode() : new ModelNode(builder.tokenizerPath);
        this.transformerModel = builder.transformerModel == null ? new ModelNode() : new ModelNode(builder.transformerModel);
        this.maxQueryTokens = builder.maxQueryTokens == null ? new IntegerNode(32) : new IntegerNode(builder.maxQueryTokens.intValue());
        this.maxDocumentTokens = builder.maxDocumentTokens == null ? new IntegerNode(512) : new IntegerNode(builder.maxDocumentTokens.intValue());
        this.transformerMaxTokens = builder.transformerMaxTokens == null ? new IntegerNode(512) : new IntegerNode(builder.transformerMaxTokens.intValue());
        this.transformerInputIds = builder.transformerInputIds == null ? new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
        this.transformerAttentionMask = builder.transformerAttentionMask == null ? new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
        this.transformerStartSequenceToken = builder.transformerStartSequenceToken == null ? new IntegerNode(101) : new IntegerNode(builder.transformerStartSequenceToken.intValue());
        this.transformerEndSequenceToken = builder.transformerEndSequenceToken == null ? new IntegerNode(102) : new IntegerNode(builder.transformerEndSequenceToken.intValue());
        this.transformerMaskToken = builder.transformerMaskToken == null ? new IntegerNode(103) : new IntegerNode(builder.transformerMaskToken.intValue());
        this.transformerOutput = builder.transformerOutput == null ? new StringNode("contextual") : new StringNode(builder.transformerOutput);
        this.transformerExecutionMode = builder.transformerExecutionMode == null ? new TransformerExecutionMode(TransformerExecutionMode.sequential) : new TransformerExecutionMode(builder.transformerExecutionMode);
        this.transformerInterOpThreads = builder.transformerInterOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.transformerInterOpThreads.intValue());
        this.transformerIntraOpThreads = builder.transformerIntraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.transformerIntraOpThreads.intValue());
        this.transformerGpuDevice = builder.transformerGpuDevice == null ? new IntegerNode(0) : new IntegerNode(builder.transformerGpuDevice.intValue());
    }

    public Path tokenizerPath() {
        return (Path)this.tokenizerPath.value();
    }

    public Path transformerModel() {
        return (Path)this.transformerModel.value();
    }

    public int maxQueryTokens() {
        return this.maxQueryTokens.value();
    }

    public int maxDocumentTokens() {
        return this.maxDocumentTokens.value();
    }

    public int transformerMaxTokens() {
        return this.transformerMaxTokens.value();
    }

    public String transformerInputIds() {
        return this.transformerInputIds.value();
    }

    public String transformerAttentionMask() {
        return this.transformerAttentionMask.value();
    }

    public int transformerStartSequenceToken() {
        return this.transformerStartSequenceToken.value();
    }

    public int transformerEndSequenceToken() {
        return this.transformerEndSequenceToken.value();
    }

    public int transformerMaskToken() {
        return this.transformerMaskToken.value();
    }

    public String transformerOutput() {
        return this.transformerOutput.value();
    }

    public TransformerExecutionMode.Enum transformerExecutionMode() {
        return (TransformerExecutionMode.Enum)((Object)this.transformerExecutionMode.value());
    }

    public int transformerInterOpThreads() {
        return this.transformerInterOpThreads.value();
    }

    public int transformerIntraOpThreads() {
        return this.transformerIntraOpThreads.value();
    }

    public int transformerGpuDevice() {
        return this.transformerGpuDevice.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ColBertEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("tokenizerPath", "transformerModel"));
        private ModelReference tokenizerPath = null;
        private ModelReference transformerModel = null;
        private Integer maxQueryTokens = null;
        private Integer maxDocumentTokens = null;
        private Integer transformerMaxTokens = null;
        private String transformerInputIds = null;
        private String transformerAttentionMask = null;
        private Integer transformerStartSequenceToken = null;
        private Integer transformerEndSequenceToken = null;
        private Integer transformerMaskToken = null;
        private String transformerOutput = null;
        private TransformerExecutionMode.Enum transformerExecutionMode = null;
        private Integer transformerInterOpThreads = null;
        private Integer transformerIntraOpThreads = null;
        private Integer transformerGpuDevice = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ColBertEmbedderConfig config) {
            this.tokenizerPath(config.tokenizerPath.getModelReference());
            this.transformerModel(config.transformerModel.getModelReference());
            this.maxQueryTokens(config.maxQueryTokens());
            this.maxDocumentTokens(config.maxDocumentTokens());
            this.transformerMaxTokens(config.transformerMaxTokens());
            this.transformerInputIds(config.transformerInputIds());
            this.transformerAttentionMask(config.transformerAttentionMask());
            this.transformerStartSequenceToken(config.transformerStartSequenceToken());
            this.transformerEndSequenceToken(config.transformerEndSequenceToken());
            this.transformerMaskToken(config.transformerMaskToken());
            this.transformerOutput(config.transformerOutput());
            this.transformerExecutionMode(config.transformerExecutionMode());
            this.transformerInterOpThreads(config.transformerInterOpThreads());
            this.transformerIntraOpThreads(config.transformerIntraOpThreads());
            this.transformerGpuDevice(config.transformerGpuDevice());
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenizerPath != null) {
                this.tokenizerPath(__superior.tokenizerPath);
            }
            if (__superior.transformerModel != null) {
                this.transformerModel(__superior.transformerModel);
            }
            if (__superior.maxQueryTokens != null) {
                this.maxQueryTokens(__superior.maxQueryTokens);
            }
            if (__superior.maxDocumentTokens != null) {
                this.maxDocumentTokens(__superior.maxDocumentTokens);
            }
            if (__superior.transformerMaxTokens != null) {
                this.transformerMaxTokens(__superior.transformerMaxTokens);
            }
            if (__superior.transformerInputIds != null) {
                this.transformerInputIds(__superior.transformerInputIds);
            }
            if (__superior.transformerAttentionMask != null) {
                this.transformerAttentionMask(__superior.transformerAttentionMask);
            }
            if (__superior.transformerStartSequenceToken != null) {
                this.transformerStartSequenceToken(__superior.transformerStartSequenceToken);
            }
            if (__superior.transformerEndSequenceToken != null) {
                this.transformerEndSequenceToken(__superior.transformerEndSequenceToken);
            }
            if (__superior.transformerMaskToken != null) {
                this.transformerMaskToken(__superior.transformerMaskToken);
            }
            if (__superior.transformerOutput != null) {
                this.transformerOutput(__superior.transformerOutput);
            }
            if (__superior.transformerExecutionMode != null) {
                this.transformerExecutionMode(__superior.transformerExecutionMode);
            }
            if (__superior.transformerInterOpThreads != null) {
                this.transformerInterOpThreads(__superior.transformerInterOpThreads);
            }
            if (__superior.transformerIntraOpThreads != null) {
                this.transformerIntraOpThreads(__superior.transformerIntraOpThreads);
            }
            if (__superior.transformerGpuDevice != null) {
                this.transformerGpuDevice(__superior.transformerGpuDevice);
            }
            return this;
        }

        public Builder tokenizerPath(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerPath = __value;
            this.__uninitialized.remove("tokenizerPath");
            return this;
        }

        public Builder transformerModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerModel = __value;
            this.__uninitialized.remove("transformerModel");
            return this;
        }

        public Builder maxQueryTokens(int __value) {
            this.maxQueryTokens = __value;
            return this;
        }

        private Builder maxQueryTokens(String __value) {
            return this.maxQueryTokens(Integer.valueOf(__value));
        }

        public Builder maxDocumentTokens(int __value) {
            this.maxDocumentTokens = __value;
            return this;
        }

        private Builder maxDocumentTokens(String __value) {
            return this.maxDocumentTokens(Integer.valueOf(__value));
        }

        public Builder transformerMaxTokens(int __value) {
            this.transformerMaxTokens = __value;
            return this;
        }

        private Builder transformerMaxTokens(String __value) {
            return this.transformerMaxTokens(Integer.valueOf(__value));
        }

        public Builder transformerInputIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerInputIds = __value;
            return this;
        }

        public Builder transformerAttentionMask(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerAttentionMask = __value;
            return this;
        }

        public Builder transformerStartSequenceToken(int __value) {
            this.transformerStartSequenceToken = __value;
            return this;
        }

        private Builder transformerStartSequenceToken(String __value) {
            return this.transformerStartSequenceToken(Integer.valueOf(__value));
        }

        public Builder transformerEndSequenceToken(int __value) {
            this.transformerEndSequenceToken = __value;
            return this;
        }

        private Builder transformerEndSequenceToken(String __value) {
            return this.transformerEndSequenceToken(Integer.valueOf(__value));
        }

        public Builder transformerMaskToken(int __value) {
            this.transformerMaskToken = __value;
            return this;
        }

        private Builder transformerMaskToken(String __value) {
            return this.transformerMaskToken(Integer.valueOf(__value));
        }

        public Builder transformerOutput(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerOutput = __value;
            return this;
        }

        public Builder transformerExecutionMode(TransformerExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerExecutionMode = __value;
            return this;
        }

        private Builder transformerExecutionMode(String __value) {
            return this.transformerExecutionMode(TransformerExecutionMode.Enum.valueOf(__value));
        }

        public Builder transformerInterOpThreads(int __value) {
            this.transformerInterOpThreads = __value;
            return this;
        }

        private Builder transformerInterOpThreads(String __value) {
            return this.transformerInterOpThreads(Integer.valueOf(__value));
        }

        public Builder transformerIntraOpThreads(int __value) {
            this.transformerIntraOpThreads = __value;
            return this;
        }

        private Builder transformerIntraOpThreads(String __value) {
            return this.transformerIntraOpThreads(Integer.valueOf(__value));
        }

        public Builder transformerGpuDevice(int __value) {
            this.transformerGpuDevice = __value;
            return this;
        }

        private Builder transformerGpuDevice(String __value) {
            return this.transformerGpuDevice(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ColBertEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ColBertEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ColBertEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ColBertEmbedderConfig build() {
            return new ColBertEmbedderConfig(this);
        }
    }

    public static final class TransformerExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public TransformerExecutionMode() {
            this.value = null;
        }

        public TransformerExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

