/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ReferenceNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SentinelConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "aa9115ebf63cfc6721f75ada21d7cdfa";
    public static final String CONFIG_DEF_NAME = "sentinel";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "port.telnet int default=19098", "port.rpc int default=19097", "application.tenant string default=\"default\"", "application.name string default=\"default\"", "application.environment string default=\"default\"", "application.instance string default=\"default\"", "application.region string default=\"default\"", "connectivity.minOkPercent int default=50", "connectivity.maxBadCount int default=1", "service[].command string", "service[].environ[].varname string", "service[].environ[].varvalue string", "service[].logctl[].componentSpec string", "service[].logctl[].levelsModSpec string", "service[].preShutdownCommand string default=\"\"", "service[].name string", "service[].autostart bool default=false", "service[].autorestart bool default=true", "service[].id reference", "service[].affinity.cpuSocket int default=-1"};
    private final Port port;
    private final Application application;
    private final Connectivity connectivity;
    private final InnerNodeVector<Service> service;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SentinelConfig(Builder builder) {
        this(builder, true);
    }

    private SentinelConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for sentinel must be initialized: " + builder.__uninitialized);
        }
        this.port = new Port(builder.port, throwIfUninitialized);
        this.application = new Application(builder.application, throwIfUninitialized);
        this.connectivity = new Connectivity(builder.connectivity, throwIfUninitialized);
        this.service = Service.createVector(builder.service);
    }

    public Port port() {
        return this.port;
    }

    public Application application() {
        return this.application;
    }

    public Connectivity connectivity() {
        return this.connectivity;
    }

    public List<Service> service() {
        return this.service;
    }

    public Service service(int i) {
        return (Service)((Object)this.service.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SentinelConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Port.Builder port = new Port.Builder();
        public Application.Builder application = new Application.Builder();
        public Connectivity.Builder connectivity = new Connectivity.Builder();
        public List<Service.Builder> service = new ArrayList<Service.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SentinelConfig config) {
            this.port(new Port.Builder(config.port()));
            this.application(new Application.Builder(config.application()));
            this.connectivity(new Connectivity.Builder(config.connectivity()));
            for (Service s : config.service()) {
                this.service(new Service.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            this.port(this.port.override(__superior.port));
            this.application(this.application.override(__superior.application));
            this.connectivity(this.connectivity.override(__superior.connectivity));
            if (!__superior.service.isEmpty()) {
                this.service.addAll(__superior.service);
            }
            return this;
        }

        public Builder port(Port.Builder __builder) {
            this.port = __builder;
            return this;
        }

        public Builder port(Consumer<Port.Builder> __func) {
            Port.Builder __inner = new Port.Builder();
            __func.accept(__inner);
            this.port = __inner;
            return this;
        }

        public Builder application(Application.Builder __builder) {
            this.application = __builder;
            return this;
        }

        public Builder application(Consumer<Application.Builder> __func) {
            Application.Builder __inner = new Application.Builder();
            __func.accept(__inner);
            this.application = __inner;
            return this;
        }

        public Builder connectivity(Connectivity.Builder __builder) {
            this.connectivity = __builder;
            return this;
        }

        public Builder connectivity(Consumer<Connectivity.Builder> __func) {
            Connectivity.Builder __inner = new Connectivity.Builder();
            __func.accept(__inner);
            this.connectivity = __inner;
            return this;
        }

        public Builder service(Service.Builder __builder) {
            this.service.add(__builder);
            return this;
        }

        public Builder service(Consumer<Service.Builder> __func) {
            Service.Builder __inner = new Service.Builder();
            __func.accept(__inner);
            this.service.add(__inner);
            return this;
        }

        public Builder service(List<Service.Builder> __builders) {
            this.service = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SentinelConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SentinelConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SentinelConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SentinelConfig build() {
            return new SentinelConfig(this);
        }
    }

    public static final class Port
    extends InnerNode {
        private final IntegerNode telnet;
        private final IntegerNode rpc;

        public Port(Builder builder) {
            this(builder, true);
        }

        private Port(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for sentinel.port must be initialized: " + builder.__uninitialized);
            }
            this.telnet = builder.telnet == null ? new IntegerNode(19098) : new IntegerNode(builder.telnet.intValue());
            this.rpc = builder.rpc == null ? new IntegerNode(19097) : new IntegerNode(builder.rpc.intValue());
        }

        public int telnet() {
            return this.telnet.value();
        }

        public int rpc() {
            return this.rpc.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Port newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("port");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer telnet = null;
            private Integer rpc = null;

            public Builder() {
            }

            public Builder(Port config) {
                this.telnet(config.telnet());
                this.rpc(config.rpc());
            }

            private Builder override(Builder __superior) {
                if (__superior.telnet != null) {
                    this.telnet(__superior.telnet);
                }
                if (__superior.rpc != null) {
                    this.rpc(__superior.rpc);
                }
                return this;
            }

            public Builder telnet(int __value) {
                this.telnet = __value;
                return this;
            }

            private Builder telnet(String __value) {
                return this.telnet(Integer.valueOf(__value));
            }

            public Builder rpc(int __value) {
                this.rpc = __value;
                return this;
            }

            private Builder rpc(String __value) {
                return this.rpc(Integer.valueOf(__value));
            }

            public Port build() {
                return new Port(this);
            }
        }
    }

    public static final class Application
    extends InnerNode {
        private final StringNode tenant;
        private final StringNode name;
        private final StringNode environment;
        private final StringNode instance;
        private final StringNode region;

        public Application(Builder builder) {
            this(builder, true);
        }

        private Application(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for sentinel.application must be initialized: " + builder.__uninitialized);
            }
            this.tenant = builder.tenant == null ? new StringNode("default") : new StringNode(builder.tenant);
            this.name = builder.name == null ? new StringNode("default") : new StringNode(builder.name);
            this.environment = builder.environment == null ? new StringNode("default") : new StringNode(builder.environment);
            this.instance = builder.instance == null ? new StringNode("default") : new StringNode(builder.instance);
            this.region = builder.region == null ? new StringNode("default") : new StringNode(builder.region);
        }

        public String tenant() {
            return this.tenant.value();
        }

        public String name() {
            return this.name.value();
        }

        public String environment() {
            return this.environment.value();
        }

        public String instance() {
            return this.instance.value();
        }

        public String region() {
            return this.region.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Application newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("application");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String tenant = null;
            private String name = null;
            private String environment = null;
            private String instance = null;
            private String region = null;

            public Builder() {
            }

            public Builder(Application config) {
                this.tenant(config.tenant());
                this.name(config.name());
                this.environment(config.environment());
                this.instance(config.instance());
                this.region(config.region());
            }

            private Builder override(Builder __superior) {
                if (__superior.tenant != null) {
                    this.tenant(__superior.tenant);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.environment != null) {
                    this.environment(__superior.environment);
                }
                if (__superior.instance != null) {
                    this.instance(__superior.instance);
                }
                if (__superior.region != null) {
                    this.region(__superior.region);
                }
                return this;
            }

            public Builder tenant(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.tenant = __value;
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                return this;
            }

            public Builder environment(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.environment = __value;
                return this;
            }

            public Builder instance(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.instance = __value;
                return this;
            }

            public Builder region(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.region = __value;
                return this;
            }

            public Application build() {
                return new Application(this);
            }
        }
    }

    public static final class Connectivity
    extends InnerNode {
        private final IntegerNode minOkPercent;
        private final IntegerNode maxBadCount;

        public Connectivity(Builder builder) {
            this(builder, true);
        }

        private Connectivity(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for sentinel.connectivity must be initialized: " + builder.__uninitialized);
            }
            this.minOkPercent = builder.minOkPercent == null ? new IntegerNode(50) : new IntegerNode(builder.minOkPercent.intValue());
            this.maxBadCount = builder.maxBadCount == null ? new IntegerNode(1) : new IntegerNode(builder.maxBadCount.intValue());
        }

        public int minOkPercent() {
            return this.minOkPercent.value();
        }

        public int maxBadCount() {
            return this.maxBadCount.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Connectivity newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("connectivity");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer minOkPercent = null;
            private Integer maxBadCount = null;

            public Builder() {
            }

            public Builder(Connectivity config) {
                this.minOkPercent(config.minOkPercent());
                this.maxBadCount(config.maxBadCount());
            }

            private Builder override(Builder __superior) {
                if (__superior.minOkPercent != null) {
                    this.minOkPercent(__superior.minOkPercent);
                }
                if (__superior.maxBadCount != null) {
                    this.maxBadCount(__superior.maxBadCount);
                }
                return this;
            }

            public Builder minOkPercent(int __value) {
                this.minOkPercent = __value;
                return this;
            }

            private Builder minOkPercent(String __value) {
                return this.minOkPercent(Integer.valueOf(__value));
            }

            public Builder maxBadCount(int __value) {
                this.maxBadCount = __value;
                return this;
            }

            private Builder maxBadCount(String __value) {
                return this.maxBadCount(Integer.valueOf(__value));
            }

            public Connectivity build() {
                return new Connectivity(this);
            }
        }
    }

    public static final class Service
    extends InnerNode {
        private final StringNode command;
        private final InnerNodeVector<Environ> environ;
        private final InnerNodeVector<Logctl> logctl;
        private final StringNode preShutdownCommand;
        private final StringNode name;
        private final BooleanNode autostart;
        private final BooleanNode autorestart;
        private final ReferenceNode id;
        private final Affinity affinity;

        public Service(Builder builder) {
            this(builder, true);
        }

        private Service(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for sentinel.service[] must be initialized: " + builder.__uninitialized);
            }
            this.command = builder.command == null ? new StringNode() : new StringNode(builder.command);
            this.environ = Environ.createVector(builder.environ);
            this.logctl = Logctl.createVector(builder.logctl);
            this.preShutdownCommand = builder.preShutdownCommand == null ? new StringNode("") : new StringNode(builder.preShutdownCommand);
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.autostart = builder.autostart == null ? new BooleanNode(false) : new BooleanNode(builder.autostart.booleanValue());
            this.autorestart = builder.autorestart == null ? new BooleanNode(true) : new BooleanNode(builder.autorestart.booleanValue());
            this.id = builder.id == null ? new ReferenceNode() : new ReferenceNode(builder.id);
            this.affinity = new Affinity(builder.affinity, throwIfUninitialized);
        }

        public String command() {
            return this.command.value();
        }

        public List<Environ> environ() {
            return this.environ;
        }

        public Environ environ(int i) {
            return (Environ)((Object)this.environ.get(i));
        }

        public List<Logctl> logctl() {
            return this.logctl;
        }

        public Logctl logctl(int i) {
            return (Logctl)((Object)this.logctl.get(i));
        }

        public String preShutdownCommand() {
            return this.preShutdownCommand.value();
        }

        public String name() {
            return this.name.value();
        }

        public boolean autostart() {
            return this.autostart.value();
        }

        public boolean autorestart() {
            return this.autorestart.value();
        }

        public String id() {
            return this.id.value();
        }

        public Affinity affinity() {
            return this.affinity;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Service newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("service");
            return changes;
        }

        private static InnerNodeVector<Service> createVector(List<Builder> builders) {
            ArrayList<Service> elems = new ArrayList<Service>();
            for (Builder b : builders) {
                elems.add(new Service(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("command", "name", "id"));
            private String command = null;
            public List<Environ.Builder> environ = new ArrayList<Environ.Builder>();
            public List<Logctl.Builder> logctl = new ArrayList<Logctl.Builder>();
            private String preShutdownCommand = null;
            private String name = null;
            private Boolean autostart = null;
            private Boolean autorestart = null;
            private String id = null;
            public Affinity.Builder affinity = new Affinity.Builder();

            public Builder() {
            }

            public Builder(Service config) {
                this.command(config.command());
                for (Environ e : config.environ()) {
                    this.environ(new Environ.Builder(e));
                }
                for (Logctl l : config.logctl()) {
                    this.logctl(new Logctl.Builder(l));
                }
                this.preShutdownCommand(config.preShutdownCommand());
                this.name(config.name());
                this.autostart(config.autostart());
                this.autorestart(config.autorestart());
                this.id(config.id());
                this.affinity(new Affinity.Builder(config.affinity()));
            }

            private Builder override(Builder __superior) {
                if (__superior.command != null) {
                    this.command(__superior.command);
                }
                if (!__superior.environ.isEmpty()) {
                    this.environ.addAll(__superior.environ);
                }
                if (!__superior.logctl.isEmpty()) {
                    this.logctl.addAll(__superior.logctl);
                }
                if (__superior.preShutdownCommand != null) {
                    this.preShutdownCommand(__superior.preShutdownCommand);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.autostart != null) {
                    this.autostart(__superior.autostart);
                }
                if (__superior.autorestart != null) {
                    this.autorestart(__superior.autorestart);
                }
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                this.affinity(this.affinity.override(__superior.affinity));
                return this;
            }

            public Builder command(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.command = __value;
                this.__uninitialized.remove("command");
                return this;
            }

            public Builder environ(Environ.Builder __builder) {
                this.environ.add(__builder);
                return this;
            }

            public Builder environ(Consumer<Environ.Builder> __func) {
                Environ.Builder __inner = new Environ.Builder();
                __func.accept(__inner);
                this.environ.add(__inner);
                return this;
            }

            public Builder environ(List<Environ.Builder> __builders) {
                this.environ = __builders;
                return this;
            }

            public Builder logctl(Logctl.Builder __builder) {
                this.logctl.add(__builder);
                return this;
            }

            public Builder logctl(Consumer<Logctl.Builder> __func) {
                Logctl.Builder __inner = new Logctl.Builder();
                __func.accept(__inner);
                this.logctl.add(__inner);
                return this;
            }

            public Builder logctl(List<Logctl.Builder> __builders) {
                this.logctl = __builders;
                return this;
            }

            public Builder preShutdownCommand(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.preShutdownCommand = __value;
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder autostart(boolean __value) {
                this.autostart = __value;
                return this;
            }

            private Builder autostart(String __value) {
                return this.autostart(Boolean.valueOf(__value));
            }

            public Builder autorestart(boolean __value) {
                this.autorestart = __value;
                return this;
            }

            private Builder autorestart(String __value) {
                return this.autorestart(Boolean.valueOf(__value));
            }

            public Builder id(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            public Builder affinity(Affinity.Builder __builder) {
                this.affinity = __builder;
                return this;
            }

            public Builder affinity(Consumer<Affinity.Builder> __func) {
                Affinity.Builder __inner = new Affinity.Builder();
                __func.accept(__inner);
                this.affinity = __inner;
                return this;
            }

            public Service build() {
                return new Service(this);
            }
        }

        public static final class Environ
        extends InnerNode {
            private final StringNode varname;
            private final StringNode varvalue;

            public Environ(Builder builder) {
                this(builder, true);
            }

            private Environ(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for sentinel.service[].environ[] must be initialized: " + builder.__uninitialized);
                }
                this.varname = builder.varname == null ? new StringNode() : new StringNode(builder.varname);
                this.varvalue = builder.varvalue == null ? new StringNode() : new StringNode(builder.varvalue);
            }

            public String varname() {
                return this.varname.value();
            }

            public String varvalue() {
                return this.varvalue.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Environ newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("environ");
                return changes;
            }

            private static InnerNodeVector<Environ> createVector(List<Builder> builders) {
                ArrayList<Environ> elems = new ArrayList<Environ>();
                for (Builder b : builders) {
                    elems.add(new Environ(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("varname", "varvalue"));
                private String varname = null;
                private String varvalue = null;

                public Builder() {
                }

                public Builder(Environ config) {
                    this.varname(config.varname());
                    this.varvalue(config.varvalue());
                }

                private Builder override(Builder __superior) {
                    if (__superior.varname != null) {
                        this.varname(__superior.varname);
                    }
                    if (__superior.varvalue != null) {
                        this.varvalue(__superior.varvalue);
                    }
                    return this;
                }

                public Builder varname(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.varname = __value;
                    this.__uninitialized.remove("varname");
                    return this;
                }

                public Builder varvalue(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.varvalue = __value;
                    this.__uninitialized.remove("varvalue");
                    return this;
                }

                public Environ build() {
                    return new Environ(this);
                }
            }
        }

        public static final class Logctl
        extends InnerNode {
            private final StringNode componentSpec;
            private final StringNode levelsModSpec;

            public Logctl(Builder builder) {
                this(builder, true);
            }

            private Logctl(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for sentinel.service[].logctl[] must be initialized: " + builder.__uninitialized);
                }
                this.componentSpec = builder.componentSpec == null ? new StringNode() : new StringNode(builder.componentSpec);
                this.levelsModSpec = builder.levelsModSpec == null ? new StringNode() : new StringNode(builder.levelsModSpec);
            }

            public String componentSpec() {
                return this.componentSpec.value();
            }

            public String levelsModSpec() {
                return this.levelsModSpec.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Logctl newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("logctl");
                return changes;
            }

            private static InnerNodeVector<Logctl> createVector(List<Builder> builders) {
                ArrayList<Logctl> elems = new ArrayList<Logctl>();
                for (Builder b : builders) {
                    elems.add(new Logctl(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("componentSpec", "levelsModSpec"));
                private String componentSpec = null;
                private String levelsModSpec = null;

                public Builder() {
                }

                public Builder(Logctl config) {
                    this.componentSpec(config.componentSpec());
                    this.levelsModSpec(config.levelsModSpec());
                }

                private Builder override(Builder __superior) {
                    if (__superior.componentSpec != null) {
                        this.componentSpec(__superior.componentSpec);
                    }
                    if (__superior.levelsModSpec != null) {
                        this.levelsModSpec(__superior.levelsModSpec);
                    }
                    return this;
                }

                public Builder componentSpec(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.componentSpec = __value;
                    this.__uninitialized.remove("componentSpec");
                    return this;
                }

                public Builder levelsModSpec(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.levelsModSpec = __value;
                    this.__uninitialized.remove("levelsModSpec");
                    return this;
                }

                public Logctl build() {
                    return new Logctl(this);
                }
            }
        }

        public static final class Affinity
        extends InnerNode {
            private final IntegerNode cpuSocket;

            public Affinity(Builder builder) {
                this(builder, true);
            }

            private Affinity(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for sentinel.service[].affinity must be initialized: " + builder.__uninitialized);
                }
                this.cpuSocket = builder.cpuSocket == null ? new IntegerNode(-1) : new IntegerNode(builder.cpuSocket.intValue());
            }

            public int cpuSocket() {
                return this.cpuSocket.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Affinity newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("affinity");
                return changes;
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Integer cpuSocket = null;

                public Builder() {
                }

                public Builder(Affinity config) {
                    this.cpuSocket(config.cpuSocket());
                }

                private Builder override(Builder __superior) {
                    if (__superior.cpuSocket != null) {
                        this.cpuSocket(__superior.cpuSocket);
                    }
                    return this;
                }

                public Builder cpuSocket(int __value) {
                    this.cpuSocket = __value;
                    return this;
                }

                private Builder cpuSocket(String __value) {
                    return this.cpuSocket(Integer.valueOf(__value));
                }

                public Affinity build() {
                    return new Affinity(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

