/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class StorFilestorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c0831796a434827c9310f473e104f4aa";
    public static final String CONFIG_DEF_NAME = "stor-filestor";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "fail_disk_after_error_count int default=1 restart", "disk_operation_timeout int default=0 restart", "num_threads int default=8 restart", "num_response_threads int default=2 restart", "num_visitor_threads int default=16 restart", "num_network_threads int default=2 restart", "response_sequencer_type enum {LATENCY, THROUGHPUT, ADAPTIVE} default=ADAPTIVE restart", "common_merge_chain_optimalization_minimum_size int default=64 restart", "bucket_merge_chunk_size int default=16772216 restart", "enable_merge_local_node_choose_docs_optimalization bool default=true restart", "enable_multibit_split_optimalization bool default=true restart", "use_async_message_handling_on_schedule bool default=false restart", "resource_usage_reporter_noise_level double default=0.001", "async_operation_throttler.type enum { UNLIMITED, DYNAMIC } default=DYNAMIC", "async_operation_throttler.window_size_increment int default=20", "async_operation_throttler.window_size_decrement_factor double default=1.2", "async_operation_throttler.window_size_backoff double default=0.95", "async_operation_throttler.min_window_size int default=20", "async_operation_throttler.max_window_size int default=-1", "async_operation_throttler.resize_rate double default=3.0", "async_operation_throttler.throttle_individual_merge_feed_ops bool default=true", "async_operation_throttler_type enum { UNLIMITED, DYNAMIC } default=DYNAMIC", "async_operation_dynamic_throttling_window_increment int default=20 restart"};
    private final IntegerNode fail_disk_after_error_count;
    private final IntegerNode disk_operation_timeout;
    private final IntegerNode num_threads;
    private final IntegerNode num_response_threads;
    private final IntegerNode num_visitor_threads;
    private final IntegerNode num_network_threads;
    private final Response_sequencer_type response_sequencer_type;
    private final IntegerNode common_merge_chain_optimalization_minimum_size;
    private final IntegerNode bucket_merge_chunk_size;
    private final BooleanNode enable_merge_local_node_choose_docs_optimalization;
    private final BooleanNode enable_multibit_split_optimalization;
    private final BooleanNode use_async_message_handling_on_schedule;
    private final DoubleNode resource_usage_reporter_noise_level;
    private final Async_operation_throttler async_operation_throttler;
    private final Async_operation_throttler_type async_operation_throttler_type;
    private final IntegerNode async_operation_dynamic_throttling_window_increment;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public StorFilestorConfig(Builder builder) {
        this(builder, true);
    }

    private StorFilestorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-filestor must be initialized: " + builder.__uninitialized);
        }
        this.fail_disk_after_error_count = builder.fail_disk_after_error_count == null ? new IntegerNode(1) : new IntegerNode(builder.fail_disk_after_error_count.intValue());
        this.disk_operation_timeout = builder.disk_operation_timeout == null ? new IntegerNode(0) : new IntegerNode(builder.disk_operation_timeout.intValue());
        this.num_threads = builder.num_threads == null ? new IntegerNode(8) : new IntegerNode(builder.num_threads.intValue());
        this.num_response_threads = builder.num_response_threads == null ? new IntegerNode(2) : new IntegerNode(builder.num_response_threads.intValue());
        this.num_visitor_threads = builder.num_visitor_threads == null ? new IntegerNode(16) : new IntegerNode(builder.num_visitor_threads.intValue());
        this.num_network_threads = builder.num_network_threads == null ? new IntegerNode(2) : new IntegerNode(builder.num_network_threads.intValue());
        this.response_sequencer_type = builder.response_sequencer_type == null ? new Response_sequencer_type(Response_sequencer_type.ADAPTIVE) : new Response_sequencer_type(builder.response_sequencer_type);
        this.common_merge_chain_optimalization_minimum_size = builder.common_merge_chain_optimalization_minimum_size == null ? new IntegerNode(64) : new IntegerNode(builder.common_merge_chain_optimalization_minimum_size.intValue());
        this.bucket_merge_chunk_size = builder.bucket_merge_chunk_size == null ? new IntegerNode(16772216) : new IntegerNode(builder.bucket_merge_chunk_size.intValue());
        this.enable_merge_local_node_choose_docs_optimalization = builder.enable_merge_local_node_choose_docs_optimalization == null ? new BooleanNode(true) : new BooleanNode(builder.enable_merge_local_node_choose_docs_optimalization.booleanValue());
        this.enable_multibit_split_optimalization = builder.enable_multibit_split_optimalization == null ? new BooleanNode(true) : new BooleanNode(builder.enable_multibit_split_optimalization.booleanValue());
        this.use_async_message_handling_on_schedule = builder.use_async_message_handling_on_schedule == null ? new BooleanNode(false) : new BooleanNode(builder.use_async_message_handling_on_schedule.booleanValue());
        this.resource_usage_reporter_noise_level = builder.resource_usage_reporter_noise_level == null ? new DoubleNode(0.001) : new DoubleNode(builder.resource_usage_reporter_noise_level.doubleValue());
        this.async_operation_throttler = new Async_operation_throttler(builder.async_operation_throttler, throwIfUninitialized);
        this.async_operation_throttler_type = builder.async_operation_throttler_type == null ? new Async_operation_throttler_type(Async_operation_throttler_type.DYNAMIC) : new Async_operation_throttler_type(builder.async_operation_throttler_type);
        this.async_operation_dynamic_throttling_window_increment = builder.async_operation_dynamic_throttling_window_increment == null ? new IntegerNode(20) : new IntegerNode(builder.async_operation_dynamic_throttling_window_increment.intValue());
    }

    public int fail_disk_after_error_count() {
        return this.fail_disk_after_error_count.value();
    }

    public int disk_operation_timeout() {
        return this.disk_operation_timeout.value();
    }

    public int num_threads() {
        return this.num_threads.value();
    }

    public int num_response_threads() {
        return this.num_response_threads.value();
    }

    public int num_visitor_threads() {
        return this.num_visitor_threads.value();
    }

    public int num_network_threads() {
        return this.num_network_threads.value();
    }

    public Response_sequencer_type.Enum response_sequencer_type() {
        return (Response_sequencer_type.Enum)((Object)this.response_sequencer_type.value());
    }

    public int common_merge_chain_optimalization_minimum_size() {
        return this.common_merge_chain_optimalization_minimum_size.value();
    }

    public int bucket_merge_chunk_size() {
        return this.bucket_merge_chunk_size.value();
    }

    public boolean enable_merge_local_node_choose_docs_optimalization() {
        return this.enable_merge_local_node_choose_docs_optimalization.value();
    }

    public boolean enable_multibit_split_optimalization() {
        return this.enable_multibit_split_optimalization.value();
    }

    public boolean use_async_message_handling_on_schedule() {
        return this.use_async_message_handling_on_schedule.value();
    }

    public double resource_usage_reporter_noise_level() {
        return this.resource_usage_reporter_noise_level.value();
    }

    public Async_operation_throttler async_operation_throttler() {
        return this.async_operation_throttler;
    }

    public Async_operation_throttler_type.Enum async_operation_throttler_type() {
        return (Async_operation_throttler_type.Enum)((Object)this.async_operation_throttler_type.value());
    }

    public int async_operation_dynamic_throttling_window_increment() {
        return this.async_operation_dynamic_throttling_window_increment.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorFilestorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.fail_disk_after_error_count, (Node)newConfig.fail_disk_after_error_count, "fail_disk_after_error_count", "DETECT FAILURE PARAMETERS\n\nDeprecated and unused - will soon go away");
        changes.compare((Node)this.disk_operation_timeout, (Node)newConfig.disk_operation_timeout, "disk_operation_timeout", "Deprecated and unused - will soon go away");
        changes.compare((Node)this.num_threads, (Node)newConfig.num_threads, "num_threads", "PERFORMANCE PARAMETERS\n\nNumber of threads to use for each mountpoint.");
        changes.compare((Node)this.num_response_threads, (Node)newConfig.num_response_threads, "num_response_threads", "Number of threads for response processing and delivery\n0 will give legacy sync behavior.\nNegative number will choose a good number based on # cores.");
        changes.compare((Node)this.num_visitor_threads, (Node)newConfig.num_visitor_threads, "num_visitor_threads", "Number of handler objects that might be created by visitor threads\nThis is a temporary setting that only skilled vespa developers should modify\nThis must be kept in line with stor-visitor:visitorthreads");
        changes.compare((Node)this.num_network_threads, (Node)newConfig.num_network_threads, "num_network_threads", "Number of handler objects that might be created by network threads\nThis is a temporary setting that only skilled vespa developers should modify\nThis must be kept in line with stor-communicationmanager:rpc.num_network_threads");
        changes.compare((Node)this.response_sequencer_type, (Node)newConfig.response_sequencer_type, "response_sequencer_type", "Type of sequenced thread executor use for persistence replies.");
        changes.compare((Node)this.common_merge_chain_optimalization_minimum_size, (Node)newConfig.common_merge_chain_optimalization_minimum_size, "common_merge_chain_optimalization_minimum_size", "When merging, if we find more than this number of documents that exist on all\nof the same copies, send a separate apply bucket diff with these entries\nto an optimized merge chain that guarantuees minimum data transfer.");
        changes.compare((Node)this.bucket_merge_chunk_size, (Node)newConfig.bucket_merge_chunk_size, "bucket_merge_chunk_size", "Chunksize to use while merging buckets between nodes.\n \nShould follow stor-distributormanager:splitsize (16MB).");
        changes.compare((Node)this.enable_merge_local_node_choose_docs_optimalization, (Node)newConfig.enable_merge_local_node_choose_docs_optimalization, "enable_merge_local_node_choose_docs_optimalization", "When merging, it is possible to send more metadata than needed in order to\nlet local nodes in merge decide which entries fits best to add this time\nbased on disk location. Toggle this option on to use it. Note that memory\nconsumption might increase in a 4.1 to 4.2 upgrade due to this, as 4.1\ndont support to only fill in part of the metadata provided and will always\nfill all.\nNB unused and will be removed shortly.");
        changes.compare((Node)this.enable_multibit_split_optimalization, (Node)newConfig.enable_multibit_split_optimalization, "enable_multibit_split_optimalization", "Whether or not to enable the multibit split optimalization. This is useful\nif splitting is expensive, but listing document identifiers is fairly cheap.\nThis is true for memfile persistence layer, but not for vespa search.");
        changes.compare((Node)this.use_async_message_handling_on_schedule, (Node)newConfig.use_async_message_handling_on_schedule, "use_async_message_handling_on_schedule", "Whether or not to use async message handling when scheduling storage messages from FileStorManager.\n \nWhen turned on, the calling thread (e.g. FNET network thread when using Storage API RPC)\ngets the next async message to handle (if any) as part of scheduling a storage message.\nThis async message is then handled by the calling thread immediately,\ninstead of going via a persistence thread.");
        changes.compare((Node)this.async_operation_dynamic_throttling_window_increment, (Node)newConfig.async_operation_dynamic_throttling_window_increment, "async_operation_dynamic_throttling_window_increment", "Specifies the extent the throttling window is increased by when the async throttle\npolicy has decided that more concurrent operations are desirable. Also affects the\n_minimum_ size of the throttling window; its size is implicitly set to max(this config\nvalue, number of threads).\n \nOnly applies if async_operation_throttler_type == DYNAMIC.\nDEPRECATED! use the async_operation_throttler struct instead");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer fail_disk_after_error_count = null;
        private Integer disk_operation_timeout = null;
        private Integer num_threads = null;
        private Integer num_response_threads = null;
        private Integer num_visitor_threads = null;
        private Integer num_network_threads = null;
        private Response_sequencer_type.Enum response_sequencer_type = null;
        private Integer common_merge_chain_optimalization_minimum_size = null;
        private Integer bucket_merge_chunk_size = null;
        private Boolean enable_merge_local_node_choose_docs_optimalization = null;
        private Boolean enable_multibit_split_optimalization = null;
        private Boolean use_async_message_handling_on_schedule = null;
        private Double resource_usage_reporter_noise_level = null;
        public Async_operation_throttler.Builder async_operation_throttler = new Async_operation_throttler.Builder();
        private Async_operation_throttler_type.Enum async_operation_throttler_type = null;
        private Integer async_operation_dynamic_throttling_window_increment = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(StorFilestorConfig config) {
            this.fail_disk_after_error_count(config.fail_disk_after_error_count());
            this.disk_operation_timeout(config.disk_operation_timeout());
            this.num_threads(config.num_threads());
            this.num_response_threads(config.num_response_threads());
            this.num_visitor_threads(config.num_visitor_threads());
            this.num_network_threads(config.num_network_threads());
            this.response_sequencer_type(config.response_sequencer_type());
            this.common_merge_chain_optimalization_minimum_size(config.common_merge_chain_optimalization_minimum_size());
            this.bucket_merge_chunk_size(config.bucket_merge_chunk_size());
            this.enable_merge_local_node_choose_docs_optimalization(config.enable_merge_local_node_choose_docs_optimalization());
            this.enable_multibit_split_optimalization(config.enable_multibit_split_optimalization());
            this.use_async_message_handling_on_schedule(config.use_async_message_handling_on_schedule());
            this.resource_usage_reporter_noise_level(config.resource_usage_reporter_noise_level());
            this.async_operation_throttler(new Async_operation_throttler.Builder(config.async_operation_throttler()));
            this.async_operation_throttler_type(config.async_operation_throttler_type());
            this.async_operation_dynamic_throttling_window_increment(config.async_operation_dynamic_throttling_window_increment());
        }

        private Builder override(Builder __superior) {
            if (__superior.fail_disk_after_error_count != null) {
                this.fail_disk_after_error_count(__superior.fail_disk_after_error_count);
            }
            if (__superior.disk_operation_timeout != null) {
                this.disk_operation_timeout(__superior.disk_operation_timeout);
            }
            if (__superior.num_threads != null) {
                this.num_threads(__superior.num_threads);
            }
            if (__superior.num_response_threads != null) {
                this.num_response_threads(__superior.num_response_threads);
            }
            if (__superior.num_visitor_threads != null) {
                this.num_visitor_threads(__superior.num_visitor_threads);
            }
            if (__superior.num_network_threads != null) {
                this.num_network_threads(__superior.num_network_threads);
            }
            if (__superior.response_sequencer_type != null) {
                this.response_sequencer_type(__superior.response_sequencer_type);
            }
            if (__superior.common_merge_chain_optimalization_minimum_size != null) {
                this.common_merge_chain_optimalization_minimum_size(__superior.common_merge_chain_optimalization_minimum_size);
            }
            if (__superior.bucket_merge_chunk_size != null) {
                this.bucket_merge_chunk_size(__superior.bucket_merge_chunk_size);
            }
            if (__superior.enable_merge_local_node_choose_docs_optimalization != null) {
                this.enable_merge_local_node_choose_docs_optimalization(__superior.enable_merge_local_node_choose_docs_optimalization);
            }
            if (__superior.enable_multibit_split_optimalization != null) {
                this.enable_multibit_split_optimalization(__superior.enable_multibit_split_optimalization);
            }
            if (__superior.use_async_message_handling_on_schedule != null) {
                this.use_async_message_handling_on_schedule(__superior.use_async_message_handling_on_schedule);
            }
            if (__superior.resource_usage_reporter_noise_level != null) {
                this.resource_usage_reporter_noise_level(__superior.resource_usage_reporter_noise_level);
            }
            this.async_operation_throttler(this.async_operation_throttler.override(__superior.async_operation_throttler));
            if (__superior.async_operation_throttler_type != null) {
                this.async_operation_throttler_type(__superior.async_operation_throttler_type);
            }
            if (__superior.async_operation_dynamic_throttling_window_increment != null) {
                this.async_operation_dynamic_throttling_window_increment(__superior.async_operation_dynamic_throttling_window_increment);
            }
            return this;
        }

        public Builder fail_disk_after_error_count(int __value) {
            this.fail_disk_after_error_count = __value;
            return this;
        }

        private Builder fail_disk_after_error_count(String __value) {
            return this.fail_disk_after_error_count(Integer.valueOf(__value));
        }

        public Builder disk_operation_timeout(int __value) {
            this.disk_operation_timeout = __value;
            return this;
        }

        private Builder disk_operation_timeout(String __value) {
            return this.disk_operation_timeout(Integer.valueOf(__value));
        }

        public Builder num_threads(int __value) {
            this.num_threads = __value;
            return this;
        }

        private Builder num_threads(String __value) {
            return this.num_threads(Integer.valueOf(__value));
        }

        public Builder num_response_threads(int __value) {
            this.num_response_threads = __value;
            return this;
        }

        private Builder num_response_threads(String __value) {
            return this.num_response_threads(Integer.valueOf(__value));
        }

        public Builder num_visitor_threads(int __value) {
            this.num_visitor_threads = __value;
            return this;
        }

        private Builder num_visitor_threads(String __value) {
            return this.num_visitor_threads(Integer.valueOf(__value));
        }

        public Builder num_network_threads(int __value) {
            this.num_network_threads = __value;
            return this;
        }

        private Builder num_network_threads(String __value) {
            return this.num_network_threads(Integer.valueOf(__value));
        }

        public Builder response_sequencer_type(Response_sequencer_type.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.response_sequencer_type = __value;
            return this;
        }

        private Builder response_sequencer_type(String __value) {
            return this.response_sequencer_type(Response_sequencer_type.Enum.valueOf(__value));
        }

        public Builder common_merge_chain_optimalization_minimum_size(int __value) {
            this.common_merge_chain_optimalization_minimum_size = __value;
            return this;
        }

        private Builder common_merge_chain_optimalization_minimum_size(String __value) {
            return this.common_merge_chain_optimalization_minimum_size(Integer.valueOf(__value));
        }

        public Builder bucket_merge_chunk_size(int __value) {
            this.bucket_merge_chunk_size = __value;
            return this;
        }

        private Builder bucket_merge_chunk_size(String __value) {
            return this.bucket_merge_chunk_size(Integer.valueOf(__value));
        }

        public Builder enable_merge_local_node_choose_docs_optimalization(boolean __value) {
            this.enable_merge_local_node_choose_docs_optimalization = __value;
            return this;
        }

        private Builder enable_merge_local_node_choose_docs_optimalization(String __value) {
            return this.enable_merge_local_node_choose_docs_optimalization(Boolean.valueOf(__value));
        }

        public Builder enable_multibit_split_optimalization(boolean __value) {
            this.enable_multibit_split_optimalization = __value;
            return this;
        }

        private Builder enable_multibit_split_optimalization(String __value) {
            return this.enable_multibit_split_optimalization(Boolean.valueOf(__value));
        }

        public Builder use_async_message_handling_on_schedule(boolean __value) {
            this.use_async_message_handling_on_schedule = __value;
            return this;
        }

        private Builder use_async_message_handling_on_schedule(String __value) {
            return this.use_async_message_handling_on_schedule(Boolean.valueOf(__value));
        }

        public Builder resource_usage_reporter_noise_level(double __value) {
            this.resource_usage_reporter_noise_level = __value;
            return this;
        }

        private Builder resource_usage_reporter_noise_level(String __value) {
            return this.resource_usage_reporter_noise_level(Double.valueOf(__value));
        }

        public Builder async_operation_throttler(Async_operation_throttler.Builder __builder) {
            this.async_operation_throttler = __builder;
            return this;
        }

        public Builder async_operation_throttler(Consumer<Async_operation_throttler.Builder> __func) {
            Async_operation_throttler.Builder __inner = new Async_operation_throttler.Builder();
            __func.accept(__inner);
            this.async_operation_throttler = __inner;
            return this;
        }

        public Builder async_operation_throttler_type(Async_operation_throttler_type.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.async_operation_throttler_type = __value;
            return this;
        }

        private Builder async_operation_throttler_type(String __value) {
            return this.async_operation_throttler_type(Async_operation_throttler_type.Enum.valueOf(__value));
        }

        public Builder async_operation_dynamic_throttling_window_increment(int __value) {
            this.async_operation_dynamic_throttling_window_increment = __value;
            return this;
        }

        private Builder async_operation_dynamic_throttling_window_increment(String __value) {
            return this.async_operation_dynamic_throttling_window_increment(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorFilestorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorFilestorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorFilestorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public StorFilestorConfig build() {
            return new StorFilestorConfig(this);
        }
    }

    public static final class Response_sequencer_type
    extends EnumNode<Enum> {
        public static final Enum LATENCY = Enum.LATENCY;
        public static final Enum THROUGHPUT = Enum.THROUGHPUT;
        public static final Enum ADAPTIVE = Enum.ADAPTIVE;

        public Response_sequencer_type() {
            this.value = null;
        }

        public Response_sequencer_type(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            LATENCY,
            THROUGHPUT,
            ADAPTIVE;

        }
    }

    public static final class Async_operation_throttler
    extends InnerNode {
        private final Type type;
        private final IntegerNode window_size_increment;
        private final DoubleNode window_size_decrement_factor;
        private final DoubleNode window_size_backoff;
        private final IntegerNode min_window_size;
        private final IntegerNode max_window_size;
        private final DoubleNode resize_rate;
        private final BooleanNode throttle_individual_merge_feed_ops;

        public Async_operation_throttler(Builder builder) {
            this(builder, true);
        }

        private Async_operation_throttler(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-filestor.async_operation_throttler must be initialized: " + builder.__uninitialized);
            }
            this.type = builder.type == null ? new Type(Type.DYNAMIC) : new Type(builder.type);
            this.window_size_increment = builder.window_size_increment == null ? new IntegerNode(20) : new IntegerNode(builder.window_size_increment.intValue());
            this.window_size_decrement_factor = builder.window_size_decrement_factor == null ? new DoubleNode(1.2) : new DoubleNode(builder.window_size_decrement_factor.doubleValue());
            this.window_size_backoff = builder.window_size_backoff == null ? new DoubleNode(0.95) : new DoubleNode(builder.window_size_backoff.doubleValue());
            this.min_window_size = builder.min_window_size == null ? new IntegerNode(20) : new IntegerNode(builder.min_window_size.intValue());
            this.max_window_size = builder.max_window_size == null ? new IntegerNode(-1) : new IntegerNode(builder.max_window_size.intValue());
            this.resize_rate = builder.resize_rate == null ? new DoubleNode(3.0) : new DoubleNode(builder.resize_rate.doubleValue());
            this.throttle_individual_merge_feed_ops = builder.throttle_individual_merge_feed_ops == null ? new BooleanNode(true) : new BooleanNode(builder.throttle_individual_merge_feed_ops.booleanValue());
        }

        public Type.Enum type() {
            return (Type.Enum)((Object)this.type.value());
        }

        public int window_size_increment() {
            return this.window_size_increment.value();
        }

        public double window_size_decrement_factor() {
            return this.window_size_decrement_factor.value();
        }

        public double window_size_backoff() {
            return this.window_size_backoff.value();
        }

        public int min_window_size() {
            return this.min_window_size.value();
        }

        public int max_window_size() {
            return this.max_window_size.value();
        }

        public double resize_rate() {
            return this.resize_rate.value();
        }

        public boolean throttle_individual_merge_feed_ops() {
            return this.throttle_individual_merge_feed_ops.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Async_operation_throttler newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("async_operation_throttler");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Type.Enum type = null;
            private Integer window_size_increment = null;
            private Double window_size_decrement_factor = null;
            private Double window_size_backoff = null;
            private Integer min_window_size = null;
            private Integer max_window_size = null;
            private Double resize_rate = null;
            private Boolean throttle_individual_merge_feed_ops = null;

            public Builder() {
            }

            public Builder(Async_operation_throttler config) {
                this.type(config.type());
                this.window_size_increment(config.window_size_increment());
                this.window_size_decrement_factor(config.window_size_decrement_factor());
                this.window_size_backoff(config.window_size_backoff());
                this.min_window_size(config.min_window_size());
                this.max_window_size(config.max_window_size());
                this.resize_rate(config.resize_rate());
                this.throttle_individual_merge_feed_ops(config.throttle_individual_merge_feed_ops());
            }

            private Builder override(Builder __superior) {
                if (__superior.type != null) {
                    this.type(__superior.type);
                }
                if (__superior.window_size_increment != null) {
                    this.window_size_increment(__superior.window_size_increment);
                }
                if (__superior.window_size_decrement_factor != null) {
                    this.window_size_decrement_factor(__superior.window_size_decrement_factor);
                }
                if (__superior.window_size_backoff != null) {
                    this.window_size_backoff(__superior.window_size_backoff);
                }
                if (__superior.min_window_size != null) {
                    this.min_window_size(__superior.min_window_size);
                }
                if (__superior.max_window_size != null) {
                    this.max_window_size(__superior.max_window_size);
                }
                if (__superior.resize_rate != null) {
                    this.resize_rate(__superior.resize_rate);
                }
                if (__superior.throttle_individual_merge_feed_ops != null) {
                    this.throttle_individual_merge_feed_ops(__superior.throttle_individual_merge_feed_ops);
                }
                return this;
            }

            public Builder type(Type.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.type = __value;
                return this;
            }

            private Builder type(String __value) {
                return this.type(Type.Enum.valueOf(__value));
            }

            public Builder window_size_increment(int __value) {
                this.window_size_increment = __value;
                return this;
            }

            private Builder window_size_increment(String __value) {
                return this.window_size_increment(Integer.valueOf(__value));
            }

            public Builder window_size_decrement_factor(double __value) {
                this.window_size_decrement_factor = __value;
                return this;
            }

            private Builder window_size_decrement_factor(String __value) {
                return this.window_size_decrement_factor(Double.valueOf(__value));
            }

            public Builder window_size_backoff(double __value) {
                this.window_size_backoff = __value;
                return this;
            }

            private Builder window_size_backoff(String __value) {
                return this.window_size_backoff(Double.valueOf(__value));
            }

            public Builder min_window_size(int __value) {
                this.min_window_size = __value;
                return this;
            }

            private Builder min_window_size(String __value) {
                return this.min_window_size(Integer.valueOf(__value));
            }

            public Builder max_window_size(int __value) {
                this.max_window_size = __value;
                return this;
            }

            private Builder max_window_size(String __value) {
                return this.max_window_size(Integer.valueOf(__value));
            }

            public Builder resize_rate(double __value) {
                this.resize_rate = __value;
                return this;
            }

            private Builder resize_rate(String __value) {
                return this.resize_rate(Double.valueOf(__value));
            }

            public Builder throttle_individual_merge_feed_ops(boolean __value) {
                this.throttle_individual_merge_feed_ops = __value;
                return this;
            }

            private Builder throttle_individual_merge_feed_ops(String __value) {
                return this.throttle_individual_merge_feed_ops(Boolean.valueOf(__value));
            }

            public Async_operation_throttler build() {
                return new Async_operation_throttler(this);
            }
        }

        public static final class Type
        extends EnumNode<Enum> {
            public static final Enum UNLIMITED = Enum.UNLIMITED;
            public static final Enum DYNAMIC = Enum.DYNAMIC;

            public Type() {
                this.value = null;
            }

            public Type(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                UNLIMITED,
                DYNAMIC;

            }
        }
    }

    public static final class Async_operation_throttler_type
    extends EnumNode<Enum> {
        public static final Enum UNLIMITED = Enum.UNLIMITED;
        public static final Enum DYNAMIC = Enum.DYNAMIC;

        public Async_operation_throttler_type() {
            this.value = null;
        }

        public Async_operation_throttler_type(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            UNLIMITED,
            DYNAMIC;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

