/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ConfigserverConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "cada677993224445d8187e4c1bce06f2";
    public static final String CONFIG_DEF_NAME = "configserver";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "rpcport int default=19070", "httpport int default=19071", "numRpcThreads int default=0", "zookeeperserver[].hostname string", "zookeeperserver[].port int default=2181", "zookeeper.barrierTimeout long default=360", "zookeeperLocalhostAffinity bool default=true", "configModelPluginDir[] string", "configServerDBDir string default=\"var/db/vespa/config_server/serverdb/\"", "configDefinitionsDir string default=\"share/vespa/configdefinitions/\"", "fileReferencesDir string default=\"var/db/vespa/filedistribution/\"", "sessionLifetime long default=3600", "masterGeneration long default=0", "multitenant bool default=false", "numDelayedResponseThreads int default=1", "serverId string default=\"localhost\"", "hostedVespa bool default=false", "numParallelTenantLoaders int default=4", "applicationDirectory string default=\"conf/configserver-app\"", "cloud string default=\"default\"", "environment string default=\"prod\"", "region string default=\"default\"", "system string default=\"main\"", "defaultFlavor string default=\"default\"", "defaultAdminFlavor string default=\"default\"", "defaultContainerFlavor string default=\"default\"", "defaultContentFlavor string default=\"default\"", "maxgetconfigclients int default=1000000", "maxoutputbuffersize int default=65536", "useVespaVersionInRequest bool default=false", "payloadCompressionType enum { UNCOMPRESSED, LZ4 } default=LZ4", "loadBalancerAddress string default=\"\"", "athenzDnsSuffix string default=\"\"", "ztsUrl string default=\"\"", "nodeAdminInContainer bool default=false", "maintainerIntervalMinutes int default=30", "tenantsMaintainerIntervalMinutes int default=525600", "maxDurationOfBootstrap long default=7200", "sleepTimeWhenRedeployingFails long default=30", "buildMinimalSetOfConfigModels bool default=true", "throwIfBootstrappingTenantRepoFails bool default=true", "canReturnEmptySentinelConfig bool default=false"};
    private final IntegerNode rpcport;
    private final IntegerNode httpport;
    private final IntegerNode numRpcThreads;
    private final InnerNodeVector<Zookeeperserver> zookeeperserver;
    private final Zookeeper zookeeper;
    private final BooleanNode zookeeperLocalhostAffinity;
    private final LeafNodeVector<String, StringNode> configModelPluginDir;
    private final StringNode configServerDBDir;
    private final StringNode configDefinitionsDir;
    private final StringNode fileReferencesDir;
    private final LongNode sessionLifetime;
    private final LongNode masterGeneration;
    private final BooleanNode multitenant;
    private final IntegerNode numDelayedResponseThreads;
    private final StringNode serverId;
    private final BooleanNode hostedVespa;
    private final IntegerNode numParallelTenantLoaders;
    private final StringNode applicationDirectory;
    private final StringNode cloud;
    private final StringNode environment;
    private final StringNode region;
    private final StringNode system;
    private final StringNode defaultFlavor;
    private final StringNode defaultAdminFlavor;
    private final StringNode defaultContainerFlavor;
    private final StringNode defaultContentFlavor;
    private final IntegerNode maxgetconfigclients;
    private final IntegerNode maxoutputbuffersize;
    private final BooleanNode useVespaVersionInRequest;
    private final PayloadCompressionType payloadCompressionType;
    private final StringNode loadBalancerAddress;
    private final StringNode athenzDnsSuffix;
    private final StringNode ztsUrl;
    private final BooleanNode nodeAdminInContainer;
    private final IntegerNode maintainerIntervalMinutes;
    private final IntegerNode tenantsMaintainerIntervalMinutes;
    private final LongNode maxDurationOfBootstrap;
    private final LongNode sleepTimeWhenRedeployingFails;
    private final BooleanNode buildMinimalSetOfConfigModels;
    private final BooleanNode throwIfBootstrappingTenantRepoFails;
    private final BooleanNode canReturnEmptySentinelConfig;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ConfigserverConfig(Builder builder) {
        this(builder, true);
    }

    private ConfigserverConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for configserver must be initialized: " + builder.__uninitialized);
        }
        this.rpcport = builder.rpcport == null ? new IntegerNode(19070) : new IntegerNode(builder.rpcport.intValue());
        this.httpport = builder.httpport == null ? new IntegerNode(19071) : new IntegerNode(builder.httpport.intValue());
        this.numRpcThreads = builder.numRpcThreads == null ? new IntegerNode(0) : new IntegerNode(builder.numRpcThreads.intValue());
        this.zookeeperserver = Zookeeperserver.createVector(builder.zookeeperserver);
        this.zookeeper = new Zookeeper(builder.zookeeper, throwIfUninitialized);
        this.zookeeperLocalhostAffinity = builder.zookeeperLocalhostAffinity == null ? new BooleanNode(true) : new BooleanNode(builder.zookeeperLocalhostAffinity.booleanValue());
        this.configModelPluginDir = new LeafNodeVector(builder.configModelPluginDir, (LeafNode)new StringNode());
        this.configServerDBDir = builder.configServerDBDir == null ? new StringNode("var/db/vespa/config_server/serverdb/") : new StringNode(builder.configServerDBDir);
        this.configDefinitionsDir = builder.configDefinitionsDir == null ? new StringNode("share/vespa/configdefinitions/") : new StringNode(builder.configDefinitionsDir);
        this.fileReferencesDir = builder.fileReferencesDir == null ? new StringNode("var/db/vespa/filedistribution/") : new StringNode(builder.fileReferencesDir);
        this.sessionLifetime = builder.sessionLifetime == null ? new LongNode(3600L) : new LongNode(builder.sessionLifetime.longValue());
        this.masterGeneration = builder.masterGeneration == null ? new LongNode(0L) : new LongNode(builder.masterGeneration.longValue());
        this.multitenant = builder.multitenant == null ? new BooleanNode(false) : new BooleanNode(builder.multitenant.booleanValue());
        this.numDelayedResponseThreads = builder.numDelayedResponseThreads == null ? new IntegerNode(1) : new IntegerNode(builder.numDelayedResponseThreads.intValue());
        this.serverId = builder.serverId == null ? new StringNode("localhost") : new StringNode(builder.serverId);
        this.hostedVespa = builder.hostedVespa == null ? new BooleanNode(false) : new BooleanNode(builder.hostedVespa.booleanValue());
        this.numParallelTenantLoaders = builder.numParallelTenantLoaders == null ? new IntegerNode(4) : new IntegerNode(builder.numParallelTenantLoaders.intValue());
        this.applicationDirectory = builder.applicationDirectory == null ? new StringNode("conf/configserver-app") : new StringNode(builder.applicationDirectory);
        this.cloud = builder.cloud == null ? new StringNode("default") : new StringNode(builder.cloud);
        this.environment = builder.environment == null ? new StringNode("prod") : new StringNode(builder.environment);
        this.region = builder.region == null ? new StringNode("default") : new StringNode(builder.region);
        this.system = builder.system == null ? new StringNode("main") : new StringNode(builder.system);
        this.defaultFlavor = builder.defaultFlavor == null ? new StringNode("default") : new StringNode(builder.defaultFlavor);
        this.defaultAdminFlavor = builder.defaultAdminFlavor == null ? new StringNode("default") : new StringNode(builder.defaultAdminFlavor);
        this.defaultContainerFlavor = builder.defaultContainerFlavor == null ? new StringNode("default") : new StringNode(builder.defaultContainerFlavor);
        this.defaultContentFlavor = builder.defaultContentFlavor == null ? new StringNode("default") : new StringNode(builder.defaultContentFlavor);
        this.maxgetconfigclients = builder.maxgetconfigclients == null ? new IntegerNode(1000000) : new IntegerNode(builder.maxgetconfigclients.intValue());
        this.maxoutputbuffersize = builder.maxoutputbuffersize == null ? new IntegerNode(65536) : new IntegerNode(builder.maxoutputbuffersize.intValue());
        this.useVespaVersionInRequest = builder.useVespaVersionInRequest == null ? new BooleanNode(false) : new BooleanNode(builder.useVespaVersionInRequest.booleanValue());
        this.payloadCompressionType = builder.payloadCompressionType == null ? new PayloadCompressionType(PayloadCompressionType.LZ4) : new PayloadCompressionType(builder.payloadCompressionType);
        this.loadBalancerAddress = builder.loadBalancerAddress == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.loadBalancerAddress);
        this.athenzDnsSuffix = builder.athenzDnsSuffix == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.athenzDnsSuffix);
        this.ztsUrl = builder.ztsUrl == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.ztsUrl);
        this.nodeAdminInContainer = builder.nodeAdminInContainer == null ? new BooleanNode(false) : new BooleanNode(builder.nodeAdminInContainer.booleanValue());
        this.maintainerIntervalMinutes = builder.maintainerIntervalMinutes == null ? new IntegerNode(30) : new IntegerNode(builder.maintainerIntervalMinutes.intValue());
        this.tenantsMaintainerIntervalMinutes = builder.tenantsMaintainerIntervalMinutes == null ? new IntegerNode(525600) : new IntegerNode(builder.tenantsMaintainerIntervalMinutes.intValue());
        this.maxDurationOfBootstrap = builder.maxDurationOfBootstrap == null ? new LongNode(7200L) : new LongNode(builder.maxDurationOfBootstrap.longValue());
        this.sleepTimeWhenRedeployingFails = builder.sleepTimeWhenRedeployingFails == null ? new LongNode(30L) : new LongNode(builder.sleepTimeWhenRedeployingFails.longValue());
        this.buildMinimalSetOfConfigModels = builder.buildMinimalSetOfConfigModels == null ? new BooleanNode(true) : new BooleanNode(builder.buildMinimalSetOfConfigModels.booleanValue());
        this.throwIfBootstrappingTenantRepoFails = builder.throwIfBootstrappingTenantRepoFails == null ? new BooleanNode(true) : new BooleanNode(builder.throwIfBootstrappingTenantRepoFails.booleanValue());
        this.canReturnEmptySentinelConfig = builder.canReturnEmptySentinelConfig == null ? new BooleanNode(false) : new BooleanNode(builder.canReturnEmptySentinelConfig.booleanValue());
    }

    public int rpcport() {
        return this.rpcport.value();
    }

    public int httpport() {
        return this.httpport.value();
    }

    public int numRpcThreads() {
        return this.numRpcThreads.value();
    }

    public List<Zookeeperserver> zookeeperserver() {
        return this.zookeeperserver;
    }

    public Zookeeperserver zookeeperserver(int i) {
        return (Zookeeperserver)((Object)this.zookeeperserver.get(i));
    }

    public Zookeeper zookeeper() {
        return this.zookeeper;
    }

    public boolean zookeeperLocalhostAffinity() {
        return this.zookeeperLocalhostAffinity.value();
    }

    public List<String> configModelPluginDir() {
        return this.configModelPluginDir.asList();
    }

    public String configModelPluginDir(int i) {
        return ((StringNode)this.configModelPluginDir.get(i)).value();
    }

    public String configServerDBDir() {
        return this.configServerDBDir.value();
    }

    public String configDefinitionsDir() {
        return this.configDefinitionsDir.value();
    }

    public String fileReferencesDir() {
        return this.fileReferencesDir.value();
    }

    public long sessionLifetime() {
        return this.sessionLifetime.value();
    }

    public long masterGeneration() {
        return this.masterGeneration.value();
    }

    public boolean multitenant() {
        return this.multitenant.value();
    }

    public int numDelayedResponseThreads() {
        return this.numDelayedResponseThreads.value();
    }

    public String serverId() {
        return this.serverId.value();
    }

    public boolean hostedVespa() {
        return this.hostedVespa.value();
    }

    public int numParallelTenantLoaders() {
        return this.numParallelTenantLoaders.value();
    }

    public String applicationDirectory() {
        return this.applicationDirectory.value();
    }

    public String cloud() {
        return this.cloud.value();
    }

    public String environment() {
        return this.environment.value();
    }

    public String region() {
        return this.region.value();
    }

    public String system() {
        return this.system.value();
    }

    public String defaultFlavor() {
        return this.defaultFlavor.value();
    }

    public String defaultAdminFlavor() {
        return this.defaultAdminFlavor.value();
    }

    public String defaultContainerFlavor() {
        return this.defaultContainerFlavor.value();
    }

    public String defaultContentFlavor() {
        return this.defaultContentFlavor.value();
    }

    public int maxgetconfigclients() {
        return this.maxgetconfigclients.value();
    }

    public int maxoutputbuffersize() {
        return this.maxoutputbuffersize.value();
    }

    public boolean useVespaVersionInRequest() {
        return this.useVespaVersionInRequest.value();
    }

    public PayloadCompressionType.Enum payloadCompressionType() {
        return (PayloadCompressionType.Enum)((Object)this.payloadCompressionType.value());
    }

    public String loadBalancerAddress() {
        return this.loadBalancerAddress.value();
    }

    public String athenzDnsSuffix() {
        return this.athenzDnsSuffix.value();
    }

    public String ztsUrl() {
        return this.ztsUrl.value();
    }

    public boolean nodeAdminInContainer() {
        return this.nodeAdminInContainer.value();
    }

    public int maintainerIntervalMinutes() {
        return this.maintainerIntervalMinutes.value();
    }

    public int tenantsMaintainerIntervalMinutes() {
        return this.tenantsMaintainerIntervalMinutes.value();
    }

    public long maxDurationOfBootstrap() {
        return this.maxDurationOfBootstrap.value();
    }

    public long sleepTimeWhenRedeployingFails() {
        return this.sleepTimeWhenRedeployingFails.value();
    }

    public boolean buildMinimalSetOfConfigModels() {
        return this.buildMinimalSetOfConfigModels.value();
    }

    public boolean throwIfBootstrappingTenantRepoFails() {
        return this.throwIfBootstrappingTenantRepoFails.value();
    }

    public boolean canReturnEmptySentinelConfig() {
        return this.canReturnEmptySentinelConfig.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ConfigserverConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class PayloadCompressionType
    extends EnumNode<Enum> {
        public static final Enum UNCOMPRESSED = Enum.UNCOMPRESSED;
        public static final Enum LZ4 = Enum.LZ4;

        public PayloadCompressionType() {
            this.value = null;
        }

        public PayloadCompressionType(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(@NonNull String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            UNCOMPRESSED,
            LZ4;

        }
    }

    public static final class Zookeeper
    extends InnerNode {
        private final LongNode barrierTimeout;

        public Zookeeper(Builder builder) {
            this(builder, true);
        }

        private Zookeeper(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for configserver.zookeeper must be initialized: " + builder.__uninitialized);
            }
            this.barrierTimeout = builder.barrierTimeout == null ? new LongNode(360L) : new LongNode(builder.barrierTimeout.longValue());
        }

        public long barrierTimeout() {
            return this.barrierTimeout.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Zookeeper newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("zookeeper");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Long barrierTimeout = null;

            public Builder() {
            }

            public Builder(Zookeeper config) {
                this.barrierTimeout(config.barrierTimeout());
            }

            private Builder override(Builder __superior) {
                if (__superior.barrierTimeout != null) {
                    this.barrierTimeout(__superior.barrierTimeout);
                }
                return this;
            }

            public Builder barrierTimeout(long __value) {
                this.barrierTimeout = __value;
                return this;
            }

            private Builder barrierTimeout(String __value) {
                return this.barrierTimeout(Long.valueOf(__value));
            }

            public Zookeeper build() {
                return new Zookeeper(this);
            }
        }
    }

    public static final class Zookeeperserver
    extends InnerNode {
        private final StringNode hostname;
        private final IntegerNode port;

        public Zookeeperserver(Builder builder) {
            this(builder, true);
        }

        private Zookeeperserver(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for configserver.zookeeperserver[] must be initialized: " + builder.__uninitialized);
            }
            this.hostname = builder.hostname == null ? new StringNode() : new StringNode(builder.hostname);
            this.port = builder.port == null ? new IntegerNode(2181) : new IntegerNode(builder.port.intValue());
        }

        public String hostname() {
            return this.hostname.value();
        }

        public int port() {
            return this.port.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Zookeeperserver newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("zookeeperserver");
            return changes;
        }

        private static InnerNodeVector<Zookeeperserver> createVector(List<Builder> builders) {
            ArrayList<Zookeeperserver> elems = new ArrayList<Zookeeperserver>();
            for (Builder b : builders) {
                elems.add(new Zookeeperserver(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("hostname"));
            private String hostname = null;
            private Integer port = null;

            public Builder() {
            }

            public Builder(Zookeeperserver config) {
                this.hostname(config.hostname());
                this.port(config.port());
            }

            private Builder override(Builder __superior) {
                if (__superior.hostname != null) {
                    this.hostname(__superior.hostname);
                }
                if (__superior.port != null) {
                    this.port(__superior.port);
                }
                return this;
            }

            public Builder hostname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.hostname = __value;
                this.__uninitialized.remove("hostname");
                return this;
            }

            public Builder port(int __value) {
                this.port = __value;
                return this;
            }

            private Builder port(String __value) {
                return this.port(Integer.valueOf(__value));
            }

            public Zookeeperserver build() {
                return new Zookeeperserver(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer rpcport = null;
        private Integer httpport = null;
        private Integer numRpcThreads = null;
        public List<Zookeeperserver.Builder> zookeeperserver = new ArrayList<Zookeeperserver.Builder>();
        public Zookeeper.Builder zookeeper = new Zookeeper.Builder();
        private Boolean zookeeperLocalhostAffinity = null;
        public List<String> configModelPluginDir = new ArrayList<String>();
        private String configServerDBDir = null;
        private String configDefinitionsDir = null;
        private String fileReferencesDir = null;
        private Long sessionLifetime = null;
        private Long masterGeneration = null;
        private Boolean multitenant = null;
        private Integer numDelayedResponseThreads = null;
        private String serverId = null;
        private Boolean hostedVespa = null;
        private Integer numParallelTenantLoaders = null;
        private String applicationDirectory = null;
        private String cloud = null;
        private String environment = null;
        private String region = null;
        private String system = null;
        private String defaultFlavor = null;
        private String defaultAdminFlavor = null;
        private String defaultContainerFlavor = null;
        private String defaultContentFlavor = null;
        private Integer maxgetconfigclients = null;
        private Integer maxoutputbuffersize = null;
        private Boolean useVespaVersionInRequest = null;
        private PayloadCompressionType.Enum payloadCompressionType = null;
        private String loadBalancerAddress = null;
        private String athenzDnsSuffix = null;
        private String ztsUrl = null;
        private Boolean nodeAdminInContainer = null;
        private Integer maintainerIntervalMinutes = null;
        private Integer tenantsMaintainerIntervalMinutes = null;
        private Long maxDurationOfBootstrap = null;
        private Long sleepTimeWhenRedeployingFails = null;
        private Boolean buildMinimalSetOfConfigModels = null;
        private Boolean throwIfBootstrappingTenantRepoFails = null;
        private Boolean canReturnEmptySentinelConfig = null;

        public Builder() {
        }

        public Builder(ConfigserverConfig config) {
            this.rpcport(config.rpcport());
            this.httpport(config.httpport());
            this.numRpcThreads(config.numRpcThreads());
            for (Zookeeperserver z : config.zookeeperserver()) {
                this.zookeeperserver(new Zookeeperserver.Builder(z));
            }
            this.zookeeper(new Zookeeper.Builder(config.zookeeper()));
            this.zookeeperLocalhostAffinity(config.zookeeperLocalhostAffinity());
            this.configModelPluginDir(config.configModelPluginDir());
            this.configServerDBDir(config.configServerDBDir());
            this.configDefinitionsDir(config.configDefinitionsDir());
            this.fileReferencesDir(config.fileReferencesDir());
            this.sessionLifetime(config.sessionLifetime());
            this.masterGeneration(config.masterGeneration());
            this.multitenant(config.multitenant());
            this.numDelayedResponseThreads(config.numDelayedResponseThreads());
            this.serverId(config.serverId());
            this.hostedVespa(config.hostedVespa());
            this.numParallelTenantLoaders(config.numParallelTenantLoaders());
            this.applicationDirectory(config.applicationDirectory());
            this.cloud(config.cloud());
            this.environment(config.environment());
            this.region(config.region());
            this.system(config.system());
            this.defaultFlavor(config.defaultFlavor());
            this.defaultAdminFlavor(config.defaultAdminFlavor());
            this.defaultContainerFlavor(config.defaultContainerFlavor());
            this.defaultContentFlavor(config.defaultContentFlavor());
            this.maxgetconfigclients(config.maxgetconfigclients());
            this.maxoutputbuffersize(config.maxoutputbuffersize());
            this.useVespaVersionInRequest(config.useVespaVersionInRequest());
            this.payloadCompressionType(config.payloadCompressionType());
            this.loadBalancerAddress(config.loadBalancerAddress());
            this.athenzDnsSuffix(config.athenzDnsSuffix());
            this.ztsUrl(config.ztsUrl());
            this.nodeAdminInContainer(config.nodeAdminInContainer());
            this.maintainerIntervalMinutes(config.maintainerIntervalMinutes());
            this.tenantsMaintainerIntervalMinutes(config.tenantsMaintainerIntervalMinutes());
            this.maxDurationOfBootstrap(config.maxDurationOfBootstrap());
            this.sleepTimeWhenRedeployingFails(config.sleepTimeWhenRedeployingFails());
            this.buildMinimalSetOfConfigModels(config.buildMinimalSetOfConfigModels());
            this.throwIfBootstrappingTenantRepoFails(config.throwIfBootstrappingTenantRepoFails());
            this.canReturnEmptySentinelConfig(config.canReturnEmptySentinelConfig());
        }

        private Builder override(Builder __superior) {
            if (__superior.rpcport != null) {
                this.rpcport(__superior.rpcport);
            }
            if (__superior.httpport != null) {
                this.httpport(__superior.httpport);
            }
            if (__superior.numRpcThreads != null) {
                this.numRpcThreads(__superior.numRpcThreads);
            }
            if (!__superior.zookeeperserver.isEmpty()) {
                this.zookeeperserver.addAll(__superior.zookeeperserver);
            }
            this.zookeeper(this.zookeeper.override(__superior.zookeeper));
            if (__superior.zookeeperLocalhostAffinity != null) {
                this.zookeeperLocalhostAffinity(__superior.zookeeperLocalhostAffinity);
            }
            if (!__superior.configModelPluginDir.isEmpty()) {
                this.configModelPluginDir.addAll(__superior.configModelPluginDir);
            }
            if (__superior.configServerDBDir != null) {
                this.configServerDBDir(__superior.configServerDBDir);
            }
            if (__superior.configDefinitionsDir != null) {
                this.configDefinitionsDir(__superior.configDefinitionsDir);
            }
            if (__superior.fileReferencesDir != null) {
                this.fileReferencesDir(__superior.fileReferencesDir);
            }
            if (__superior.sessionLifetime != null) {
                this.sessionLifetime(__superior.sessionLifetime);
            }
            if (__superior.masterGeneration != null) {
                this.masterGeneration(__superior.masterGeneration);
            }
            if (__superior.multitenant != null) {
                this.multitenant(__superior.multitenant);
            }
            if (__superior.numDelayedResponseThreads != null) {
                this.numDelayedResponseThreads(__superior.numDelayedResponseThreads);
            }
            if (__superior.serverId != null) {
                this.serverId(__superior.serverId);
            }
            if (__superior.hostedVespa != null) {
                this.hostedVespa(__superior.hostedVespa);
            }
            if (__superior.numParallelTenantLoaders != null) {
                this.numParallelTenantLoaders(__superior.numParallelTenantLoaders);
            }
            if (__superior.applicationDirectory != null) {
                this.applicationDirectory(__superior.applicationDirectory);
            }
            if (__superior.cloud != null) {
                this.cloud(__superior.cloud);
            }
            if (__superior.environment != null) {
                this.environment(__superior.environment);
            }
            if (__superior.region != null) {
                this.region(__superior.region);
            }
            if (__superior.system != null) {
                this.system(__superior.system);
            }
            if (__superior.defaultFlavor != null) {
                this.defaultFlavor(__superior.defaultFlavor);
            }
            if (__superior.defaultAdminFlavor != null) {
                this.defaultAdminFlavor(__superior.defaultAdminFlavor);
            }
            if (__superior.defaultContainerFlavor != null) {
                this.defaultContainerFlavor(__superior.defaultContainerFlavor);
            }
            if (__superior.defaultContentFlavor != null) {
                this.defaultContentFlavor(__superior.defaultContentFlavor);
            }
            if (__superior.maxgetconfigclients != null) {
                this.maxgetconfigclients(__superior.maxgetconfigclients);
            }
            if (__superior.maxoutputbuffersize != null) {
                this.maxoutputbuffersize(__superior.maxoutputbuffersize);
            }
            if (__superior.useVespaVersionInRequest != null) {
                this.useVespaVersionInRequest(__superior.useVespaVersionInRequest);
            }
            if (__superior.payloadCompressionType != null) {
                this.payloadCompressionType(__superior.payloadCompressionType);
            }
            if (__superior.loadBalancerAddress != null) {
                this.loadBalancerAddress(__superior.loadBalancerAddress);
            }
            if (__superior.athenzDnsSuffix != null) {
                this.athenzDnsSuffix(__superior.athenzDnsSuffix);
            }
            if (__superior.ztsUrl != null) {
                this.ztsUrl(__superior.ztsUrl);
            }
            if (__superior.nodeAdminInContainer != null) {
                this.nodeAdminInContainer(__superior.nodeAdminInContainer);
            }
            if (__superior.maintainerIntervalMinutes != null) {
                this.maintainerIntervalMinutes(__superior.maintainerIntervalMinutes);
            }
            if (__superior.tenantsMaintainerIntervalMinutes != null) {
                this.tenantsMaintainerIntervalMinutes(__superior.tenantsMaintainerIntervalMinutes);
            }
            if (__superior.maxDurationOfBootstrap != null) {
                this.maxDurationOfBootstrap(__superior.maxDurationOfBootstrap);
            }
            if (__superior.sleepTimeWhenRedeployingFails != null) {
                this.sleepTimeWhenRedeployingFails(__superior.sleepTimeWhenRedeployingFails);
            }
            if (__superior.buildMinimalSetOfConfigModels != null) {
                this.buildMinimalSetOfConfigModels(__superior.buildMinimalSetOfConfigModels);
            }
            if (__superior.throwIfBootstrappingTenantRepoFails != null) {
                this.throwIfBootstrappingTenantRepoFails(__superior.throwIfBootstrappingTenantRepoFails);
            }
            if (__superior.canReturnEmptySentinelConfig != null) {
                this.canReturnEmptySentinelConfig(__superior.canReturnEmptySentinelConfig);
            }
            return this;
        }

        public Builder rpcport(int __value) {
            this.rpcport = __value;
            return this;
        }

        private Builder rpcport(String __value) {
            return this.rpcport(Integer.valueOf(__value));
        }

        public Builder httpport(int __value) {
            this.httpport = __value;
            return this;
        }

        private Builder httpport(String __value) {
            return this.httpport(Integer.valueOf(__value));
        }

        public Builder numRpcThreads(int __value) {
            this.numRpcThreads = __value;
            return this;
        }

        private Builder numRpcThreads(String __value) {
            return this.numRpcThreads(Integer.valueOf(__value));
        }

        public Builder zookeeperserver(Zookeeperserver.Builder __builder) {
            this.zookeeperserver.add(__builder);
            return this;
        }

        public Builder zookeeperserver(List<Zookeeperserver.Builder> __builders) {
            this.zookeeperserver = __builders;
            return this;
        }

        public Builder zookeeper(Zookeeper.Builder __builder) {
            this.zookeeper = __builder;
            return this;
        }

        public Builder zookeeperLocalhostAffinity(boolean __value) {
            this.zookeeperLocalhostAffinity = __value;
            return this;
        }

        private Builder zookeeperLocalhostAffinity(String __value) {
            return this.zookeeperLocalhostAffinity(Boolean.valueOf(__value));
        }

        public Builder configModelPluginDir(String __value) {
            this.configModelPluginDir.add(__value);
            return this;
        }

        public Builder configModelPluginDir(Collection<String> __values) {
            this.configModelPluginDir.addAll(__values);
            return this;
        }

        public Builder configServerDBDir(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.configServerDBDir = __value;
            return this;
        }

        public Builder configDefinitionsDir(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.configDefinitionsDir = __value;
            return this;
        }

        public Builder fileReferencesDir(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.fileReferencesDir = __value;
            return this;
        }

        public Builder sessionLifetime(long __value) {
            this.sessionLifetime = __value;
            return this;
        }

        private Builder sessionLifetime(String __value) {
            return this.sessionLifetime(Long.valueOf(__value));
        }

        public Builder masterGeneration(long __value) {
            this.masterGeneration = __value;
            return this;
        }

        private Builder masterGeneration(String __value) {
            return this.masterGeneration(Long.valueOf(__value));
        }

        public Builder multitenant(boolean __value) {
            this.multitenant = __value;
            return this;
        }

        private Builder multitenant(String __value) {
            return this.multitenant(Boolean.valueOf(__value));
        }

        public Builder numDelayedResponseThreads(int __value) {
            this.numDelayedResponseThreads = __value;
            return this;
        }

        private Builder numDelayedResponseThreads(String __value) {
            return this.numDelayedResponseThreads(Integer.valueOf(__value));
        }

        public Builder serverId(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.serverId = __value;
            return this;
        }

        public Builder hostedVespa(boolean __value) {
            this.hostedVespa = __value;
            return this;
        }

        private Builder hostedVespa(String __value) {
            return this.hostedVespa(Boolean.valueOf(__value));
        }

        public Builder numParallelTenantLoaders(int __value) {
            this.numParallelTenantLoaders = __value;
            return this;
        }

        private Builder numParallelTenantLoaders(String __value) {
            return this.numParallelTenantLoaders(Integer.valueOf(__value));
        }

        public Builder applicationDirectory(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.applicationDirectory = __value;
            return this;
        }

        public Builder cloud(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.cloud = __value;
            return this;
        }

        public Builder environment(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.environment = __value;
            return this;
        }

        public Builder region(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.region = __value;
            return this;
        }

        public Builder system(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.system = __value;
            return this;
        }

        public Builder defaultFlavor(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.defaultFlavor = __value;
            return this;
        }

        public Builder defaultAdminFlavor(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.defaultAdminFlavor = __value;
            return this;
        }

        public Builder defaultContainerFlavor(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.defaultContainerFlavor = __value;
            return this;
        }

        public Builder defaultContentFlavor(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.defaultContentFlavor = __value;
            return this;
        }

        public Builder maxgetconfigclients(int __value) {
            this.maxgetconfigclients = __value;
            return this;
        }

        private Builder maxgetconfigclients(String __value) {
            return this.maxgetconfigclients(Integer.valueOf(__value));
        }

        public Builder maxoutputbuffersize(int __value) {
            this.maxoutputbuffersize = __value;
            return this;
        }

        private Builder maxoutputbuffersize(String __value) {
            return this.maxoutputbuffersize(Integer.valueOf(__value));
        }

        public Builder useVespaVersionInRequest(boolean __value) {
            this.useVespaVersionInRequest = __value;
            return this;
        }

        private Builder useVespaVersionInRequest(String __value) {
            return this.useVespaVersionInRequest(Boolean.valueOf(__value));
        }

        public Builder payloadCompressionType(PayloadCompressionType.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.payloadCompressionType = __value;
            return this;
        }

        private Builder payloadCompressionType(String __value) {
            return this.payloadCompressionType(PayloadCompressionType.Enum.valueOf(__value));
        }

        public Builder loadBalancerAddress(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.loadBalancerAddress = __value;
            return this;
        }

        public Builder athenzDnsSuffix(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.athenzDnsSuffix = __value;
            return this;
        }

        public Builder ztsUrl(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.ztsUrl = __value;
            return this;
        }

        public Builder nodeAdminInContainer(boolean __value) {
            this.nodeAdminInContainer = __value;
            return this;
        }

        private Builder nodeAdminInContainer(String __value) {
            return this.nodeAdminInContainer(Boolean.valueOf(__value));
        }

        public Builder maintainerIntervalMinutes(int __value) {
            this.maintainerIntervalMinutes = __value;
            return this;
        }

        private Builder maintainerIntervalMinutes(String __value) {
            return this.maintainerIntervalMinutes(Integer.valueOf(__value));
        }

        public Builder tenantsMaintainerIntervalMinutes(int __value) {
            this.tenantsMaintainerIntervalMinutes = __value;
            return this;
        }

        private Builder tenantsMaintainerIntervalMinutes(String __value) {
            return this.tenantsMaintainerIntervalMinutes(Integer.valueOf(__value));
        }

        public Builder maxDurationOfBootstrap(long __value) {
            this.maxDurationOfBootstrap = __value;
            return this;
        }

        private Builder maxDurationOfBootstrap(String __value) {
            return this.maxDurationOfBootstrap(Long.valueOf(__value));
        }

        public Builder sleepTimeWhenRedeployingFails(long __value) {
            this.sleepTimeWhenRedeployingFails = __value;
            return this;
        }

        private Builder sleepTimeWhenRedeployingFails(String __value) {
            return this.sleepTimeWhenRedeployingFails(Long.valueOf(__value));
        }

        public Builder buildMinimalSetOfConfigModels(boolean __value) {
            this.buildMinimalSetOfConfigModels = __value;
            return this;
        }

        private Builder buildMinimalSetOfConfigModels(String __value) {
            return this.buildMinimalSetOfConfigModels(Boolean.valueOf(__value));
        }

        public Builder throwIfBootstrappingTenantRepoFails(boolean __value) {
            this.throwIfBootstrappingTenantRepoFails = __value;
            return this;
        }

        private Builder throwIfBootstrappingTenantRepoFails(String __value) {
            return this.throwIfBootstrappingTenantRepoFails(Boolean.valueOf(__value));
        }

        public Builder canReturnEmptySentinelConfig(boolean __value) {
            this.canReturnEmptySentinelConfig = __value;
            return this;
        }

        private Builder canReturnEmptySentinelConfig(String __value) {
            return this.canReturnEmptySentinelConfig(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ConfigserverConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ConfigserverConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ConfigserverConfig.CONFIG_DEF_NAMESPACE;
        }

        public ConfigserverConfig build() {
            return new ConfigserverConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

