/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.reindexing;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class ReindexingConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "9e9dcbdee82e6947b16cdba72edbf451";
    public static final String CONFIG_DEF_NAME = "reindexing";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.reindexing";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.reindexing", "enabled bool default=false", "clusterName string", "status{}.readyAtMillis long"};
    private final BooleanNode enabled;
    private final StringNode clusterName;
    private final Map<String, Status> status;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ReindexingConfig(Builder builder) {
        this(builder, true);
    }

    private ReindexingConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for reindexing must be initialized: " + builder.__uninitialized);
        }
        this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
        this.clusterName = builder.clusterName == null ? new StringNode() : new StringNode(builder.clusterName);
        this.status = Status.createMap(builder.status);
    }

    public boolean enabled() {
        return this.enabled.value();
    }

    public String clusterName() {
        return this.clusterName.value();
    }

    public Map<String, Status> status() {
        return Collections.unmodifiableMap(this.status);
    }

    public Status status(String key) {
        return this.status.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ReindexingConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Status
    extends InnerNode {
        private final LongNode readyAtMillis;

        public Status(Builder builder) {
            this(builder, true);
        }

        private Status(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for reindexing.status{} must be initialized: " + builder.__uninitialized);
            }
            this.readyAtMillis = builder.readyAtMillis == null ? new LongNode() : new LongNode(builder.readyAtMillis.longValue());
        }

        public long readyAtMillis() {
            return this.readyAtMillis.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Status newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("status");
            return changes;
        }

        private static Map<String, Status> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Status> ret = new LinkedHashMap<String, Status>();
            for (String key : builders.keySet()) {
                ret.put(key, new Status(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("readyAtMillis"));
            private Long readyAtMillis = null;

            public Builder() {
            }

            public Builder(Status config) {
                this.readyAtMillis(config.readyAtMillis());
            }

            private Builder override(Builder __superior) {
                if (__superior.readyAtMillis != null) {
                    this.readyAtMillis(__superior.readyAtMillis);
                }
                return this;
            }

            public Builder readyAtMillis(long __value) {
                this.readyAtMillis = __value;
                this.__uninitialized.remove("readyAtMillis");
                return this;
            }

            private Builder readyAtMillis(String __value) {
                return this.readyAtMillis(Long.valueOf(__value));
            }

            public Status build() {
                return new Status(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("clusterName"));
        private Boolean enabled = null;
        private String clusterName = null;
        public Map<String, Status.Builder> status = new LinkedHashMap<String, Status.Builder>();

        public Builder() {
        }

        public Builder(ReindexingConfig config) {
            this.enabled(config.enabled());
            this.clusterName(config.clusterName());
            for (Map.Entry<String, Status> __entry : config.status().entrySet()) {
                this.status(__entry.getKey(), new Status.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.enabled != null) {
                this.enabled(__superior.enabled);
            }
            if (__superior.clusterName != null) {
                this.clusterName(__superior.clusterName);
            }
            this.status(__superior.status);
            return this;
        }

        public Builder enabled(boolean __value) {
            this.enabled = __value;
            return this;
        }

        private Builder enabled(String __value) {
            return this.enabled(Boolean.valueOf(__value));
        }

        public Builder clusterName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.clusterName = __value;
            this.__uninitialized.remove("clusterName");
            return this;
        }

        public Builder status(String __key, Status.Builder __value) {
            this.status.put(__key, __value);
            return this;
        }

        public Builder status(Map<String, Status.Builder> __values) {
            this.status.putAll(__values);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ReindexingConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ReindexingConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ReindexingConfig.CONFIG_DEF_NAMESPACE;
        }

        public ReindexingConfig build() {
            return new ReindexingConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

