/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class YmonConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "1f22eebf732cd8cca400a38d3809fdbd";
    public static final String CONFIG_DEF_NAME = "ymon";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "services[].servicetype string default=\"(unknownservicetype)\"", "services[].ymonname string default=\"(unknownymonname)\"", "services[].hosts[] string"};
    private final InnerNodeVector<Services> services;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public YmonConfig(Builder builder) {
        this(builder, true);
    }

    private YmonConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for ymon must be initialized: " + builder.__uninitialized);
        }
        this.services = Services.createVector(builder.services);
    }

    public List<Services> services() {
        return this.services;
    }

    public Services services(int i) {
        return (Services)((Object)this.services.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(YmonConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Services
    extends InnerNode {
        private final StringNode servicetype;
        private final StringNode ymonname;
        private final LeafNodeVector<String, StringNode> hosts;

        public Services(Builder builder) {
            this(builder, true);
        }

        private Services(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for ymon.services[] must be initialized: " + builder.__uninitialized);
            }
            this.servicetype = builder.servicetype == null ? new StringNode("(unknownservicetype)") : new StringNode(builder.servicetype);
            this.ymonname = builder.ymonname == null ? new StringNode("(unknownymonname)") : new StringNode(builder.ymonname);
            this.hosts = new LeafNodeVector(builder.hosts, (LeafNode)new StringNode());
        }

        public String servicetype() {
            return this.servicetype.value();
        }

        public String ymonname() {
            return this.ymonname.value();
        }

        public List<String> hosts() {
            return this.hosts.asList();
        }

        public String hosts(int i) {
            return ((StringNode)this.hosts.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Services newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("services");
            return changes;
        }

        private static InnerNodeVector<Services> createVector(List<Builder> builders) {
            ArrayList<Services> elems = new ArrayList<Services>();
            for (Builder b : builders) {
                elems.add(new Services(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String servicetype = null;
            private String ymonname = null;
            public List<String> hosts = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Services config) {
                this.servicetype(config.servicetype());
                this.ymonname(config.ymonname());
                this.hosts(config.hosts());
            }

            private Builder override(Builder __superior) {
                if (__superior.servicetype != null) {
                    this.servicetype(__superior.servicetype);
                }
                if (__superior.ymonname != null) {
                    this.ymonname(__superior.ymonname);
                }
                if (!__superior.hosts.isEmpty()) {
                    this.hosts.addAll(__superior.hosts);
                }
                return this;
            }

            public Builder servicetype(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.servicetype = __value;
                return this;
            }

            public Builder ymonname(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.ymonname = __value;
                return this;
            }

            public Builder hosts(String __value) {
                this.hosts.add(__value);
                return this;
            }

            public Builder hosts(Collection<String> __values) {
                this.hosts.addAll(__values);
                return this;
            }

            public Services build() {
                return new Services(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Services.Builder> services = new ArrayList<Services.Builder>();

        public Builder() {
        }

        public Builder(YmonConfig config) {
            for (Services s : config.services()) {
                this.services(new Services.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.services.isEmpty()) {
                this.services.addAll(__superior.services);
            }
            return this;
        }

        public Builder services(Services.Builder __builder) {
            this.services.add(__builder);
            return this;
        }

        public Builder services(List<Services.Builder> __builders) {
            this.services = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return YmonConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return YmonConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return YmonConfig.CONFIG_DEF_NAMESPACE;
        }

        public YmonConfig build() {
            return new YmonConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

