/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ClusterListConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "60753c6ae77aed1d217248dc8118fba7";
    public static final String CONFIG_DEF_NAME = "cluster-list";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "storage[].name string", "storage[].configid string default=\"\""};
    private final InnerNodeVector<Storage> storage;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ClusterListConfig(Builder builder) {
        this(builder, true);
    }

    private ClusterListConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for cluster-list must be initialized: " + builder.__uninitialized);
        }
        this.storage = Storage.createVector(builder.storage);
    }

    public List<Storage> storage() {
        return this.storage;
    }

    public Storage storage(int i) {
        return (Storage)((Object)this.storage.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ClusterListConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Storage
    extends InnerNode {
        private final StringNode name;
        private final StringNode configid;

        public Storage(Builder builder) {
            this(builder, true);
        }

        private Storage(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for cluster-list.storage[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.configid = builder.configid == null ? new StringNode(ClusterListConfig.CONFIG_DEF_VERSION) : new StringNode(builder.configid);
        }

        public String name() {
            return this.name.value();
        }

        public String configid() {
            return this.configid.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Storage newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("storage");
            return changes;
        }

        private static InnerNodeVector<Storage> createVector(List<Builder> builders) {
            ArrayList<Storage> elems = new ArrayList<Storage>();
            for (Builder b : builders) {
                elems.add(new Storage(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            private String configid = null;

            public Builder() {
            }

            public Builder(Storage config) {
                this.name(config.name());
                this.configid(config.configid());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.configid != null) {
                    this.configid(__superior.configid);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder configid(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.configid = __value;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Storage.Builder> storage = new ArrayList<Storage.Builder>();

        public Builder() {
        }

        public Builder(ClusterListConfig config) {
            for (Storage s : config.storage()) {
                this.storage(new Storage.Builder(s));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.storage.isEmpty()) {
                this.storage.addAll(__superior.storage);
            }
            return this;
        }

        public Builder storage(Storage.Builder __builder) {
            this.storage.add(__builder);
            return this;
        }

        public Builder storage(List<Storage.Builder> __builders) {
            this.storage = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ClusterListConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ClusterListConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ClusterListConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

