/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class AttributesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "a411f52082186f0f0d4613373edb0fc9";
    public static final String CONFIG_DEF_NAME = "attributes";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search", "attribute[].name string", "attribute[].datatype enum { STRING, UINT1, UINT2, UINT4, INT8, INT16, INT32, INT64, FLOAT, DOUBLE, PREDICATE, TENSOR, REFERENCE, NONE } default=NONE", "attribute[].collectiontype enum { SINGLE, ARRAY, WEIGHTEDSET } default=SINGLE", "attribute[].removeifzero bool default=false", "attribute[].createifnonexistent bool default=false", "attribute[].fastsearch bool default=false", "attribute[].huge bool default=false", "attribute[].ismutable bool default=false", "attribute[].sortascending bool default=true", "attribute[].sortfunction enum { RAW, LOWERCASE, UCA } default=UCA", "attribute[].sortstrength enum { PRIMARY, SECONDARY, TERTIARY, QUATERNARY, IDENTICAL } default=PRIMARY", "attribute[].sortlocale string default=\"\"", "attribute[].enablebitvectors bool default=false", "attribute[].enableonlybitvector bool default=false", "attribute[].fastaccess bool default=false", "attribute[].arity int default=8", "attribute[].lowerbound long default=-9223372036854775808", "attribute[].upperbound long default=9223372036854775807", "attribute[].densepostinglistthreshold double default=0.40", "attribute[].tensortype string default=\"\"", "attribute[].imported bool default=false"};
    private final InnerNodeVector<Attribute> attribute;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public AttributesConfig(Builder builder) {
        this(builder, true);
    }

    private AttributesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for attributes must be initialized: " + builder.__uninitialized);
        }
        this.attribute = Attribute.createVector(builder.attribute);
    }

    public List<Attribute> attribute() {
        return this.attribute;
    }

    public Attribute attribute(int i) {
        return (Attribute)((Object)this.attribute.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(AttributesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Attribute
    extends InnerNode {
        private final StringNode name;
        private final Datatype datatype;
        private final Collectiontype collectiontype;
        private final BooleanNode removeifzero;
        private final BooleanNode createifnonexistent;
        private final BooleanNode fastsearch;
        private final BooleanNode huge;
        private final BooleanNode ismutable;
        private final BooleanNode sortascending;
        private final Sortfunction sortfunction;
        private final Sortstrength sortstrength;
        private final StringNode sortlocale;
        private final BooleanNode enablebitvectors;
        private final BooleanNode enableonlybitvector;
        private final BooleanNode fastaccess;
        private final IntegerNode arity;
        private final LongNode lowerbound;
        private final LongNode upperbound;
        private final DoubleNode densepostinglistthreshold;
        private final StringNode tensortype;
        private final BooleanNode imported;

        public Attribute(Builder builder) {
            this(builder, true);
        }

        private Attribute(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for attributes.attribute[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.datatype = builder.datatype == null ? new Datatype(Datatype.NONE) : new Datatype(builder.datatype);
            this.collectiontype = builder.collectiontype == null ? new Collectiontype(Collectiontype.SINGLE) : new Collectiontype(builder.collectiontype);
            this.removeifzero = builder.removeifzero == null ? new BooleanNode(false) : new BooleanNode(builder.removeifzero.booleanValue());
            this.createifnonexistent = builder.createifnonexistent == null ? new BooleanNode(false) : new BooleanNode(builder.createifnonexistent.booleanValue());
            this.fastsearch = builder.fastsearch == null ? new BooleanNode(false) : new BooleanNode(builder.fastsearch.booleanValue());
            this.huge = builder.huge == null ? new BooleanNode(false) : new BooleanNode(builder.huge.booleanValue());
            this.ismutable = builder.ismutable == null ? new BooleanNode(false) : new BooleanNode(builder.ismutable.booleanValue());
            this.sortascending = builder.sortascending == null ? new BooleanNode(true) : new BooleanNode(builder.sortascending.booleanValue());
            this.sortfunction = builder.sortfunction == null ? new Sortfunction(Sortfunction.UCA) : new Sortfunction(builder.sortfunction);
            this.sortstrength = builder.sortstrength == null ? new Sortstrength(Sortstrength.PRIMARY) : new Sortstrength(builder.sortstrength);
            this.sortlocale = builder.sortlocale == null ? new StringNode(AttributesConfig.CONFIG_DEF_VERSION) : new StringNode(builder.sortlocale);
            this.enablebitvectors = builder.enablebitvectors == null ? new BooleanNode(false) : new BooleanNode(builder.enablebitvectors.booleanValue());
            this.enableonlybitvector = builder.enableonlybitvector == null ? new BooleanNode(false) : new BooleanNode(builder.enableonlybitvector.booleanValue());
            this.fastaccess = builder.fastaccess == null ? new BooleanNode(false) : new BooleanNode(builder.fastaccess.booleanValue());
            this.arity = builder.arity == null ? new IntegerNode(8) : new IntegerNode(builder.arity.intValue());
            this.lowerbound = builder.lowerbound == null ? new LongNode(Long.MIN_VALUE) : new LongNode(builder.lowerbound.longValue());
            this.upperbound = builder.upperbound == null ? new LongNode(Long.MAX_VALUE) : new LongNode(builder.upperbound.longValue());
            this.densepostinglistthreshold = builder.densepostinglistthreshold == null ? new DoubleNode(0.4) : new DoubleNode(builder.densepostinglistthreshold.doubleValue());
            this.tensortype = builder.tensortype == null ? new StringNode(AttributesConfig.CONFIG_DEF_VERSION) : new StringNode(builder.tensortype);
            this.imported = builder.imported == null ? new BooleanNode(false) : new BooleanNode(builder.imported.booleanValue());
        }

        public String name() {
            return this.name.value();
        }

        public Datatype.Enum datatype() {
            return (Datatype.Enum)((Object)this.datatype.value());
        }

        public Collectiontype.Enum collectiontype() {
            return (Collectiontype.Enum)((Object)this.collectiontype.value());
        }

        public boolean removeifzero() {
            return this.removeifzero.value();
        }

        public boolean createifnonexistent() {
            return this.createifnonexistent.value();
        }

        public boolean fastsearch() {
            return this.fastsearch.value();
        }

        public boolean huge() {
            return this.huge.value();
        }

        public boolean ismutable() {
            return this.ismutable.value();
        }

        public boolean sortascending() {
            return this.sortascending.value();
        }

        public Sortfunction.Enum sortfunction() {
            return (Sortfunction.Enum)((Object)this.sortfunction.value());
        }

        public Sortstrength.Enum sortstrength() {
            return (Sortstrength.Enum)((Object)this.sortstrength.value());
        }

        public String sortlocale() {
            return this.sortlocale.value();
        }

        public boolean enablebitvectors() {
            return this.enablebitvectors.value();
        }

        public boolean enableonlybitvector() {
            return this.enableonlybitvector.value();
        }

        public boolean fastaccess() {
            return this.fastaccess.value();
        }

        public int arity() {
            return this.arity.value();
        }

        public long lowerbound() {
            return this.lowerbound.value();
        }

        public long upperbound() {
            return this.upperbound.value();
        }

        public double densepostinglistthreshold() {
            return this.densepostinglistthreshold.value();
        }

        public String tensortype() {
            return this.tensortype.value();
        }

        public boolean imported() {
            return this.imported.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
            return changes;
        }

        private static InnerNodeVector<Attribute> createVector(List<Builder> builders) {
            ArrayList<Attribute> elems = new ArrayList<Attribute>();
            for (Builder b : builders) {
                elems.add(new Attribute(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Sortstrength
        extends EnumNode<Enum> {
            public static final Enum PRIMARY = Enum.PRIMARY;
            public static final Enum SECONDARY = Enum.SECONDARY;
            public static final Enum TERTIARY = Enum.TERTIARY;
            public static final Enum QUATERNARY = Enum.QUATERNARY;
            public static final Enum IDENTICAL = Enum.IDENTICAL;

            public Sortstrength() {
                this.value = null;
            }

            public Sortstrength(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                PRIMARY,
                SECONDARY,
                TERTIARY,
                QUATERNARY,
                IDENTICAL;

            }
        }

        public static final class Sortfunction
        extends EnumNode<Enum> {
            public static final Enum RAW = Enum.RAW;
            public static final Enum LOWERCASE = Enum.LOWERCASE;
            public static final Enum UCA = Enum.UCA;

            public Sortfunction() {
                this.value = null;
            }

            public Sortfunction(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                RAW,
                LOWERCASE,
                UCA;

            }
        }

        public static final class Collectiontype
        extends EnumNode<Enum> {
            public static final Enum SINGLE = Enum.SINGLE;
            public static final Enum ARRAY = Enum.ARRAY;
            public static final Enum WEIGHTEDSET = Enum.WEIGHTEDSET;

            public Collectiontype() {
                this.value = null;
            }

            public Collectiontype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                SINGLE,
                ARRAY,
                WEIGHTEDSET;

            }
        }

        public static final class Datatype
        extends EnumNode<Enum> {
            public static final Enum STRING = Enum.STRING;
            public static final Enum UINT1 = Enum.UINT1;
            public static final Enum UINT2 = Enum.UINT2;
            public static final Enum UINT4 = Enum.UINT4;
            public static final Enum INT8 = Enum.INT8;
            public static final Enum INT16 = Enum.INT16;
            public static final Enum INT32 = Enum.INT32;
            public static final Enum INT64 = Enum.INT64;
            public static final Enum FLOAT = Enum.FLOAT;
            public static final Enum DOUBLE = Enum.DOUBLE;
            public static final Enum PREDICATE = Enum.PREDICATE;
            public static final Enum TENSOR = Enum.TENSOR;
            public static final Enum REFERENCE = Enum.REFERENCE;
            public static final Enum NONE = Enum.NONE;

            public Datatype() {
                this.value = null;
            }

            public Datatype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                STRING,
                UINT1,
                UINT2,
                UINT4,
                INT8,
                INT16,
                INT32,
                INT64,
                FLOAT,
                DOUBLE,
                PREDICATE,
                TENSOR,
                REFERENCE,
                NONE;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            private Datatype.Enum datatype = null;
            private Collectiontype.Enum collectiontype = null;
            private Boolean removeifzero = null;
            private Boolean createifnonexistent = null;
            private Boolean fastsearch = null;
            private Boolean huge = null;
            private Boolean ismutable = null;
            private Boolean sortascending = null;
            private Sortfunction.Enum sortfunction = null;
            private Sortstrength.Enum sortstrength = null;
            private String sortlocale = null;
            private Boolean enablebitvectors = null;
            private Boolean enableonlybitvector = null;
            private Boolean fastaccess = null;
            private Integer arity = null;
            private Long lowerbound = null;
            private Long upperbound = null;
            private Double densepostinglistthreshold = null;
            private String tensortype = null;
            private Boolean imported = null;

            public Builder() {
            }

            public Builder(Attribute config) {
                this.name(config.name());
                this.datatype(config.datatype());
                this.collectiontype(config.collectiontype());
                this.removeifzero(config.removeifzero());
                this.createifnonexistent(config.createifnonexistent());
                this.fastsearch(config.fastsearch());
                this.huge(config.huge());
                this.ismutable(config.ismutable());
                this.sortascending(config.sortascending());
                this.sortfunction(config.sortfunction());
                this.sortstrength(config.sortstrength());
                this.sortlocale(config.sortlocale());
                this.enablebitvectors(config.enablebitvectors());
                this.enableonlybitvector(config.enableonlybitvector());
                this.fastaccess(config.fastaccess());
                this.arity(config.arity());
                this.lowerbound(config.lowerbound());
                this.upperbound(config.upperbound());
                this.densepostinglistthreshold(config.densepostinglistthreshold());
                this.tensortype(config.tensortype());
                this.imported(config.imported());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.datatype != null) {
                    this.datatype(__superior.datatype);
                }
                if (__superior.collectiontype != null) {
                    this.collectiontype(__superior.collectiontype);
                }
                if (__superior.removeifzero != null) {
                    this.removeifzero(__superior.removeifzero);
                }
                if (__superior.createifnonexistent != null) {
                    this.createifnonexistent(__superior.createifnonexistent);
                }
                if (__superior.fastsearch != null) {
                    this.fastsearch(__superior.fastsearch);
                }
                if (__superior.huge != null) {
                    this.huge(__superior.huge);
                }
                if (__superior.ismutable != null) {
                    this.ismutable(__superior.ismutable);
                }
                if (__superior.sortascending != null) {
                    this.sortascending(__superior.sortascending);
                }
                if (__superior.sortfunction != null) {
                    this.sortfunction(__superior.sortfunction);
                }
                if (__superior.sortstrength != null) {
                    this.sortstrength(__superior.sortstrength);
                }
                if (__superior.sortlocale != null) {
                    this.sortlocale(__superior.sortlocale);
                }
                if (__superior.enablebitvectors != null) {
                    this.enablebitvectors(__superior.enablebitvectors);
                }
                if (__superior.enableonlybitvector != null) {
                    this.enableonlybitvector(__superior.enableonlybitvector);
                }
                if (__superior.fastaccess != null) {
                    this.fastaccess(__superior.fastaccess);
                }
                if (__superior.arity != null) {
                    this.arity(__superior.arity);
                }
                if (__superior.lowerbound != null) {
                    this.lowerbound(__superior.lowerbound);
                }
                if (__superior.upperbound != null) {
                    this.upperbound(__superior.upperbound);
                }
                if (__superior.densepostinglistthreshold != null) {
                    this.densepostinglistthreshold(__superior.densepostinglistthreshold);
                }
                if (__superior.tensortype != null) {
                    this.tensortype(__superior.tensortype);
                }
                if (__superior.imported != null) {
                    this.imported(__superior.imported);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder datatype(Datatype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.datatype = __value;
                return this;
            }

            private Builder datatype(String __value) {
                return this.datatype(Datatype.Enum.valueOf(__value));
            }

            public Builder collectiontype(Collectiontype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.collectiontype = __value;
                return this;
            }

            private Builder collectiontype(String __value) {
                return this.collectiontype(Collectiontype.Enum.valueOf(__value));
            }

            public Builder removeifzero(boolean __value) {
                this.removeifzero = __value;
                return this;
            }

            private Builder removeifzero(String __value) {
                return this.removeifzero(Boolean.valueOf(__value));
            }

            public Builder createifnonexistent(boolean __value) {
                this.createifnonexistent = __value;
                return this;
            }

            private Builder createifnonexistent(String __value) {
                return this.createifnonexistent(Boolean.valueOf(__value));
            }

            public Builder fastsearch(boolean __value) {
                this.fastsearch = __value;
                return this;
            }

            private Builder fastsearch(String __value) {
                return this.fastsearch(Boolean.valueOf(__value));
            }

            public Builder huge(boolean __value) {
                this.huge = __value;
                return this;
            }

            private Builder huge(String __value) {
                return this.huge(Boolean.valueOf(__value));
            }

            public Builder ismutable(boolean __value) {
                this.ismutable = __value;
                return this;
            }

            private Builder ismutable(String __value) {
                return this.ismutable(Boolean.valueOf(__value));
            }

            public Builder sortascending(boolean __value) {
                this.sortascending = __value;
                return this;
            }

            private Builder sortascending(String __value) {
                return this.sortascending(Boolean.valueOf(__value));
            }

            public Builder sortfunction(Sortfunction.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.sortfunction = __value;
                return this;
            }

            private Builder sortfunction(String __value) {
                return this.sortfunction(Sortfunction.Enum.valueOf(__value));
            }

            public Builder sortstrength(Sortstrength.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.sortstrength = __value;
                return this;
            }

            private Builder sortstrength(String __value) {
                return this.sortstrength(Sortstrength.Enum.valueOf(__value));
            }

            public Builder sortlocale(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.sortlocale = __value;
                return this;
            }

            public Builder enablebitvectors(boolean __value) {
                this.enablebitvectors = __value;
                return this;
            }

            private Builder enablebitvectors(String __value) {
                return this.enablebitvectors(Boolean.valueOf(__value));
            }

            public Builder enableonlybitvector(boolean __value) {
                this.enableonlybitvector = __value;
                return this;
            }

            private Builder enableonlybitvector(String __value) {
                return this.enableonlybitvector(Boolean.valueOf(__value));
            }

            public Builder fastaccess(boolean __value) {
                this.fastaccess = __value;
                return this;
            }

            private Builder fastaccess(String __value) {
                return this.fastaccess(Boolean.valueOf(__value));
            }

            public Builder arity(int __value) {
                this.arity = __value;
                return this;
            }

            private Builder arity(String __value) {
                return this.arity(Integer.valueOf(__value));
            }

            public Builder lowerbound(long __value) {
                this.lowerbound = __value;
                return this;
            }

            private Builder lowerbound(String __value) {
                return this.lowerbound(Long.valueOf(__value));
            }

            public Builder upperbound(long __value) {
                this.upperbound = __value;
                return this;
            }

            private Builder upperbound(String __value) {
                return this.upperbound(Long.valueOf(__value));
            }

            public Builder densepostinglistthreshold(double __value) {
                this.densepostinglistthreshold = __value;
                return this;
            }

            private Builder densepostinglistthreshold(String __value) {
                return this.densepostinglistthreshold(Double.valueOf(__value));
            }

            public Builder tensortype(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.tensortype = __value;
                return this;
            }

            public Builder imported(boolean __value) {
                this.imported = __value;
                return this;
            }

            private Builder imported(String __value) {
                return this.imported(Boolean.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Attribute.Builder> attribute = new ArrayList<Attribute.Builder>();

        public Builder() {
        }

        public Builder(AttributesConfig config) {
            for (Attribute a : config.attribute()) {
                this.attribute(new Attribute.Builder(a));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.attribute.isEmpty()) {
                this.attribute.addAll(__superior.attribute);
            }
            return this;
        }

        public Builder attribute(Attribute.Builder __builder) {
            this.attribute.add(__builder);
            return this;
        }

        public Builder attribute(List<Attribute.Builder> __builders) {
            this.attribute = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return AttributesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return AttributesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return AttributesConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

